/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.dnd;

import oracle.bpm.geom.Point;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiPeer;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.peer.DropTargetHandlerPeer;
import oracle.bpm.ui.peer.Peer;

public abstract class DropTargetHandler
extends UiPeer {
    private DndAction actions;
    private Transfer[] transfers;

    public DropTargetHandler(UiComponent target, DndAction uiActions) {
        this(target, uiActions, Transfer.NONE);
    }

    public DropTargetHandler(UiComponent target, DndAction uiActions, Transfer[] acceptedTypes) {
        this.actions = uiActions;
        this.transfers = acceptedTypes;
        this.getPeer().createDropTarget(target.getComponentPeer());
    }

    public abstract void drop(Object var1, Transfer var2, Point var3, DndAction var4);

    public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
        return true;
    }

    public Transfer[] getTransfers() {
        return this.transfers;
    }

    public void dragExit() {
    }

    public DndAction getActions() {
        return this.actions;
    }

    @Override
    public DropTargetHandlerPeer getPeer() {
        return (DropTargetHandlerPeer)super.getPeer();
    }

    @Override
    protected Peer createPeer() {
        return Ui.getUiFactory().createDropTargetHandlerPeer();
    }
}

