/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.border;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.Border;

public class ThinBorder
extends Border {
    protected Color highlight;
    protected Color shadow;
    protected int type = 0;
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    public static final int thickness = 1;

    public ThinBorder() {
        this(1, null, null);
    }

    public ThinBorder(int type) {
        this(type, null, null);
    }

    public ThinBorder(int type, Color highlight, Color shadow) {
        super(null);
        this.type = type;
        this.highlight = highlight;
        this.shadow = shadow;
    }

    public Color getHightlightColor(UiComponent c) {
        if (this.highlight == null) {
            this.highlight = c.getBackground().brighter();
        }
        return this.highlight;
    }

    public Color getShadowColor(UiComponent c) {
        if (this.shadow == null) {
            this.shadow = c.getBackground().darker();
        }
        return this.shadow;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public Insets getBorderInsets(UiComponent c) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public void paintBorder(UiComponent uiComponent, Graphics g, int x, int y, int width, int height) {
        Color hi = this.type == 0 ? this.getHightlightColor(uiComponent) : this.getShadowColor(uiComponent);
        Color lo = this.type == 0 ? this.getShadowColor(uiComponent) : this.getHightlightColor(uiComponent);
        for (int i = 0; i >= 0; --i) {
            g.setForeground(hi);
            g.drawLine(x + i, y + i, x + width - i - 1, y + i);
            g.drawLine(x + i, y + i, x + i, x + height - i - 1);
            g.setForeground(lo);
            g.drawLine(x + width - i - 1, y + i, x + width - i - 1, y + height - i - 1);
            g.drawLine(x + i, y + height - i - 1, x + width - i - 1, y + height - i - 1);
        }
    }
}

