/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.border;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.peer.swing.AwtConverter;

public class EtchedBorder
extends Border {
    protected int etchType;
    protected Color highlight;
    protected Color shadow;
    public static final int RAISED = 0;
    public static final int LOWERED = 1;

    public EtchedBorder() {
        this(1);
    }

    public EtchedBorder(int etchType) {
        this(etchType, null, null);
    }

    public EtchedBorder(Color highlight, Color shadow) {
        this(1, highlight, shadow);
    }

    public EtchedBorder(int etchType, Color highlight, Color shadow) {
        this.etchType = etchType;
        this.highlight = highlight;
        this.shadow = shadow;
    }

    @Override
    public void paintBorder(UiComponent component, Graphics graphics, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        graphics.translate(x, y);
        graphics.setForeground(this.etchType == 1 ? this.getShadowColor(component) : this.getHighlightColor(component));
        graphics.drawRect(0, 0, w - 2, h - 2);
        graphics.setForeground(this.etchType == 1 ? this.getHighlightColor(component) : this.getShadowColor(component));
        graphics.drawLine(1, h - 3, 1, 1);
        graphics.drawLine(1, 1, w - 3, 1);
        graphics.drawLine(0, h - 1, w - 1, h - 1);
        graphics.drawLine(w - 1, h - 1, w - 1, 0);
        graphics.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(UiComponent component) {
        return new Insets(2, 2, 2, 2);
    }

    public Insets getBorderInsets(UiComponent component, Insets insets) {
        return this.getBorderInsets(component);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public int getEtchType() {
        return this.etchType;
    }

    public Color getHighlightColor(UiComponent component) {
        Color result;
        if (this.highlight != null) {
            result = this.highlight;
        } else {
            Color background = component.getBackground();
            if (background == null) {
                throw new IllegalStateException("Component does not have background: " + component);
            }
            result = background.brighter();
        }
        return result;
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor(UiComponent component) {
        return this.shadow != null ? this.shadow : component.getBackground().darker();
    }

    public Color getShadowColor() {
        return this.shadow;
    }

    @Override
    public javax.swing.border.Border asSwing() {
        return new javax.swing.border.EtchedBorder(this.etchType, AwtConverter.toAwt(this.getHighlightColor()), AwtConverter.toAwt(this.getShadowColor()));
    }
}

