/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.border;

import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.Border;

public class CompoundBorder
extends Border {
    protected Border insideBorder;
    protected Border outsideBorder;

    public CompoundBorder() {
        this.outsideBorder = null;
        this.insideBorder = null;
    }

    public CompoundBorder(Border outside, Border inside) {
        this.insideBorder = inside;
        this.outsideBorder = outside;
    }

    @Override
    public boolean isBorderOpaque() {
        return this.insideBorder == null || this.insideBorder.isBorderOpaque() && (this.outsideBorder == null || this.outsideBorder.isBorderOpaque());
    }

    @Override
    public void paintBorder(UiComponent c, Graphics g, int x, int y, int width, int height) {
        int pw = width;
        int ph = height;
        int px = x;
        int py = y;
        if (this.insideBorder != null) {
            this.insideBorder.paintBorder(c, g, px, py, pw, ph);
        }
        if (this.outsideBorder != null) {
            this.outsideBorder.paintBorder(c, g, px, py, pw, ph);
            Insets nextInsets = this.outsideBorder.getBorderInsets(c);
            px += nextInsets.left;
            py += nextInsets.top;
            pw = pw - nextInsets.right - nextInsets.left;
            ph = ph - nextInsets.bottom - nextInsets.top;
        }
    }

    public Insets getBorderInsets(UiComponent c, Insets insets) {
        Insets nextInsets;
        int top = 0;
        int left = 0;
        int right = 0;
        int bottom = 0;
        if (this.outsideBorder != null) {
            nextInsets = this.outsideBorder.getBorderInsets(c);
            top += nextInsets.top;
            left += nextInsets.left;
            right += nextInsets.right;
            bottom += nextInsets.bottom;
        }
        if (this.insideBorder != null) {
            nextInsets = this.insideBorder.getBorderInsets(c);
            top += nextInsets.top;
            left += nextInsets.left;
            right += nextInsets.right;
            bottom += nextInsets.bottom;
        }
        return new Insets(top, left, bottom, right);
    }

    @Override
    public Insets getBorderInsets(UiComponent c) {
        return this.getBorderInsets(c, Insets.EMPTY);
    }

    public Border getOutsideBorder() {
        return this.outsideBorder;
    }

    public Border getInsideBorder() {
        return this.insideBorder;
    }
}

