/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.border;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.peer.swing.AwtConverter;

public class BevelBorder
extends Border {
    protected int bevelType;
    protected Color highlightInner;
    protected Color highlightOuter;
    protected Color shadowInner;
    protected Color shadowOuter;
    public static final int RAISED = 0;
    public static final int LOWERED = 1;

    public BevelBorder(int bevelType) {
        this.bevelType = bevelType;
    }

    public BevelBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public BevelBorder(int bevelType, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        this(bevelType);
        this.highlightOuter = highlightOuterColor;
        this.highlightInner = highlightInnerColor;
        this.shadowOuter = shadowOuterColor;
        this.shadowInner = shadowInnerColor;
    }

    @Override
    public void paintBorder(UiComponent c, Graphics g, int x, int y, int width, int height) {
        if (this.bevelType == 0) {
            this.paintRaisedBevel(c, g, x, y, width, height);
        } else if (this.bevelType == 1) {
            this.paintLoweredBevel(c, g, x, y, width, height);
        }
    }

    @Override
    public Insets getBorderInsets(UiComponent component) {
        return new Insets(2, 2, 2, 2);
    }

    public Insets getBorderInsets(UiComponent component, Insets insets) {
        return this.getBorderInsets(component);
    }

    public Color getHighlightOuterColor(UiComponent c) {
        Color highlight = this.getHighlightOuterColor();
        Color result = highlight != null ? highlight : c.getBackground().brighter().brighter();
        return result;
    }

    public Color getHighlightInnerColor(UiComponent c) {
        Color highlight = this.getHighlightInnerColor();
        Color result = highlight != null ? highlight : c.getBackground().brighter();
        return result;
    }

    public Color getShadowInnerColor(UiComponent c) {
        Color shadow = this.getShadowInnerColor();
        Color result = shadow != null ? shadow : c.getBackground().darker();
        return result;
    }

    public Color getShadowOuterColor(UiComponent c) {
        Color shadow = this.getShadowOuterColor();
        Color result = shadow != null ? shadow : c.getBackground().darker().darker();
        return result;
    }

    public Color getHighlightOuterColor() {
        return this.highlightOuter;
    }

    public Color getHighlightInnerColor() {
        return this.highlightInner;
    }

    public Color getShadowInnerColor() {
        return this.shadowInner;
    }

    public Color getShadowOuterColor() {
        return this.shadowOuter;
    }

    public int getBevelType() {
        return this.bevelType;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public javax.swing.border.Border asSwing() {
        return new javax.swing.border.BevelBorder(this.bevelType, AwtConverter.toAwt(this.getHighlightOuterColor()), AwtConverter.toAwt(this.getHighlightOuterColor()), AwtConverter.toAwt(this.getShadowOuterColor()), AwtConverter.toAwt(this.getShadowInnerColor()));
    }

    protected void paintRaisedBevel(UiComponent c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getForeground();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setForeground(this.getHighlightOuterColor(c));
        g.drawLine(0, 0, 0, h - 2);
        g.drawLine(1, 0, w - 2, 0);
        g.setForeground(this.getHighlightInnerColor(c));
        g.drawLine(1, 1, 1, h - 3);
        g.drawLine(2, 1, w - 3, 1);
        g.setForeground(this.getShadowOuterColor(c));
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 0, w - 1, h - 2);
        g.setForeground(this.getShadowInnerColor(c));
        g.drawLine(1, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, 1, w - 2, h - 3);
        g.translate(-x, -y);
        g.setForeground(oldColor);
    }

    protected void paintLoweredBevel(UiComponent component, Graphics graphics, int x, int y, int width, int height) {
        Color prevColor = graphics.getForeground();
        int h = height;
        int w = width;
        graphics.translate(x, y);
        graphics.setForeground(this.getShadowInnerColor(component));
        graphics.drawLine(0, 0, 0, h - 1);
        graphics.drawLine(1, 0, w - 1, 0);
        graphics.setForeground(this.getShadowOuterColor(component));
        graphics.drawLine(1, 1, 1, h - 2);
        graphics.drawLine(2, 1, w - 2, 1);
        graphics.setForeground(this.getHighlightOuterColor(component));
        graphics.drawLine(1, h - 1, w - 1, h - 1);
        graphics.drawLine(w - 1, 1, w - 1, h - 2);
        graphics.setForeground(this.getHighlightInnerColor(component));
        graphics.drawLine(2, h - 2, w - 2, h - 2);
        graphics.drawLine(w - 2, 2, w - 2, h - 3);
        graphics.translate(-x, -y);
        graphics.setForeground(prevColor);
    }
}

