/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;

public class WaitWindow
extends Dialog {
    private Label messageLabel;

    public WaitWindow(UiWindow parent, Msg title, Msg message) {
        super(parent, title, true);
        this.init(message);
    }

    public WaitWindow(Frame parent, Msg title, Msg message) {
        this((UiWindow)parent, title, message);
    }

    public WaitWindow(Dialog parent, Msg title, Msg message) {
        this((UiWindow)parent, title, message);
    }

    public void setMessage(final Msg message) {
        if (!UiUtilities.isEventDispatchThread()) {
            UiUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitWindow.this.setMessage(message);
                }
            });
            return;
        }
        this.messageLabel.setMsg(message);
    }

    @Override
    public void setVisible(final boolean visible) {
        if (!UiUtilities.isEventDispatchThread()) {
            UiUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitWindow.this.setVisible(visible);
                }
            });
            return;
        }
        super.setVisible(visible);
    }

    @Override
    public void accept() {
    }

    private void init(Msg msg) {
        Panel container = new Panel(this.getContentPane());
        String colSpecs = "5dlu, left:200px:grow, 5dlu,";
        String rowSpecs = "5dlu, center:32px, 5dlu";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder(container);
        this.messageLabel = Label.create((UiContainer)container, msg);
        this.messageLabel.setIcon(UIMsg.PROCESSING_START);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.messageLabel, cc.xy(2, 2));
        this.getContentPane().add(container, "Center");
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }
}

