/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.PreferenceNode;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.DisposePolicy;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiPeer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.event.CustomEvent;
import oracle.bpm.ui.event.CustomEventListener;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.event.MouseMotionListener;
import oracle.bpm.ui.event.SizeListener;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.peer.ComponentPeer;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.PeerFactory;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.util.ObjectCreationTrace;
import org.jetbrains.annotations.NonNls;

public abstract class UiComponent
extends UiPeer {
    public Throwable stackTrace = new ObjectCreationTrace();
    private Cursor cursor;
    private String key;
    private Object layoutData;
    private List<CustomEventListener> listeners;
    private List<MouseListener> mouseListeners;
    private UiContainer parent;
    private boolean recyclable;
    public static final String INHERIT_BACKGROUNG_COLOR = "inherit.background.color";
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    public static final int WHEN_FOCUSED = 0;

    protected UiComponent(UiContainer parent) {
        this.setParent(parent);
    }

    protected UiComponent(Peer peer) {
        this.setPeer(peer);
    }

    public static UiComponent get(Object object) {
        UiComponent result = null;
        if (object != null) {
            if (object instanceof UiComponent) {
                result = (UiComponent)object;
            } else if (object instanceof JComponent) {
                JComponent component = (JComponent)object;
                result = (UiComponent)component.getClientProperty("oracle.bpm.ui.key");
            }
            if (result == null && (result = Ui.getUiFactory().createFrom(object)) == null) {
                throw new IllegalArgumentException("Unknown object: " + object.getClass());
            }
        }
        return result;
    }

    public void addVisibilityListener(VisibilityListener listener) {
        this.getComponentPeer().addVisibilityListener(listener);
    }

    public void removeVisibilityListener(VisibilityListener listener) {
        this.getComponentPeer().removeVisibilityListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getComponentPeer().addFocusListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.getComponentPeer().addKeyListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new ArrayList<MouseListener>();
        }
        this.mouseListeners.add(listener);
        this.getComponentPeer().addMouseListener(listener);
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.getComponentPeer().addMouseMotionListener(listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        if (this.isSwing()) {
            this.asSwing().addMouseWheelListener(listener);
        }
    }

    public void addSizeListener(SizeListener listener) {
        this.getComponentPeer().addSizeListener(listener);
    }

    public void removeSizeListener(SizeListener listener) {
        this.getComponentPeer().removeSizeListener(listener);
    }

    public JComponent asSwing() {
        Object nativeComponent = this.getComponentPeer().getNative();
        if (!(nativeComponent instanceof JComponent)) {
            throw new UnsupportedOperationException("Cannot return as Swing component. It's a " + nativeComponent.getClass().getName());
        }
        JComponent component = (JComponent)nativeComponent;
        return component;
    }

    public KeyStroke.Set getFocusTraversalKeys(int id) {
        KeyStroke.Set result = KeyStroke.Set.create();
        if (this.isSwing()) {
            for (AWTKeyStroke keyStroke : this.asSwing().getFocusTraversalKeys(id)) {
                result.add(keyStroke.getKeyCode(), keyStroke.getModifiers());
            }
        }
        return result;
    }

    public boolean isWrapper() {
        return Boolean.TRUE.equals(this.getClientProperty("oracle.bpm.ui.wrapper.key"));
    }

    public void dump() {
        UiComponent.dumpHierarchy(this, 0);
    }

    public void enableInputMethods(boolean b) {
        if (this.isSwing()) {
            this.asSwing().enableInputMethods(b);
        }
    }

    public final ActionMap getActionMap() {
        return this.asSwing().getActionMap();
    }

    public final Color getBackground() {
        return this.getComponentPeer().getBackground();
    }

    public final Border getBorder() {
        return this.getComponentPeer().getBorder();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getSize());
    }

    public final Object getClientProperty(@NonNls String propertyKey) {
        return this.getComponentPeer().getClientProperty(propertyKey);
    }

    public UiComponent getComponent(int i) {
        return this.getComponentPeer().getComponent(i);
    }

    public int getComponentCount() {
        return this.getComponentPeer().getComponentCount();
    }

    public final ComponentOrientation getComponentOrientation() {
        return this.getComponentPeer().getComponentOrientation();
    }

    public ComponentPeer getComponentPeer() {
        return (ComponentPeer)this.getPeer();
    }

    public final Cursor getCursor() {
        if (this.cursor == null) {
            this.cursor = Cursor.get(Cursor.CursorType.DEFAULT_CURSOR);
        }
        return this.cursor;
    }

    public final Font getFont() {
        return this.getComponentPeer().getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.getComponentPeer().getFontMetrics(font);
    }

    public final Color getForeground() {
        return this.getComponentPeer().getForeground();
    }

    public Graphics getGraphics() {
        return this.getComponentPeer().getGraphics();
    }

    public int getHeight() {
        return this.getComponentPeer().getHeight();
    }

    public final InputMap getInputMap(int condition) {
        return this.asSwing().getInputMap(condition);
    }

    public final Margin getInsets() {
        return this.getComponentPeer().getInsets();
    }

    public String getKey() {
        if (this.key == null) {
            String name = this.getName();
            if (name == null) {
                name = this.getClass().getName();
            }
            this.key = name;
        }
        return this.key;
    }

    public Object getLayoutData() {
        return this.layoutData;
    }

    public Point getLocation() {
        return this.getComponentPeer().getLocation();
    }

    public Point getLocationOnScreen() {
        return this.getComponentPeer().getLocationOnScreen();
    }

    public Dimension getMaximumSize() {
        return this.getComponentPeer().getMaximumSize();
    }

    public Dimension getMinimumSize() {
        return this.getComponentPeer().getMinimumSize();
    }

    public MouseListener[] getMouseListeners() {
        return this.mouseListeners != null ? this.mouseListeners.toArray(new MouseListener[this.mouseListeners.size()]) : new MouseListener[]{};
    }

    public MouseMotionListener[] getMouseMotionListeners() {
        return this.getComponentPeer().getMouseMotionListeners();
    }

    public String getName() {
        return this.getComponentPeer().getName();
    }

    public final Object getNative() {
        Object nativeComponent = this.getComponentPeer().getNative();
        assert (nativeComponent != null);
        return nativeComponent;
    }

    public UiWindow getOwnerWindow() {
        UiWindow window = null;
        for (UiContainer p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof UiWindow)) continue;
            window = (UiWindow)p;
            break;
        }
        return window;
    }

    public UiContainer getParent() {
        if (this.parent == null && this.isPeerCreated()) {
            if (Ui.isSwing()) {
                Component component;
                UiComponent uiParent;
                if (this.getNative() instanceof Component && (uiParent = UiComponent.get((component = (Component)this.getNative()).getParent())) instanceof UiContainer) {
                    this.parent = (UiContainer)uiParent;
                }
            } else {
                Object component = this.getNative();
                Class<?> c = component.getClass();
                if ("org.eclipse.swt.widgets.Control".equals(c.getName())) {
                    try {
                        UiComponent uiParent = UiComponent.get(c.getMethod("getParent", new Class[0]).invoke(component, new Object[0]));
                        if (uiParent instanceof UiContainer) {
                            this.parent = (UiContainer)uiParent;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.parent;
    }

    public Dimension getPreferredSize() {
        return this.getComponentPeer().getPreferredSize();
    }

    public Dimension getSize() {
        return this.getComponentPeer().getSize();
    }

    public String getStringProperty(String name) {
        String property = this.getProperty(name);
        return property != null ? String.valueOf(property) : null;
    }

    public Point getToolTipLocation(MouseEvent event) {
        return AwtConverter.fromAwt(this.asSwing().getToolTipLocation(event.asSwing()));
    }

    public String getToolTipText() {
        return this.getComponentPeer().getToolTipText();
    }

    public String getHelpId() {
        UiContainer parent = this.getParent();
        while (parent != null) {
            String helpId = parent.getHelpId();
            if (!this.isValidHelpId(helpId)) continue;
            return helpId;
        }
        return null;
    }

    public UiComponent getTopLevelAncestor() {
        if (this instanceof UiWindow) {
            return this;
        }
        UiComponent result = null;
        for (UiComponent p = this; p != null; p = p.getParent()) {
            result = p;
            if (p instanceof UiWindow) break;
        }
        return result;
    }

    public Rectangle getVisibleRect() {
        return new Rectangle(0, 0, this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return this.getComponentPeer().getWidth();
    }

    public final int getX() {
        return this.getComponentPeer().getX();
    }

    public final int getY() {
        return this.getComponentPeer().getY();
    }

    public void grabFocus() {
        this.requestFocus();
    }

    public boolean hasFocus() {
        return this.getComponentPeer().hasFocus();
    }

    public void invalidate() {
        this.getComponentPeer().invalidate();
    }

    public boolean isEnabled() {
        return this.getComponentPeer().isEnabled();
    }

    public final boolean isDisposed() {
        return this.getComponentPeer().isDisposed();
    }

    public boolean isFocusable() {
        return this.asSwing().isFocusable();
    }

    public final boolean isShowing() {
        return this.isVisible();
    }

    public boolean isSwing() {
        return this.getNative() instanceof Component;
    }

    public boolean isVisible() {
        return this.getComponentPeer().isVisible();
    }

    public void moveOnTop() {
        this.getComponentPeer().moveOnTop();
    }

    public void paint(Graphics g) {
        this.getComponentPeer().paint(g);
    }

    public void paintComponent(Graphics g) {
        this.getComponentPeer().paintComponent(g);
    }

    public final void paintComponents(Graphics g) {
        this.asSwing().paintComponents(AwtConverter.toAwt(g));
    }

    public final void printAll(Graphics g) {
        this.asSwing().printAll(AwtConverter.toAwt(g));
    }

    public void putClientProperty(@NonNls String propertyKey, Object value) {
        this.getComponentPeer().putClientProperty(propertyKey, value);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getComponentPeer().removeFocusListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        if (listener != null) {
            this.getComponentPeer().removeKeyListener(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        this.mouseListeners.remove(listener);
        this.getComponentPeer().removeMouseListener(listener);
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.getComponentPeer().removeMouseMotionListener(listener);
    }

    public void repaint() {
        this.getComponentPeer().repaint();
    }

    public void requestFocus() {
        this.getComponentPeer().requestFocus();
    }

    public boolean requestFocusInWindow() {
        this.requestFocus();
        return true;
    }

    public void revalidate() {
        this.getComponentPeer().revalidate();
    }

    public void setBackground(Color color) {
        this.getComponentPeer().setBackground(color);
    }

    public void setBorder(Border border) {
        this.getComponentPeer().setBorder(border);
    }

    public final void setBounds(Rectangle rec) {
        this.getComponentPeer().setBounds(rec.getX(), rec.getY(), rec.getWidth(), rec.getHeight());
    }

    public void setBounds(int x, int y, int width, int height) {
        this.getComponentPeer().setBounds(x, y, width, height);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        this.getComponentPeer().setCursor(cursor);
    }

    public void setEnabled(boolean enabled) {
        this.getComponentPeer().setEnabled(enabled);
    }

    public void setFocusable(boolean focusable) {
        this.getComponentPeer().setFocusable(focusable);
    }

    public void makeRecyclable() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Cannot make recyclable after dispose");
        }
        this.recyclable = true;
        this.getComponentPeer().makeRecyclable();
    }

    public boolean isRecyclable() {
        return this.recyclable;
    }

    public void dispose() {
        if (!this.isRecyclable()) {
            throw new IllegalStateException("Non recyclable items do not need to be disposed");
        }
        this.getComponentPeer().dispose();
    }

    public final void setFocusCycleRoot(boolean b) {
        this.getComponentPeer().setFocusCycleRoot(b);
    }

    public final void setFocusTraversalKeys(int id, Set<KeyStroke> keystrokes) {
        if (this.isSwing()) {
            HashSet<javax.swing.KeyStroke> keys = new HashSet<javax.swing.KeyStroke>();
            for (KeyStroke keyStroke : keystrokes) {
                keys.add(keyStroke.asSwing());
            }
            this.asSwing().setFocusTraversalKeys(id, keys);
        }
    }

    public final void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
        if (this.isSwing()) {
            this.asSwing().setFocusTraversalPolicy(policy);
        }
    }

    public void setFont(Font font) {
        this.getComponentPeer().setFont(font);
    }

    public void setForeground(Color color) {
        this.getComponentPeer().setForeground(color);
    }

    public final void setInsets(Margin margin) {
        this.getComponentPeer().setInsets(margin);
    }

    public void setLayoutData(Object layoutData) {
        this.layoutData = layoutData;
    }

    public void setLocation(Point p) {
        this.setLocation(p.getX(), p.getY());
    }

    public void setLocation(int x, int y) {
        this.getComponentPeer().setLocation(x, y);
    }

    public void setMaximumSize(Dimension dimension) {
        this.getComponentPeer().setMaximumSize(dimension);
    }

    public void setMinimumSize(Dimension dimension) {
        this.getComponentPeer().setMinimumSize(dimension);
    }

    public void setExactSize(Dimension dimension) {
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public void setName(String name) {
        this.getComponentPeer().setName(name);
    }

    public void setOpaque(boolean opaque) {
        this.getComponentPeer().setOpaque(opaque);
    }

    public boolean isOpaque() {
        return this.getComponentPeer().isOpaque();
    }

    public void setParent(UiContainer parent) {
        this.parent = parent;
    }

    public void setPreferredSize(Dimension dimension) {
        this.getComponentPeer().setPreferredSize(dimension);
    }

    public void setProperty(String name, String value) {
        this.getPreferences().put(name, value);
    }

    public void setRequestFocusEnabled(boolean enabled) {
        if (this.isSwing()) {
            this.asSwing().setRequestFocusEnabled(enabled);
        }
    }

    public void setSize(Dimension size) {
        this.getComponentPeer().setSize(size);
    }

    public void setSize(int width, int height) {
        this.getComponentPeer().setSize(width, height);
    }

    public void setToolTipText(Msg text) {
        this.getComponentPeer().setToolTipText(text != null ? text.getString() : null);
    }

    public void setToolTipText(String text) {
        this.getComponentPeer().setToolTipText(text);
    }

    public void setVisible(boolean visible) {
        if (visible && this.isDisposed()) {
            IllegalStateException e = new IllegalStateException("Cannot make visible a disposed component");
            if (this.isSwing()) {
                e.printStackTrace();
            } else {
                throw e;
            }
        }
        this.getComponentPeer().setVisible(visible);
        if (!visible && !this.isRecyclable() && !this.isDisposed() && this.isDisposeOnHide()) {
            this.getComponentPeer().dispose();
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public void transferFocus() {
        this.getComponentPeer().transferFocus();
    }

    public void transferFocusBackward() {
        this.asSwing().transferFocusBackward();
    }

    public void transferFocusDownCycle() {
        this.asSwing().transferFocusDownCycle();
    }

    public void transferFocusUpCycle() {
        this.asSwing().transferFocusUpCycle();
    }

    public void translate() {
    }

    public void updateUI() {
        this.getComponentPeer().updateUI();
    }

    public void validate() {
        this.getComponentPeer().validate();
    }

    public void addCustomEventListener(CustomEventListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CustomEventListener>();
        }
        this.listeners.add(listener);
    }

    protected static String getHelpIdFromObjectClass(Object object) {
        String result = "";
        if (object != null) {
            result = UiComponent.getClass(object.getClass()).getSimpleName();
        }
        return result;
    }

    protected void setBackgroundByInheritance() {
        for (UiContainer parent = this.getParent(); parent != null; parent = parent.getParent()) {
            Object color = parent.getClientProperty(INHERIT_BACKGROUNG_COLOR);
            if (!(color instanceof Color)) continue;
            this.setBackground((Color)color);
            break;
        }
    }

    protected boolean isValidHelpId(String id) {
        return !Str.isEmpty(id);
    }

    protected DisposePolicy getDisposePolicy() {
        return DisposePolicy.ON_PARENT_DISPOSE;
    }

    protected final boolean isDisposeOnHide() {
        return this.getDisposePolicy() == DisposePolicy.ON_HIDE;
    }

    protected final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.asSwing().firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.isSwing()) {
            try {
                Method method;
                JComponent component = this.asSwing();
                Class[] argClasses = new Class[]{String.class, Object.class, Object.class};
                try {
                    method = JComponent.class.getDeclaredMethod("firePropertyChange", argClasses);
                }
                catch (NoSuchMethodException e) {
                    method = JComponent.class.getDeclaredMethod("fireVetoableChange", argClasses);
                }
                method.setAccessible(true);
                Object[] args = new Object[]{propertyName, oldValue, newValue};
                method.invoke((Object)component, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ComponentPeer getParentPeer() {
        UiContainer p = this.getParent();
        return p != null ? (ComponentPeer)p.getPeer() : null;
    }

    protected String getProperty(String name) {
        return this.getPreferences().get(name);
    }

    protected PeerFactory getUiFactory() {
        return Ui.getUiFactory();
    }

    protected final void paintBorder(Graphics g) {
    }

    protected final void printComponent(Graphics g) {
    }

    protected final void fireCustomEventChanged(CustomEvent customEvent) {
        for (CustomEventListener customEventListener : this.listeners) {
            customEventListener.eventChanged(customEvent);
        }
    }

    private static Class<?> getClass(Class<?> aClass) {
        if (!Str.isEmpty(aClass.getSimpleName())) {
            return aClass;
        }
        return UiComponent.getClass(aClass.getEnclosingClass());
    }

    private static void dumpHierarchy(UiComponent c, int indent) {
        UiComponent.printComponent(c, indent);
        List<UiComponent> children = Utilities.getChildrenComponents(c);
        if (children != null) {
            for (UiComponent component : children) {
                UiComponent.dumpHierarchy(component, indent + 1);
            }
        }
    }

    private static String getIndent(int indent) {
        String s = "";
        for (int i = 0; i < indent; ++i) {
            s = s + "     ";
        }
        return s;
    }

    private static void printComponent(UiComponent c, int indent) {
        String text;
        String s = UiComponent.getIndent(indent) + c.getClass().getName();
        if (c instanceof UiContainer) {
            UiContainer container = (UiContainer)c;
            Layout layout = container.getLayout();
            s = s + " [layout: " + (layout != null ? layout.getClass().getName() : "none") + "]";
        }
        s = s + " -> " + c.getNative();
        s = s + "[bounds: " + c.getBounds() + "]";
        if (c instanceof AbstractButton && (text = ((AbstractButton)c).getText()) != null) {
            s = s + " Text=[" + ((AbstractButton)c).getText() + "]";
        }
        System.out.println(s);
    }

    private PreferenceNode getParentPreferences() {
        PreferenceNode result;
        UiContainer p = this.getParent();
        if (p != null) {
            result = super.getPreferences();
        } else {
            PreferenceNode root = Platform.getPreferencesService().getRootNode();
            result = root.child("ui-preferences");
        }
        return result;
    }

    private PreferenceNode getPreferences() {
        PreferenceNode parentPrefs = this.getParentPreferences();
        return parentPrefs.child(this.getKey());
    }
}

