/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MediaTracker;
import java.awt.Window;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.peer.swing.event.SwingMouseListener;

public class SplashWindow
extends Window {
    private boolean paintCalled = false;
    private Image splashImage;
    static final long serialVersionUID = 4818204414989823333L;
    static final long serialCheck = -2363821155973853910L;

    public SplashWindow(Frame owner, Image splashImage) {
        super(owner);
        this.splashImage = splashImage;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(splashImage.asAwtImage(), 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int imgWidth = splashImage.asAwtImage().getWidth(this);
        int imgHeight = splashImage.asAwtImage().getHeight(this);
        this.setSize(imgWidth, imgHeight);
        Dimension screenDim = Ui.getToolkit().getScreenSize();
        this.setLocation((screenDim.getWidth() - imgWidth) / 2, (screenDim.getHeight() - imgHeight) / 2);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(SwingMouseListener.get(disposeOnClick));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splash(Image splashImage) {
        Frame f = new Frame();
        SplashWindow w = new SplashWindow(f, splashImage);
        w.toFront();
        w.setVisible(true);
        if (!EventQueue.isDispatchThread()) {
            SplashWindow splashWindow = w;
            synchronized (splashWindow) {
                while (!w.paintCalled) {
                    try {
                        w.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.splashImage.asAwtImage(), 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    @Override
    public void update(Graphics g) {
        g.setColor(this.getForeground());
        this.paint(g);
    }
}

