/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Int;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.Editable;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.SliderPeer;

public class Slider
extends UiContainer
implements Editable {
    protected int oldValue;
    private List<ModificationListener> modificationListeners = new ArrayList<ModificationListener>();
    private MouseListener mouseListener;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public Slider(UiContainer parent, int min, int max, int value) {
        super(parent);
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValue(value);
        UiUtilities.addToEditableContainer(this, this.getParent());
    }

    public Slider(UiContainer parent, int orientation, int min, int max, int value) {
        super(parent);
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValue(value);
        this.setOrientation(orientation);
        UiUtilities.addToEditableContainer(this, this.getParent());
    }

    public void setLabelTable(Dictionary labels) {
        this.getSliderPeer().setLabelTable(labels);
    }

    public void setIconUI() {
        this.getSliderPeer().setIconUI();
    }

    public void setMajorTickSpacing(int spacing) {
        this.getSliderPeer().setMajorTickSpacing(spacing);
    }

    public void setMinorTickSpacing(int spacing) {
        this.getSliderPeer().setMinorTickSpacing(spacing);
    }

    public void setPaintLabels(boolean paintLabels) {
        this.getSliderPeer().setPaintLabels(paintLabels);
    }

    public void setPaintTicks(boolean paintTicks) {
        this.getSliderPeer().setPaintTicks(paintTicks);
    }

    public void setPaintTrack(boolean paintTrack) {
        this.getSliderPeer().setPaintTrack(paintTrack);
    }

    public void setSnapToTicks(boolean snapToTicks) {
        this.getSliderPeer().setSnapToTicks(snapToTicks);
    }

    public int getValue() {
        return this.getSliderPeer().getValue();
    }

    public void addChangeListener(ChangeListener listener) {
        this.getSliderPeer().addChangeListener(listener);
    }

    public Dictionary<Int, Msg> createStandardLabels(int i) {
        return this.getSliderPeer().createStandardLabels(i);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getSliderPeer().removeChangeListener(listener);
    }

    public void setMaximum(int max) {
        this.getSliderPeer().setMaximum(max);
    }

    @Override
    public boolean isModified() {
        int currentValue = this.getValue();
        return this.oldValue == currentValue;
    }

    @Override
    public void resetModified() {
        this.oldValue = this.getValue();
    }

    @Override
    public void addModificationListener(ModificationListener listener) {
        this.modificationListeners.add(listener);
        if (this.mouseListener == null) {
            this.mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseDoubleClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Slider.this.fireChanged();
                }
            };
            this.addMouseListener(this.mouseListener);
        }
    }

    @Override
    public void removeModificationListener(ModificationListener listener) {
        this.modificationListeners.remove(listener);
        if (this.modificationListeners.isEmpty()) {
            this.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createSlider(this.getParentPeer());
    }

    protected void setValue(int value) {
        this.getSliderPeer().setValue(value);
    }

    private void setMinimum(int min) {
        this.getSliderPeer().setMinimum(min);
    }

    private void setOrientation(int orientation) {
        this.getSliderPeer().setOrientation(orientation);
    }

    private SliderPeer getSliderPeer() {
        return (SliderPeer)this.getPeer();
    }

    private void fireChanged() {
        for (ModificationListener modificationListener : this.modificationListeners) {
            modificationListener.objectModified(new ModificationEvent<Slider>(this, this.oldValue, this.getValue()));
        }
    }
}

