/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.Color;
import oracle.bpm.execution.Executable;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.GradientPanel;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.RibbonItem;
import oracle.bpm.ui.RibbonSection;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.EmptyBorder;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;

public abstract class RibbonSectionMultiple
extends RibbonSection {
    private boolean hasClick;
    private Panel mainComponent;
    private final int MAX_PER_ROW = 3;
    private final int popupWidth = 230;

    public RibbonSectionMultiple(UiContainer parent) {
        super(parent);
    }

    @Override
    public UiComponent createMainComponent() {
        Panel mainComponent = new Panel(this);
        mainComponent.setLayout(new MigLayout("insets 0 0 0 0, gapx 1, fill"));
        mainComponent.setOpaque(false);
        mainComponent.setBackground(Color.valueOf(161, 190, 208));
        this.mainComponent = mainComponent;
        return mainComponent;
    }

    public void loadSection() {
        Sequence<RibbonItem> ribbonItems = this.loadItems();
        RibbonItem itemDefault = this.getDefault();
        final GradientPanel imagePanel = new GradientPanel(this.mainComponent, Color.valueOf(196, 217, 246), Color.WHITE);
        imagePanel.setLayout(new MigLayout("fill, insets 3 3 3 3, gap 0"));
        final GradientPanel arrowPanel = new GradientPanel(this.mainComponent, Color.valueOf(196, 217, 246), Color.WHITE);
        arrowPanel.setLayout(new MigLayout("insets 0 0 0 0, gap 0, fill"));
        imagePanel.setOpaque(false);
        arrowPanel.setOpaque(false);
        final Label defaultImage = Label.create(imagePanel);
        Label arrowIcon = Label.create(arrowPanel);
        if (itemDefault.getIcon() != null) {
            defaultImage.setIcon(itemDefault.getIcon());
        }
        arrowIcon.setIcon(UIMsg.HIDE_PROGRESS_DETAILS);
        arrowIcon.setIcon(arrowIcon.getIcon().getScaledInstance(8, 8, 0));
        defaultImage.setToolTipText(itemDefault.getTitle());
        arrowIcon.setToolTipText(UIMsg.SHOW_MORE);
        imagePanel.add(defaultImage, "growy, center");
        arrowPanel.add(arrowIcon, "growy, aligny center");
        this.mainComponent.add(imagePanel, "growy, growx, center");
        this.mainComponent.add(arrowPanel, "growy, aligny center");
        final PopupMenu window = new PopupMenu();
        ScrollPane scrollPane = new ScrollPane(this);
        Panel content = new Panel(scrollPane);
        int i = 1;
        content.setLayout(new MigLayout("gap 2, ins 2"));
        final Executable finishExecution = new Executable(){

            @Override
            public Object execute() throws ExecutionException {
                RibbonSectionMultiple.this.onMouseExit(imagePanel);
                RibbonSectionMultiple.this.onMouseExit(arrowPanel);
                RibbonSectionMultiple.this.mainComponent.setOpaque(false);
                RibbonSectionMultiple.this.mainComponent.repaint();
                RibbonSectionMultiple.this.hasClick = false;
                return null;
            }
        };
        for (final RibbonItem item : ribbonItems) {
            Panel internPanel = new Panel(content);
            internPanel.setLayout(new MigLayout("ins 0, gap 0"));
            Label labelItem = Label.createWithNoColon((UiContainer)internPanel, item.getTitle());
            labelItem.setToolTipText(item.getTitle());
            labelItem.asSwing().setAlignmentX(0.0f);
            final Button buttonItem = new Button((UiContainer)internPanel, item.getTitle().getString());
            Image icon = item.getIcon();
            if (icon != null) {
                buttonItem.setIcon(icon);
            }
            Button.setIconic(buttonItem);
            buttonItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Image iconClick = item.getIcon();
                    if (iconClick != null) {
                        defaultImage.setIcon(iconClick);
                    }
                    defaultImage.setToolTipText(item.getTitle());
                    RibbonSectionMultiple.this.setDefault(item);
                    window.getParent().requestFocus();
                    buttonItem.setOpaque(false);
                    buttonItem.setBorder(new EmptyBorder(0, 0, 0, 0));
                    window.setVisible(false);
                    RibbonSectionMultiple.this.hasClick = true;
                    item.execute(finishExecution);
                    RibbonSectionMultiple.this.onMouseClick(imagePanel);
                }
            });
            internPanel.add(buttonItem, "alignx center, wrap");
            labelItem.setHorizontalAlignment(0);
            internPanel.add(labelItem, "width 70px!, alignx center");
            if (i % 3 == 0) {
                content.add(internPanel, "aligny top, wrap");
            } else {
                content.add(internPanel, "aligny top");
            }
            ++i;
        }
        window.setPopupSize(230, i / 3 * 50);
        scrollPane.add(content);
        scrollPane.setView(content);
        window.add(scrollPane);
        this.mainComponent.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RibbonSectionMultiple.this.onMouseOver(arrowPanel, Color.WHITE);
                RibbonSectionMultiple.this.mainComponent.setOpaque(true);
                RibbonSectionMultiple.this.mainComponent.repaint();
                if (!RibbonSectionMultiple.this.hasClick) {
                    RibbonSectionMultiple.this.onMouseOver(imagePanel, Color.WHITE);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RibbonSectionMultiple.this.onMouseExit(arrowPanel);
                RibbonSectionMultiple.this.mainComponent.setOpaque(false);
                RibbonSectionMultiple.this.mainComponent.repaint();
                if (!RibbonSectionMultiple.this.hasClick) {
                    RibbonSectionMultiple.this.onMouseExit(imagePanel);
                }
            }
        });
        imagePanel.addMouseListener(new MouseListenerImage(window, scrollPane, arrowPanel, imagePanel, finishExecution));
        defaultImage.addMouseListener(new MouseListenerImage(window, scrollPane, arrowPanel, imagePanel, finishExecution));
        arrowPanel.addMouseListener(new MouseListenerArrow(window, scrollPane, arrowPanel, imagePanel));
        arrowIcon.addMouseListener(new MouseListenerArrow(window, scrollPane, arrowPanel, imagePanel));
    }

    private void onMouseOver(GradientPanel panel, Color color2) {
        panel.setGradient(Color.valueOf(196, 217, 246), color2, true);
    }

    private void onMouseClick(GradientPanel panel) {
        panel.setGradient(Color.WHITE, Color.valueOf(196, 217, 246), true);
    }

    private void onMouseExit(GradientPanel panel) {
        panel.setGradient(Color.valueOf(196, 217, 246), Color.WHITE, false);
    }

    private class MouseListenerImage
    extends MouseListenerRibbon {
        private Executable executable;

        public MouseListenerImage(PopupMenu window, ScrollPane scrollPane, GradientPanel arrowPanel, GradientPanel imagePanel, Executable executable) {
            super(window, scrollPane, arrowPanel, imagePanel);
            this.executable = executable;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RibbonSectionMultiple.this.onMouseOver(((MouseListenerRibbon)this).arrowPanel, Color.WHITE);
            RibbonSectionMultiple.this.mainComponent.setOpaque(true);
            RibbonSectionMultiple.this.mainComponent.repaint();
            if (!RibbonSectionMultiple.this.hasClick) {
                RibbonSectionMultiple.this.onMouseOver(((MouseListenerRibbon)this).imagePanel, Color.WHITE);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RibbonSectionMultiple.this.onMouseExit(((MouseListenerRibbon)this).arrowPanel);
            RibbonSectionMultiple.this.mainComponent.setOpaque(false);
            RibbonSectionMultiple.this.mainComponent.repaint();
            if (!RibbonSectionMultiple.this.hasClick) {
                RibbonSectionMultiple.this.onMouseExit(((MouseListenerRibbon)this).imagePanel);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDoubleClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!RibbonSectionMultiple.this.hasClick) {
                RibbonSectionMultiple.this.hasClick = true;
                RibbonSectionMultiple.this.onMouseClick(((MouseListenerRibbon)this).imagePanel);
                RibbonSectionMultiple.this.getDefault().execute(this.executable);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class MouseListenerArrow
    extends MouseListenerRibbon {
        public MouseListenerArrow(PopupMenu window, ScrollPane scrollPane, GradientPanel arrowPanel, GradientPanel imagePanel) {
            super(window, scrollPane, arrowPanel, imagePanel);
        }

        @Override
        public void mouseDoubleClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (RibbonSectionMultiple.this.mainComponent.getWidth() == 0) {
                ((MouseListenerRibbon)this).scrollPane.repaint();
                ((MouseListenerRibbon)this).scrollPane.goToTopLeft();
                ((MouseListenerRibbon)this).window.show(Ui.getRoot(), 5000, 5000);
            }
            ((MouseListenerRibbon)this).scrollPane.repaint();
            ((MouseListenerRibbon)this).scrollPane.goToTopLeft();
            ((MouseListenerRibbon)this).window.show(e.getComponent(), -e.getComponent().getParent().getX(), RibbonSectionMultiple.this.mainComponent.getParent().getHeight());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!RibbonSectionMultiple.this.hasClick) {
                RibbonSectionMultiple.this.onMouseOver(((MouseListenerRibbon)this).imagePanel, Color.WHITE);
            }
            RibbonSectionMultiple.this.onMouseOver(((MouseListenerRibbon)this).arrowPanel, Color.valueOf(230, 239, 250));
            RibbonSectionMultiple.this.mainComponent.setOpaque(true);
            RibbonSectionMultiple.this.mainComponent.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!RibbonSectionMultiple.this.hasClick) {
                RibbonSectionMultiple.this.onMouseExit(((MouseListenerRibbon)this).imagePanel);
            }
            RibbonSectionMultiple.this.onMouseExit(((MouseListenerRibbon)this).arrowPanel);
            RibbonSectionMultiple.this.mainComponent.setOpaque(false);
            RibbonSectionMultiple.this.mainComponent.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            RibbonSectionMultiple.this.onMouseClick(((MouseListenerRibbon)this).arrowPanel);
        }
    }

    private abstract class MouseListenerRibbon
    implements MouseListener {
        private GradientPanel arrowPanel;
        private GradientPanel imagePanel;
        private ScrollPane scrollPane;
        private PopupMenu window;

        public MouseListenerRibbon(PopupMenu window, ScrollPane scrollPane, GradientPanel arrowPanel, GradientPanel imagePanel) {
            this.window = window;
            this.scrollPane = scrollPane;
            this.arrowPanel = arrowPanel;
            this.imagePanel = imagePanel;
        }
    }
}

