/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioButtonsPanel<T>
extends Panel {
    private Map<T, RadioButton> radioButtons = new HashMap<T, RadioButton>();
    private List<Msg> toolTips;

    public RadioButtonsPanel(@NotNull UiContainer container, @NotNull List<T> values) {
        this(container, values, true);
    }

    public RadioButtonsPanel(@NotNull UiContainer container, @NotNull List<T> values, boolean horizontalAlignment) {
        super(container);
        this.init(values, horizontalAlignment);
    }

    public RadioButtonsPanel(@NotNull UiContainer container, @NotNull List<T> values, boolean horizontalAlignment, Msg title, List<Msg> toolTips) {
        super(container, title);
        this.toolTips = toolTips;
        this.init(values, horizontalAlignment);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (RadioButton radioButton : this.radioButtons.values()) {
            radioButton.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void addItemListener(@NotNull ItemListener itemListener) {
        for (RadioButton radioButton : this.radioButtons.values()) {
            radioButton.addItemListener(itemListener);
        }
    }

    public void removeItemListener(@NotNull ItemListener itemListener) {
        for (RadioButton radioButton : this.radioButtons.values()) {
            radioButton.removeItemListener(itemListener);
        }
    }

    @Nullable
    public T getSelectedValue() {
        T result = null;
        for (Map.Entry<T, RadioButton> entry : this.radioButtons.entrySet()) {
            RadioButton radioButton = entry.getValue();
            if (!radioButton.isSelected()) continue;
            result = entry.getKey();
            break;
        }
        return result;
    }

    public void setSelectedValue(@Nullable T value) {
        block2: {
            block1: {
                if (value == null) break block1;
                RadioButton radioButton = this.radioButtons.get(value);
                if (radioButton == null) break block2;
                radioButton.setSelected(true);
                break block2;
            }
            for (Map.Entry<T, RadioButton> entry : this.radioButtons.entrySet()) {
                RadioButton radioButton = entry.getValue();
                if (!radioButton.isSelected()) continue;
                radioButton.setSelected(false);
                break;
            }
        }
    }

    private void init(@NotNull List<T> values, boolean horizontalAlignment) {
        this.setLayout(new MigLayout("ins 0, gap 5"));
        ButtonGroup group = new ButtonGroup();
        int pos = 0;
        for (T value : values) {
            String s = value instanceof I18nProvider ? ((I18nProvider)value).getString() : value.toString();
            RadioButton radioButton = new RadioButton((UiContainer)this, s);
            this.radioButtons.put(value, radioButton);
            group.add(radioButton);
            if (this.toolTips != null && pos < this.toolTips.size()) {
                radioButton.setToolTipText(this.toolTips.get(pos++));
            }
            this.add(radioButton, !horizontalAlignment ? "wrap" : "");
        }
    }
}

