/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.DisposePolicy;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.TitledBorder;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.ComponentPeer;
import oracle.bpm.ui.peer.ContainerPeer;
import oracle.bpm.ui.peer.Peer;

public class Panel
extends UiContainer {
    private DisposeListenerImpl disposeListener;
    private DisposePolicy disposePolicy = DisposePolicy.ON_HIDE;
    private Msg title;

    public Panel(UiContainer parent) {
        this(parent, null);
    }

    public Panel(UiContainer parent, Msg title) {
        super(parent);
        this.title = title;
        this.setLayout(new FlowLayout());
        this.addDisposeListener();
        this.setBackgroundByInheritance();
    }

    protected Panel(Peer peer) {
        super(peer);
        this.addDisposeListener();
    }

    public static final Panel createPanelWithBorder(UiContainer parent) {
        return new Panel(parent, UIMsg.TO_MSG(""));
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    @Override
    public void makeRecyclable() {
        super.makeRecyclable();
        this.disposePolicy = DisposePolicy.ON_PARENT_DISPOSE;
    }

    @Override
    public void setParent(UiContainer parent) {
        if (parent == null && Ui.isSwt()) {
            throw new IllegalArgumentException("Null parent");
        }
        super.setParent(parent);
    }

    public Msg getTitleMsg() {
        Border border = this.getBorder();
        if (border != null && border instanceof TitledBorder) {
            return ((TitledBorder)border).getMsg();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " [" + this.hashCode() + "] " + this.getName();
    }

    @Override
    protected DisposePolicy getDisposePolicy() {
        return this.disposePolicy;
    }

    @Override
    protected Peer createPeer() {
        ComponentPeer parent = this.getParentPeer();
        if (Ui.isSwt()) assert (parent != null) : "Invalid parent for panel";
        ContainerPeer result = this.title != null ? Ui.getUiFactory().createPanel(parent, this.title.getString()) : Ui.getUiFactory().createPanel(parent);
        return result;
    }

    protected void onDispose() {
    }

    private void addDisposeListener() {
        this.disposeListener = new DisposeListenerImpl(this);
        this.addVisibilityListener(this.disposeListener);
    }

    private void doOnDispose() {
        this.onDispose();
        this.removeVisibilityListener(this.disposeListener);
    }

    private class DisposeListenerImpl
    implements VisibilityListener {
        private final Panel panel;

        public DisposeListenerImpl(Panel panel2) {
            this.panel = panel2;
        }

        @Override
        public void onDispose() {
            this.panel.doOnDispose();
        }
    }
}

