/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bpm.ui.MnemonicSupport;
import org.jetbrains.annotations.NonNls;

public class MnemonicRegistry {
    private boolean enabled;
    private ManagedComponentListener managedComponentListener;
    private Map<Registration, JComponent> registrations = new TreeMap<Registration, JComponent>();
    private Map<Mnemonic, Registration> reservations = new HashMap<Mnemonic, Registration>();
    private Map<Registration, Mnemonic> reservationsByRegistration = new HashMap<Registration, Mnemonic>();
    private UnmanagedComponentListener unmanagedComponentListener;
    private static final String REGISTRATION = "MnemonicRegistry.REGISTRATION";
    public static final int TYPE_UNMANAGED = 0;
    public static final int TYPE_MANAGED = 1;

    public MnemonicRegistry() {
        this.reset();
        this.setEnabled(true);
    }

    public static int getComponentMnemonic(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("jComponent");
        }
        int mnemonic = 0;
        if (jComponent instanceof JLabel) {
            mnemonic = ((JLabel)jComponent).getDisplayedMnemonic();
        } else if (jComponent instanceof AbstractButton) {
            mnemonic = ((AbstractButton)jComponent).getMnemonic();
        } else {
            MnemonicRegistry.log("invoked with: " + jComponent.getClass().getName() + " expected Label or AbstractButton");
        }
        return mnemonic;
    }

    public static String getText(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("jComponent");
        }
        if (jComponent instanceof JLabel) {
            return ((JLabel)jComponent).getText();
        }
        if (jComponent instanceof AbstractButton) {
            return ((AbstractButton)jComponent).getText();
        }
        throw new IllegalArgumentException("invoked with: " + jComponent.getClass().getName() + " expected Label or AbstractButton");
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }

    public synchronized void register(JComponent jComponent, int type) {
        Registration registration;
        if (MnemonicSupport.disabled) {
            MnemonicRegistry.log("mnemonic support is disabled");
            return;
        }
        if (!(jComponent instanceof AbstractButton) && !(jComponent instanceof JLabel)) {
            MnemonicRegistry.log("invoked with: " + (jComponent == null ? "null" : jComponent.getClass().getName()) + " expected Label or AbstractButton");
            return;
        }
        String name = jComponent instanceof AbstractButton ? ((AbstractButton)jComponent).getText() : ((JLabel)jComponent).getText();
        if (name == null) {
            name = jComponent.toString();
        }
        if ((registration = MnemonicRegistry.getRegistration(jComponent)) == null) {
            registration = new Registration(type, name);
            jComponent.putClientProperty(REGISTRATION, registration);
            this.registrations.put(registration, jComponent);
            MnemonicRegistry.log("registered: " + registration);
            this.reserve(registration, jComponent);
            this.registerListeners(jComponent, type);
        }
    }

    public synchronized void reset() {
        this.registrations.clear();
        this.reservations.clear();
        this.reservationsByRegistration.clear();
        this.managedComponentListener = new ManagedComponentListener();
        this.unmanagedComponentListener = new UnmanagedComponentListener();
    }

    public synchronized void unregister(JComponent jComponent) {
        if (MnemonicSupport.disabled) {
            MnemonicRegistry.log("mnemonic support is disabled");
            return;
        }
        if (!(jComponent instanceof AbstractButton) && !(jComponent instanceof JLabel)) {
            MnemonicRegistry.log("invoked with: " + (jComponent == null ? "null" : jComponent.getClass().getName()) + " expected Label or AbstractButton");
            return;
        }
        Registration registration = (Registration)jComponent.getClientProperty(REGISTRATION);
        if (registration == null) {
            MnemonicRegistry.log("jComponent: " + jComponent + " is no registered.");
            return;
        }
        if (registration.getType() != 0) {
            this.releaseMnemonic(jComponent);
        }
        this.unregisterListeners(jComponent, registration.getType());
        jComponent.putClientProperty(REGISTRATION, null);
        this.registrations.remove(registration);
        MnemonicRegistry.log("unregistered: " + registration);
    }

    private static void setComponentMnemonic(JComponent jComponent, int mnemonic) {
        MnemonicRegistry.log("setComponentMnemonic " + MnemonicRegistry.getRegistration(jComponent) + " mnemonic: " + (char)mnemonic);
        if (jComponent == null) {
            throw new NullPointerException("jComponent");
        }
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setDisplayedMnemonic(mnemonic);
        } else if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setMnemonic(mnemonic);
        } else {
            throw new IllegalArgumentException("invoked with: " + jComponent.getClass().getName() + " expected Label or AbstractButton");
        }
    }

    private static Mnemonic createMnemonic(int menmonic) {
        return MnemonicRegistry.createMnemonic((char)menmonic);
    }

    private static Mnemonic createMnemonic(char menmonic) {
        if (menmonic != '\u0000') {
            return new Mnemonic(menmonic);
        }
        return null;
    }

    private static Registration getRegistration(JComponent jComponent) {
        return (Registration)jComponent.getClientProperty(REGISTRATION);
    }

    private static void log(@NonNls Object o) {
        if (MnemonicSupport.debug) {
            System.out.println(o);
        }
    }

    private static void resetComponentMnemonic(JComponent jComponent) {
        MnemonicRegistry.log("resetComponentMnemonic " + MnemonicRegistry.getRegistration(jComponent));
        MnemonicRegistry.setComponentMnemonic(jComponent, 0);
    }

    private Mnemonic getMnemonic(JComponent jComponent) {
        int componentMnemonic = MnemonicRegistry.getComponentMnemonic(jComponent);
        return MnemonicRegistry.createMnemonic(componentMnemonic);
    }

    private Mnemonic[] getMnemonicCandidates(String text) {
        ArrayList<Mnemonic> list = new ArrayList<Mnemonic>(text.length());
        char[] buffer = text.toCharArray();
        LinkedHashSet consonants = new LinkedHashSet();
        LinkedHashSet<Mnemonic> vowels = new LinkedHashSet<Mnemonic>();
        Mnemonic first = null;
        for (char aBuffer : buffer) {
            if (!Character.isLetterOrDigit(aBuffer)) continue;
            Mnemonic mnemonic = MnemonicRegistry.createMnemonic(aBuffer);
            if (first == null) {
                first = mnemonic;
                continue;
            }
            LinkedHashSet<Mnemonic> uniques = "aeiouAEIOU".indexOf(aBuffer) > -1 ? vowels : consonants;
            uniques.add(mnemonic);
        }
        list.add(first);
        list.addAll(consonants);
        list.addAll(vowels);
        Mnemonic[] candidates = null;
        if (!list.isEmpty()) {
            candidates = new Mnemonic[list.size()];
            list.toArray(candidates);
            MnemonicRegistry.log("candidates: " + list);
        }
        return candidates;
    }

    private boolean isReserved(Mnemonic mnemonic) {
        return this.reservations.containsKey(mnemonic);
    }

    private synchronized void allocateMnemonic(JComponent jComponent) {
        Mnemonic[] candidates;
        MnemonicRegistry.log("allocating mnemonic for : " + MnemonicRegistry.getRegistration(jComponent));
        String text = MnemonicRegistry.getText(jComponent);
        if (text != null && (candidates = this.getMnemonicCandidates(text)) != null) {
            boolean assigned = false;
            for (Mnemonic mnemonic : candidates) {
                if (this.isReserved(mnemonic)) continue;
                this.reserveMnemonic(jComponent, mnemonic);
                MnemonicRegistry.setComponentMnemonic(jComponent, mnemonic.charValue());
                assigned = true;
                break;
            }
            if (!assigned) {
                MnemonicRegistry.log("UNASSIGNED: " + MnemonicRegistry.getRegistration(jComponent) + " after trying candidates: " + Arrays.asList(candidates));
            }
        }
    }

    private void disable() {
        MnemonicRegistry.log("disable...");
        this.resetManaged();
        MnemonicRegistry.log("disabled.");
    }

    private void enable() {
        MnemonicRegistry.log("enable...");
        this.reloadRegistrations();
        MnemonicRegistry.log("enabled.");
    }

    private void registerListeners(JComponent jComponent, int type) {
        if (type == 1) {
            if (jComponent instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)jComponent;
                abstractButton.addPropertyChangeListener("text", this.managedComponentListener);
                new ResetManagedPropertyChangeListener("mnemonic", abstractButton);
            } else if (jComponent instanceof JLabel) {
                JLabel jLabel = (JLabel)jComponent;
                jLabel.addPropertyChangeListener("text", this.managedComponentListener);
                new ResetManagedPropertyChangeListener("displayedMnemonic", jLabel);
            }
            jComponent.addComponentListener(this.managedComponentListener);
        } else if (type == 0) {
            if (jComponent instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)jComponent;
                abstractButton.addPropertyChangeListener("mnemonic", this.unmanagedComponentListener);
            } else if (jComponent instanceof JLabel) {
                JLabel jLabel = (JLabel)jComponent;
                jLabel.addPropertyChangeListener("displayedMnemonic", this.unmanagedComponentListener);
            }
            jComponent.addComponentListener(this.unmanagedComponentListener);
        }
    }

    private synchronized JComponent releaseMnemonic(Mnemonic mnemonic) {
        Registration registration = this.reservations.remove(mnemonic);
        this.reservationsByRegistration.remove(registration);
        MnemonicRegistry.log("released mnemonic: " + mnemonic + " for registration: " + registration);
        if (registration != null) {
            return this.registrations.get(registration);
        }
        return null;
    }

    private void releaseMnemonic(JComponent jComponent) {
        this.releaseMnemonic(MnemonicRegistry.getRegistration(jComponent));
    }

    private void releaseMnemonic(Registration registration) {
        if (registration != null) {
            Mnemonic mnemonic = this.reservationsByRegistration.get(registration);
            this.reservations.remove(mnemonic);
            this.reservationsByRegistration.remove(registration);
            MnemonicRegistry.log("released mnemonic: " + mnemonic + " of registration: " + registration);
        }
    }

    private synchronized void reloadRegistrations() {
        Iterator<Map.Entry<Registration, JComponent>> i$ = this.registrations.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Registration, JComponent> o;
            Map.Entry<Registration, JComponent> entry = o = i$.next();
            Registration registration = entry.getKey();
            JComponent jComponent = entry.getValue();
            this.reserve(registration, jComponent);
        }
    }

    private void reserve(Registration registration, JComponent jComponent) {
        if (registration.getType() == 0) {
            Mnemonic mnemonic = this.getMnemonic(jComponent);
            JComponent owner = this.releaseMnemonic(mnemonic);
            this.reserveMnemonic(jComponent, mnemonic);
            if (owner != null) {
                Registration ownerRegistration = MnemonicRegistry.getRegistration(owner);
                MnemonicRegistry.log("registration: " + registration + " releasing registration: " + ownerRegistration);
                if (ownerRegistration.getType() == 1) {
                    MnemonicRegistry.resetComponentMnemonic(owner);
                    if (this.enabled) {
                        this.allocateMnemonic(owner);
                    }
                }
            }
        } else {
            MnemonicRegistry.resetComponentMnemonic(jComponent);
            if (this.enabled) {
                this.allocateMnemonic(jComponent);
            }
        }
    }

    private synchronized void reserveMnemonic(JComponent jComponent, Mnemonic mnemonic) {
        Registration registration = MnemonicRegistry.getRegistration(jComponent);
        this.reservations.put(mnemonic, registration);
        this.reservationsByRegistration.put(registration, mnemonic);
        MnemonicRegistry.log("reserved  mnemonic: " + mnemonic + " registration: " + MnemonicRegistry.getRegistration(jComponent));
    }

    private synchronized void resetManaged() {
        Iterator<Map.Entry<Registration, JComponent>> i$ = this.registrations.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Registration, JComponent> o;
            Map.Entry<Registration, JComponent> entry = o = i$.next();
            Registration registration = entry.getKey();
            JComponent jComponent = entry.getValue();
            if (registration.getType() == 0) continue;
            this.releaseMnemonic(registration);
            MnemonicRegistry.resetComponentMnemonic(jComponent);
        }
    }

    private void unregisterListeners(JComponent jComponent, int type) {
        if (type == 0) {
            jComponent.removeComponentListener(this.unmanagedComponentListener);
            jComponent.removePropertyChangeListener(this.unmanagedComponentListener);
        } else if (type == 1) {
            jComponent.removeComponentListener(this.managedComponentListener);
            jComponent.removePropertyChangeListener(this.managedComponentListener);
        }
    }

    private class UnmanagedComponentListener
    extends ComponentAdapter
    implements PropertyChangeListener,
    ComponentListener {
        private UnmanagedComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
            Mnemonic oldMnemonic = MnemonicRegistry.createMnemonic((Integer)propertyChangeEvent.getOldValue());
            Mnemonic mnemonic = MnemonicRegistry.createMnemonic((Integer)propertyChangeEvent.getNewValue());
            this.mnemonicChanged(jComponent, oldMnemonic, mnemonic);
        }

        private void mnemonicChanged(JComponent jComponent, Mnemonic oldMnemonic, Mnemonic mnemonic) {
            MnemonicRegistry.this.releaseMnemonic(jComponent);
            if (mnemonic != null) {
                JComponent owner = MnemonicRegistry.this.releaseMnemonic(mnemonic);
                MnemonicRegistry.this.reserveMnemonic(jComponent, mnemonic);
                if (owner != null) {
                    MnemonicRegistry.resetComponentMnemonic(owner);
                }
            }
        }
    }

    private class Registration
    implements Comparable {
        private int id;
        private int type;

        public Registration(int type, String name) {
            int count = 0;
            this.id = count++;
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public int compareTo(Object o) {
            return this.id - ((Registration)o).id;
        }

        public String toString() {
            return "<registration " + (this.type != 0 ? "[*]" : "") + " : " + this.id + "/>";
        }
    }

    private class ManagedComponentListener
    extends ComponentAdapter
    implements PropertyChangeListener {
        private ManagedComponentListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
            this.updateMnemonic(jComponent);
        }

        private void resetMnemonic(JComponent jComponent) {
            MnemonicRegistry.this.releaseMnemonic(jComponent);
            MnemonicRegistry.resetComponentMnemonic(jComponent);
        }

        private void updateMnemonic(JComponent jComponent) {
            this.resetMnemonic(jComponent);
            if (MnemonicRegistry.this.enabled) {
                MnemonicRegistry.this.allocateMnemonic(jComponent);
            }
        }
    }

    private static class Mnemonic {
        private int character;
        private Character mnemonic;

        public Mnemonic(char character) {
            this.mnemonic = Character.valueOf(Character.toUpperCase(character));
            this.character = character;
        }

        public int getOriginal() {
            return this.character;
        }

        public char charValue() {
            return this.mnemonic.charValue();
        }

        public boolean equals(Object object) {
            return object instanceof Mnemonic && this.mnemonic.equals(((Mnemonic)object).mnemonic);
        }

        public int hashCode() {
            return this.mnemonic.hashCode();
        }

        public String toString() {
            return this.mnemonic.toString();
        }
    }

    class ResetManagedPropertyChangeListener
    implements PropertyChangeListener {
        private JComponent jComponent;
        private String property;

        public ResetManagedPropertyChangeListener(String property, JComponent jComponent) {
            this.property = property;
            this.jComponent = jComponent;
            jComponent.addPropertyChangeListener(property, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Registration registration = (Registration)this.jComponent.getClientProperty(MnemonicRegistry.REGISTRATION);
            if (registration != null && registration.getType() == 1) {
                Mnemonic reservedMnemonic = (Mnemonic)MnemonicRegistry.this.reservationsByRegistration.get(registration);
                char character = (char)MnemonicRegistry.getComponentMnemonic(this.jComponent);
                if (character != '\u0000') {
                    Mnemonic currentMnemonic = new Mnemonic(character);
                    if (reservedMnemonic != null && !reservedMnemonic.equals(currentMnemonic)) {
                        MnemonicRegistry.this.unregister(this.jComponent);
                        this.jComponent.removePropertyChangeListener(this.property, this);
                        MnemonicRegistry.this.register(this.jComponent, 0);
                    }
                }
            }
        }
    }
}

