/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.List;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBoxMenuItem;
import oracle.bpm.ui.CompositeMenu;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.SelectionFuegoAction;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.MenuListener;
import oracle.bpm.ui.peer.MenuItemPeer;
import oracle.bpm.ui.peer.MenuPeer;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.util.SystemInfo;

public class Menu
extends MenuItem
implements CompositeMenu {
    public static int OPTIONS = 255;

    public Menu(UiContainer parent) {
        super(parent, OPTIONS);
        this.init();
    }

    public Menu(UiContainer parent, String text) {
        super(parent, OPTIONS);
        this.init();
        this.setText(text);
    }

    public Menu(UiContainer parent, Msg msg) {
        super(parent, OPTIONS);
        this.init();
        this.setMsg(msg);
    }

    @Override
    public List<UiComponent> getChildren() {
        return this.getContainerPeer().getChildren();
    }

    @Override
    public MenuItem add(final SelectionFuegoAction action) {
        final CheckBoxMenuItem item = new CheckBoxMenuItem((UiContainer)this, (BaseAction)action, action.isSelected());
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                action.setSelected(item.isSelected());
            }
        });
        this.add(item);
        item.setIcon(action.getSmallIcon());
        return item;
    }

    public int getItemCount() {
        return this.getMenuPeer().getItemCount();
    }

    public void setMnemonic(char mnemonic) {
        super.setMnemonic(mnemonic);
    }

    @Override
    public void setVisible(boolean bool) {
        if (SystemInfo.isAnyMac()) {
            super.setEnabled(bool);
        } else {
            super.setVisible(bool);
        }
    }

    public MenuItem add(String text) {
        return this.add(new MenuItem((UiContainer)this, text));
    }

    @Override
    public MenuItem add(BaseAction a) {
        MenuItem mi = new MenuItem(this);
        mi.setAction(a);
        mi.setIcon(a.getSmallIcon());
        return this.add(mi);
    }

    @Override
    public void addFuegoAction(BaseAction action) {
        this.add(action);
    }

    public MenuItem add(BaseAction a, boolean showDialog) {
        return this.add(a, OPTIONS, showDialog);
    }

    public MenuItem add(BaseAction a, int options) {
        return this.add(a, options, a.showsDialog());
    }

    public MenuItem add(BaseAction a, int options, boolean showDialog) {
        MenuItem mi = new MenuItem((UiContainer)this, a, showDialog);
        this.add(mi);
        mi.setIcon(a.getSmallIcon());
        return mi;
    }

    @Override
    public MenuItem add(MenuItem item) {
        this.getMenuPeer().add((MenuItemPeer)item.getPeer());
        return item;
    }

    public void addMenuListener(MenuListener listener) {
        this.getMenuPeer().addMenuListener(listener);
    }

    @Override
    public void addSeparator() {
        this.getMenuPeer().addSeparator();
    }

    public MenuItem insert(BaseAction a, int pos) {
        MenuItem mi = new MenuItem(this);
        mi.setAction(a);
        return this.insert(mi, pos);
    }

    public void insert(String text, int pos) {
        MenuItem mi = new MenuItem((UiContainer)this, text);
        this.insert(mi, pos);
    }

    public void insert(Msg msg, int pos) {
        MenuItem mi = new MenuItem((UiContainer)this, msg);
        this.insert(mi, pos);
    }

    @Override
    protected Peer createPeer() {
        return Ui.getUiFactory().createMenu(this.getParentPeer());
    }

    @Override
    protected void update() {
        Msg msg = this.getMsg();
        if (msg == null) {
            return;
        }
        int options = this.getOptions();
        if ((options & 1) != 0) {
            super.setText(msg.getString());
        }
        if ((options & 4) != 0) {
            super.setMnemonic(msg.getMnemonic());
        }
    }

    private MenuPeer getMenuPeer() {
        return (MenuPeer)this.getPeer();
    }

    private void init() {
    }

    private MenuItem insert(MenuItem item, int pos) {
        this.getMenuPeer().insert((MenuItemPeer)item.getPeer(), pos);
        return item;
    }
}

