/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.LabelMultilinePeer;
import oracle.bpm.ui.peer.Peer;

public class LabelMultiline
extends UiComponent {
    private Msg msg;

    public LabelMultiline(UiContainer parent) {
        this(parent, UIMsg.TO_MSG(""));
    }

    public LabelMultiline(UiContainer parent, Msg msg) {
        super(parent);
        this.setOpaque(false);
        this.setMsg(msg);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setMsg(Msg msg) {
        this.msg = msg;
        this.update();
    }

    public Msg getMsg() {
        return this.msg;
    }

    @Override
    public String toString() {
        return "LabelMultiline(" + this.hashCode() + ") " + this.getText();
    }

    @Override
    public void translate() {
        Utilities.translateChildComponentTree(this);
        this.update();
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createLabelMultiline(this.getParentPeer());
    }

    private LabelMultilinePeer getLabelMultilinePeer() {
        return (LabelMultilinePeer)this.getPeer();
    }

    private String getText() {
        Msg msg = this.getMsg();
        return msg != null ? msg.getString() : "";
    }

    private void update() {
        this.getLabelMultilinePeer().setText(this.getText());
    }
}

