/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.lang.CharacterUtils;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.text.TextFilter;

public class IdentifierModuleTextField
extends IdentifierTextField {
    public IdentifierModuleTextField(UiContainer parent) {
        super(parent, "", true, true);
    }

    public IdentifierModuleTextField(UiContainer parent, String suggestedName) {
        super(parent, suggestedName, true, true);
    }

    @Override
    protected TextFilter createFilter() {
        return new TextFilter(){

            @Override
            public boolean accepts(String str, int offs) {
                boolean result = true;
                if (str != null) {
                    if (this.isBegin(str, offs, IdentifierModuleTextField.this.getText())) {
                        char ch = str.charAt(0);
                        result = CharacterUtils.isLetter(ch) || ch == '_';
                    }
                    for (int i = 0; result && i < str.length(); ++i) {
                        result = this.isAccepted(str.charAt(i));
                    }
                }
                return result;
            }

            private boolean isBegin(String str, int offs, String allText) {
                return str.length() > 0 && (offs == 0 || allText.charAt(offs - 1) == '.');
            }

            private boolean isAccepted(char c) {
                return CharacterUtils.isLetterOrDigit(c) || c == '_' || c == '.';
            }

            @Override
            public String filter(String text, int offs) {
                return text == null ? null : this.filter(IdentifierModuleTextField.this.getText(), text, offs);
            }

            private String filter(String allText, String text, int offs) {
                if (this.isBegin(text, offs, allText)) {
                    char character = Character.toUpperCase(text.charAt(0));
                    return character + this.filter(allText + character, text.substring(1), offs + 1);
                }
                return text;
            }
        };
    }
}

