/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JInternalFrame;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.ToolTipManager;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseMotionAdapter;
import oracle.bpm.ui.event.MouseMotionListener;
import oracle.bpm.ui.peer.swing.AwtConverter;

public final class ExtToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    private UiComponent component;
    private final Timer enterTimer = this.createTimer(750, new InsideTimerAction());
    private final Timer exitTimer = this.createTimer(500, new OutsideTimerAction());
    private FocusListener focusChangeListener;
    private final KeyStroke hideTip;
    private final BaseAction hideTipAction;
    private final Timer insideTimer = this.createTimer(4000, new StillInsideTimerAction());
    private MouseEvent mouseEvent;
    private MouseMotionListener moveBeforeEnterListener;
    private Rectangle popupRectangle;
    private final KeyStroke postTip = KeyStroke.getKeyStroke(KeyEvent.F(1), 2);
    private final BaseAction postTipAction = new PostTipAction();
    private Point preferredLocation;
    private boolean showImmediately;
    private JToolTip tip;
    private boolean tipShowing = false;
    private Popup tipWindow;
    private String toolTipText;
    private UiWindow window;
    private static final String POST_TIP = "postTip";
    private static final String HIDE_TIP = "hideTip";
    private static final ExtToolTipManager sharedInstance = new ExtToolTipManager();

    private ExtToolTipManager() {
        this.hideTip = KeyStroke.getKeyStroke(27, 0);
        this.hideTipAction = new HideTipAction();
        this.moveBeforeEnterListener = new MoveBeforeEnterListener();
    }

    public static ExtToolTipManager create() {
        return new ExtToolTipManager();
    }

    public static ExtToolTipManager sharedInstance() {
        return sharedInstance;
    }

    public void setInitialDelay(int ms) {
        this.enterTimer.setInitialDelay(ms);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.initiate(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        boolean hide = this.window != null && event.getSource() == this.window ? this.sourceIsWindow(event) : (event.getSource() == this.component && this.tipWindow != null ? this.sourceIsComponent(event) : true);
        if (hide) {
            this.doHide();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.tipShowing) {
            this.checkTipChanged(event);
        } else if (this.showImmediately) {
            UiComponent component = event.getSource();
            this.toolTipText = component.asSwing().getToolTipText();
            if (this.toolTipText != null) {
                this.preferredLocation = component.getToolTipLocation(event);
                this.mouseEvent = event;
                this.component = component;
                this.exitTimer.stop();
                this.showTip();
            }
        } else {
            this.component = event.getSource();
            this.mouseEvent = event;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.component = null;
        this.mouseEvent = null;
    }

    public void registerComponent(UiComponent component) {
        ToolTipManager.sharedInstance().unregisterComponent(component.asSwing());
        component.removeMouseListener(this);
        component.addMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        component.addMouseMotionListener(this.moveBeforeEnterListener);
        if (ExtToolTipManager.registerBindings(component)) {
            InputMap inputMap = component.getInputMap(0);
            ActionMap actionMap = component.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.put(this.postTip.asSwing(), POST_TIP);
                inputMap.put(this.hideTip.asSwing(), HIDE_TIP);
                actionMap.put(POST_TIP, this.postTipAction);
                actionMap.put(HIDE_TIP, this.hideTipAction);
            }
        }
    }

    private static boolean isLeftToRight(UiComponent c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    private static int heightAdjust(Rectangle a, Rectangle b) {
        int bSpan = b.getY() + b.getHeight();
        int aSpan = a.getY() + a.getHeight();
        return b.getY() >= a.getY() && bSpan <= aSpan ? 0 : bSpan - aSpan + 5;
    }

    private static int widthAdjust(Rectangle a, Rectangle b) {
        int bSpan = b.getX() + b.getWidth();
        int aSpan = a.getX() + a.getWidth();
        return b.getX() >= a.getX() && bSpan <= aSpan ? 0 : bSpan - aSpan + 5;
    }

    private static boolean registerBindings(UiComponent component) {
        try {
            InputMap map;
            for (map = component.getInputMap(0); map != null && map.size() == 0; map = map.getParent()) {
            }
            return map != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void doHide() {
        this.enterTimer.stop();
        if (this.component != null) {
            this.component.removeMouseMotionListener(this);
        }
        this.component = null;
        this.toolTipText = null;
        this.mouseEvent = null;
        this.hideTipWindow();
        this.exitTimer.restart();
    }

    private boolean sourceIsComponent(MouseEvent event) {
        boolean result;
        UiWindow win = UiUtilities.getWindowAncestor(this.component);
        if (win == null) {
            result = true;
        } else {
            Rectangle b = this.component.getTopLevelAncestor().getBounds();
            Point p = UiUtilities.convertPoint(this.component, event.getPoint(), win).translate(b.getX(), b.getY());
            Point loc = UiUtilities.convertPointToScreen(new Point(0, 0), UiComponent.get(this.tip));
            b = new Rectangle(loc.getX(), loc.getY(), this.tip.getWidth(), this.tip.getHeight());
            result = p.getX() < b.getX() || p.getX() >= b.getX() + b.getWidth() || p.getY() < b.getY() || p.getY() >= b.getY() + b.getHeight();
        }
        return result;
    }

    private boolean sourceIsWindow(MouseEvent event) {
        UiComponent componentWindow = this.component.getTopLevelAncestor();
        Point p = event.getPoint();
        p = UiUtilities.convertPointToScreen(p, this.window).translate(-componentWindow.getX(), -componentWindow.getY());
        return this.wrongLocation(UiUtilities.convertPoint(null, p, this.component), this.component);
    }

    private Timer createTimer(int time, ActionListener action) {
        Timer enterTimer = new Timer(time, action);
        enterTimer.setRepeats(false);
        return enterTimer;
    }

    private void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    private void showTip() {
        if (this.component == null || !this.component.isShowing()) {
            return;
        }
        Rectangle bounds = AwtConverter.fromAwt(this.component.asSwing().getGraphicsConfiguration().getBounds());
        this.hideTipWindow();
        this.tip = this.component.asSwing().createToolTip();
        this.tip.setTipText(this.toolTipText);
        Dimension size = AwtConverter.fromAwt(this.tip.getPreferredSize());
        Point location = this.tipLocation(size);
        this.setPopupRectangle(location, size);
        int x = location.getX();
        int y = location.getY();
        if (this.component != null) {
            int w;
            int h = this.popupFitHeight();
            if (h > 0) {
                y -= h;
            }
            if ((w = this.popupFitWidth()) > 0) {
                x -= w;
            }
        }
        if (x < bounds.getX()) {
            x = bounds.getX();
        } else if (x - bounds.getX() + size.getWidth() > bounds.getWidth()) {
            x = bounds.getX() + Math.max(0, bounds.getWidth() - size.getWidth());
        }
        if (y < bounds.getY()) {
            y = bounds.getY();
        } else if (y - bounds.getY() + size.getHeight() > bounds.getHeight()) {
            y = bounds.getY() + Math.max(0, bounds.getHeight() - size.getHeight());
        }
        location = new Point(x, y);
        this.showTipWindow(location);
        UiWindow componentWindow = UiUtilities.windowForComponent(this.component);
        this.window = UiUtilities.windowForComponent(UiComponent.get(this.tip));
        if (this.window != null && this.window != componentWindow) {
            this.window.addMouseListener(this);
        } else {
            this.window = null;
        }
        this.insideTimer.start();
        this.tipShowing = true;
    }

    private void showTipWindow(Point location) {
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.tipWindow = popupFactory.getPopup(this.component.asSwing(), this.tip, location.getX(), location.getY());
        this.tipWindow.show();
    }

    private void setPopupRectangle(Point location, Dimension size) {
        this.popupRectangle = new Rectangle(location, size);
    }

    private Point tipLocation(Dimension size) {
        int y;
        int x;
        Point screenPos = this.component.getLocationOnScreen();
        if (this.preferredLocation == null) {
            x = screenPos.getX() + this.mouseEvent.getX();
            y = screenPos.getY() + this.mouseEvent.getY() + 20;
            if (!ExtToolTipManager.isLeftToRight(this.component) && x - size.getWidth() >= 0) {
                x -= size.getWidth();
            }
        } else {
            x = screenPos.getX() + this.preferredLocation.getX();
            y = screenPos.getY() + this.preferredLocation.getY();
            if (!ExtToolTipManager.isLeftToRight(this.component)) {
                x -= size.getWidth();
            }
        }
        return new Point(x, y);
    }

    private int popupFitHeight() {
        for (UiContainer parent = this.component.getParent(); parent != null; parent = parent.getParent()) {
            Rectangle bounds = parent.getBounds();
            if (this.isNormalWindow(parent)) {
                return ExtToolTipManager.heightAdjust(bounds, this.popupRectangle);
            }
            if (!this.isInternalFrame(parent)) continue;
            Point p = parent.getLocationOnScreen();
            Rectangle frameRectangle = new Rectangle(p.getX(), p.getY(), bounds.getWidth(), bounds.getHeight());
            return ExtToolTipManager.heightAdjust(frameRectangle, this.popupRectangle);
        }
        return 0;
    }

    private boolean isInternalFrame(UiContainer parent) {
        return parent.asSwing() instanceof JInternalFrame;
    }

    private int popupFitWidth() {
        for (UiContainer parent = this.component.getParent(); parent != null; parent = parent.getParent()) {
            Rectangle bounds = parent.getBounds();
            if (this.isNormalWindow(parent)) {
                return ExtToolTipManager.widthAdjust(bounds, this.popupRectangle);
            }
            if (!this.isInternalFrame(parent)) continue;
            Point p = parent.getLocationOnScreen();
            Rectangle frameRectangle = new Rectangle(p.getX(), p.getY(), bounds.getWidth(), bounds.getHeight());
            return ExtToolTipManager.widthAdjust(frameRectangle, this.popupRectangle);
        }
        return 0;
    }

    private boolean isNormalWindow(UiContainer parent) {
        return parent instanceof Frame || parent instanceof Dialog || parent.getNative() instanceof JWindow;
    }

    private void checkTipChanged(MouseEvent event) {
        UiComponent component = event.getSource();
        String text = component.asSwing().getToolTipText();
        Point location = component.getToolTipLocation(event);
        if (text == null && location == null) {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.component = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        } else {
            boolean locationChange;
            this.mouseEvent = event;
            boolean textChange = text != null && !text.equals(this.toolTipText);
            boolean bl = locationChange = location != null && !location.equals(this.preferredLocation);
            if (textChange || locationChange) {
                this.toolTipText = text;
                this.preferredLocation = location;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTip();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            } else if (this.tipWindow != null) {
                this.insideTimer.restart();
            } else {
                this.enterTimer.restart();
            }
        }
    }

    private FocusListener createFocusChangeListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ExtToolTipManager.this.hideTipWindow();
                ExtToolTipManager.this.component = null;
                UiComponent c = evt.getSource();
                c.removeFocusListener(ExtToolTipManager.this.focusChangeListener);
            }
        };
    }

    private void initiate(MouseEvent event) {
        if (event.getSource() != this.window) {
            UiComponent component = event.getSource();
            this.initiate(event, component);
        }
    }

    private void initiate(MouseEvent event, UiComponent component) {
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.exitTimer.stop();
        if (this.wrongLocation(event.getPoint(), component)) {
            return;
        }
        if (this.component != null) {
            this.enterTimer.stop();
        }
        component.removeMouseMotionListener(this);
        component.addMouseMotionListener(this);
        boolean sameComponent = this.component == component;
        this.component = component;
        if (this.tipWindow != null) {
            this.mouseEvent = event;
            if (!this.showImmediately) {
                this.enterTimer.start();
            } else {
                boolean sameLocation;
                String text = component.asSwing().getToolTipText();
                Point location = component.getToolTipLocation(event);
                boolean bl = sameLocation = this.preferredLocation == location || this.preferredLocation != null && this.preferredLocation.equals(location);
                if (!(sameComponent && this.toolTipText.equals(text) && sameLocation)) {
                    this.toolTipText = text;
                    this.preferredLocation = location;
                    this.showTip();
                }
            }
        }
    }

    private boolean wrongLocation(Point location, UiComponent component) {
        return location.getX() < 0 || location.getX() >= component.getWidth() || location.getY() < 0 || location.getY() >= component.getHeight();
    }

    private class PostTipAction
    extends BaseAction {
        private PostTipAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExtToolTipManager.this.tipWindow != null) {
                ExtToolTipManager.this.hideTipWindow();
                ExtToolTipManager.this.component = null;
            } else {
                ExtToolTipManager.this.hideTipWindow();
                ExtToolTipManager.this.enterTimer.stop();
                ExtToolTipManager.this.exitTimer.stop();
                ExtToolTipManager.this.insideTimer.stop();
                ExtToolTipManager.this.component = e.getSource();
                if (ExtToolTipManager.this.component != null) {
                    ExtToolTipManager.this.toolTipText = ExtToolTipManager.this.component.getToolTipText();
                    ExtToolTipManager.this.preferredLocation = new Point(10, ExtToolTipManager.this.component.getHeight() + 10);
                    ExtToolTipManager.this.showTip();
                    if (ExtToolTipManager.this.focusChangeListener == null) {
                        ExtToolTipManager.this.focusChangeListener = ExtToolTipManager.this.createFocusChangeListener();
                    }
                    ExtToolTipManager.this.component.addFocusListener(ExtToolTipManager.this.focusChangeListener);
                }
            }
        }
    }

    private final class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ExtToolTipManager.this.initiate(e);
        }
    }

    private class HideTipAction
    extends BaseAction {
        private HideTipAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtToolTipManager.this.hideTipWindow();
            UiComponent jc = e.getSource();
            jc.removeFocusListener(ExtToolTipManager.this.focusChangeListener);
            ExtToolTipManager.this.preferredLocation = null;
            ExtToolTipManager.this.component = null;
        }

        @Override
        public boolean isEnabled() {
            return ExtToolTipManager.this.tipShowing;
        }
    }

    final class OutsideTimerAction
    implements ActionListener {
        OutsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtToolTipManager.this.showImmediately = false;
        }
    }

    final class InsideTimerAction
    implements ActionListener {
        InsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExtToolTipManager.this.component != null && ExtToolTipManager.this.component.isShowing()) {
                if (ExtToolTipManager.this.toolTipText == null && ExtToolTipManager.this.mouseEvent != null) {
                    ExtToolTipManager.this.toolTipText = ExtToolTipManager.this.component.asSwing().getToolTipText();
                    ExtToolTipManager.this.preferredLocation = ExtToolTipManager.this.component.getToolTipLocation(ExtToolTipManager.this.mouseEvent);
                }
                if (ExtToolTipManager.this.toolTipText != null) {
                    ExtToolTipManager.this.showImmediately = true;
                    ExtToolTipManager.this.showTip();
                } else {
                    ExtToolTipManager.this.component = null;
                    ExtToolTipManager.this.toolTipText = null;
                    ExtToolTipManager.this.preferredLocation = null;
                    ExtToolTipManager.this.mouseEvent = null;
                    ExtToolTipManager.this.hideTipWindow();
                }
            }
        }
    }

    static final class StillInsideTimerAction
    implements ActionListener {
        StillInsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

