/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorDialog
extends OkCancelDialog {
    private boolean isLoaded = false;

    public EditorDialog(@NotNull UiWindow parent, @Nullable Msg title) {
        super(parent, title);
    }

    public boolean display() {
        this.setVisible(true);
        return this.userAccepted();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.isLoaded) {
            this.load();
            this.isLoaded = false;
        }
        super.setVisible(visible);
    }

    @Override
    public void ok() {
        Msg errorMessage = this.validateInput();
        if (errorMessage != null) {
            MessageDialog.showError(errorMessage);
            return;
        }
        this.applyChanges();
        this.close();
    }

    protected abstract void layoutControls(@NotNull UiContainer var1);

    protected void applyChanges() {
    }

    protected Msg validateInput() {
        return null;
    }

    protected void load() {
        this.layoutControls(this.getContentPane());
    }
}

