/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.BoolMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.Nullable;

public class DialogFactory {
    public static boolean showConfirmDialog(HiddenMessagesPreferences preferences, Msg titleMessage, Msg confirmMsg) {
        return DialogFactory.showConfirmDialog(preferences, titleMessage, confirmMsg, (String)null);
    }

    public static boolean showConfirmDialog(Msg titleMessage, Msg confirmMsg) {
        return DialogFactory.showConfirmDialog(null, titleMessage, confirmMsg);
    }

    public static boolean showConfirmDialog(HiddenMessagesPreferences preferences, Msg titleMessage, Msg message, Msg confirmMsg) {
        return DialogFactory.showConfirmDialog(preferences, titleMessage, message, confirmMsg, null, false);
    }

    public static boolean showConfirmDialog(HiddenMessagesPreferences preferences, Msg titleMessage, Msg confirmMsg, String details) {
        return DialogFactory.showConfirmDialog(preferences, titleMessage, confirmMsg, details, false);
    }

    public static Object[] showInputDialog(UiWindow parent, Msg message, Msg title, Object[] selectionValues, Object initialSelectionValue, boolean multiSelection) {
        return DialogFactory.showInputDialog(parent, message, title, selectionValues, initialSelectionValue, multiSelection, null);
    }

    public static Object[] showInputDialog(UiWindow parent, @Nullable Msg message, final Msg title, Object[] selectionValues, @Nullable Object initialSelectionValue, boolean multiSelection, LabelProvider labelProvider) {
        OkCancelDialog dialog = new OkCancelDialog(parent, title, true){

            @Override
            public void ok() {
                this.close();
            }

            @Override
            public String getHelpId() {
                return title != null ? super.getHelpId() + "." + title.getCode() : super.getHelpId();
            }
        };
        Panel container = new Panel(dialog.getContentPane());
        List list = DialogFactory.createInput(container, selectionValues, initialSelectionValue, multiSelection);
        if (labelProvider != null) {
            list.setLabelProvider(labelProvider);
        }
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, fill:pref:grow, 5dlu");
        PanelBuilder builder = layout.createBuilder(container);
        CellConstraints cc = layout.createCellConstraints();
        if (message != null) {
            builder.addSeparator(message.getString(), cc.xy(2, 2));
        }
        builder.add((UiComponent)list, cc.xy(2, 4));
        OkCancelDialog.doShowDialog(dialog, container);
        if (dialog.userAccepted()) {
            return list.getSelectedValues().toArray();
        }
        return new Object[0];
    }

    public static void showWarningDialog(HiddenMessagesPreferences preferences, Msg warningMsg, String details) {
        if (!preferences.isMessageHidden(warningMsg.getCode())) {
            BoolMsg msg = new BoolMsg(false, UIMsg.DO_NOT_SHOW_THIS_MESSAGE);
            MessageDialog.showWarning(warningMsg, UIMsg.TO_MSG(details), msg);
            if (msg.value) {
                preferences.addMessageHidden(warningMsg.getCode(), "");
            }
        }
    }

    private static List createInput(UiContainer parent, Object[] selectionValues, Object initialSelectionValue, boolean multiSelection) {
        ListSelectionMode mode = multiSelection ? ListSelectionMode.MULTIPLE_INTERVAL_SELECTION : ListSelectionMode.SINGLE_SELECTION;
        List list = List.create(parent, selectionValues, mode);
        if (initialSelectionValue != null) {
            list.setSelectedValue(initialSelectionValue, true);
        }
        return list;
    }

    private static boolean showConfirmDialog(HiddenMessagesPreferences preferences, Msg titleMessage, Msg confirmMsg, String details, boolean storeAll) {
        return DialogFactory.showConfirmDialog(preferences, titleMessage, confirmMsg, confirmMsg, details, storeAll);
    }

    private static boolean showConfirmDialog(HiddenMessagesPreferences preferences, Msg titleMessage, Msg message, Msg confirmMsg, String details, boolean storeAll) {
        boolean result;
        if (preferences != null && preferences.isMessageHidden(message.getCode())) {
            return Boolean.valueOf(preferences.getMessageValue(message.getCode()));
        }
        BoolMsg msg = preferences == null ? null : new BoolMsg(false, UIMsg.DO_NOT_SHOW_THIS_MESSAGE);
        int answer = MessageDialog.showQuestion((UiContainer)null, titleMessage, confirmMsg, details == null ? null : UIMsg.TO_MSG(details), 6, msg);
        boolean bl = result = answer == 2;
        if (preferences != null && msg.value && (result || storeAll)) {
            preferences.addMessageHidden(message.getCode(), result + "");
        }
        return result;
    }
}

