/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorChooser;
import oracle.bpm.ui.ColorTransformation;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.LineBorder;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class ColorPicker
extends Panel {
    private Color color;
    private Panel label;

    public ColorPicker(@NotNull UiContainer parent, @NotNull Msg title) {
        this(parent, title, Color.WHITE, ColorTransformation.NONE);
    }

    public ColorPicker(@NotNull UiContainer parent, @NotNull Msg title, @NotNull Color color, @NotNull ColorTransformation transformation) {
        super(parent);
        this.setLayout(new BorderLayout(3, 3));
        this.color = color;
        this.init(title, color, transformation);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.label.setBackground(color);
        this.repaint();
    }

    private void init(final Msg title, final Color color, final ColorTransformation transformation) {
        this.label = new Panel(this);
        this.label.setBorder(new LineBorder(Color.BLACK));
        this.label.setMinimumSize(Dimension.valueOf(50, 10));
        Button clear = Button.createIconic(this, UIMsg.CLEAR);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Color result = ColorChooser.showDialog(ColorPicker.this, title, color, transformation);
                if (result != null) {
                    ColorPicker.this.setColor(result);
                }
            }
        });
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPicker.this.setColor((Color)transformation.eval(Color.WHITE));
            }
        });
        this.setColor(color);
        this.add(this.label, "Center");
        this.add(clear, "East");
    }
}

