/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.peer.CheckBoxMenuItemPeer;
import oracle.bpm.ui.peer.Peer;

public class CheckBoxMenuItem
extends MenuItem {
    public static int OPTIONS = 255;

    public CheckBoxMenuItem(BaseAction a) {
        this(null, a);
    }

    public CheckBoxMenuItem(UiContainer parent, Msg msg) {
        super(parent, OPTIONS);
        this.setMsg(msg);
    }

    public CheckBoxMenuItem(UiContainer parent, BaseAction a) {
        super(parent, OPTIONS);
        this.setAction(a);
        this.setMsg(a.getMsg(), OPTIONS);
    }

    public CheckBoxMenuItem(UiContainer parent, BaseAction a, boolean selected) {
        super(parent, OPTIONS);
        this.setAction(a);
        this.setMsg(a.getMsg(), OPTIONS);
        this.setSelected(selected);
    }

    public void addItemListener(ItemListener listener) {
        this.getAbstractPeer().addItemListener(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.getAbstractPeer().removeItemListener(listener);
    }

    @Override
    public void setSelected(boolean selected) {
        this.setState(selected);
    }

    @Override
    public boolean isSelected() {
        return this.getState();
    }

    public void setState(boolean b) {
        this.getCheckBoxMenuItemPeer().setState(b);
    }

    public boolean getState() {
        return this.getCheckBoxMenuItemPeer().getState();
    }

    @Override
    protected Peer createPeer() {
        return Ui.getUiFactory().createCheckBoxMenuItem(this.getParentPeer());
    }

    @Override
    protected void update() {
        Msg msg = this.getMsg();
        if (msg == null) {
            return;
        }
        int options = this.getOptions();
        if ((options & 1) != 0) {
            super.setText(msg.getString());
        }
        if ((options & 4) != 0) {
            super.setMnemonic(msg.getMnemonic());
        }
        if ((options & 2) != 0) {
            super.setIcon(msg);
        }
    }

    private CheckBoxMenuItemPeer getCheckBoxMenuItemPeer() {
        return (CheckBoxMenuItemPeer)this.getPeer();
    }
}

