/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.Collections;
import java.util.List;
import javax.swing.ButtonModel;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.peer.AbstractButtonPeer;
import oracle.bpm.ui.peer.Peer;

public abstract class AbstractButton
extends UiContainer {
    private Msg msg;
    private int options;

    protected AbstractButton(Peer peer) {
        super(peer);
    }

    protected AbstractButton(UiContainer parent, int options) {
        super(parent);
        this.options = options;
    }

    public void addActionListener(ActionListener listener) {
        this.getAbstractPeer().addActionListener(listener);
    }

    public void doClick() {
        this.getAbstractPeer().doClick();
    }

    public BaseAction getAction() {
        return this.getAbstractPeer().getAction();
    }

    public String getActionCommand() {
        return this.getAbstractPeer().getActionCommand();
    }

    @Override
    public List<UiComponent> getChildren() {
        return Collections.emptyList();
    }

    public Image getIcon() {
        return this.getAbstractPeer().getIcon();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public ButtonModel getModel() {
        return this.getAbstractPeer().getModel();
    }

    public Msg getMsg() {
        return this.msg;
    }

    public int getOptions() {
        return this.options;
    }

    public String getText() {
        return this.getAbstractPeer().getText();
    }

    public boolean isSelected() {
        return this.getAbstractPeer().isSelected();
    }

    public void removeActionListener(ActionListener listener) {
        this.getAbstractPeer().removeActionListener(listener);
    }

    public void setAction(BaseAction action) {
        ((AbstractButtonPeer)this.getComponentPeer()).setAction(action);
        Msg msg = action.getMsg();
        if (msg != null && !msg.equals(this.getMsg())) {
            this.setMsg(msg);
        } else {
            this.update();
        }
    }

    public void setActionCommand(String command) {
        this.getAbstractPeer().setActionCommand(command);
    }

    public void setBorderPainted(boolean painted) {
        this.getAbstractPeer().setBorderPainted(painted);
    }

    public void setContentAreaFilled(boolean filled) {
        this.getAbstractPeer().setContentAreaFilled(filled);
    }

    public void setDisabledIcon(Image icon) {
        this.getAbstractPeer().setDisabledIcon(icon);
    }

    public void setFocusPainted(boolean painted) {
        this.getAbstractPeer().setFocusPainted(painted);
    }

    public void setHorizontalAlignment(int align) {
        this.getAbstractPeer().setHorizontalAlignment(align);
    }

    public void setHorizontalTextPosition(int center) {
        this.getAbstractPeer().setHorizontalTextPosition(center);
    }

    public void setIcon(Msg msg) {
        this.getAbstractPeer().setIcon(Image.create(msg));
    }

    public void setIcon(Image icon) {
        this.getAbstractPeer().setIcon(icon);
    }

    public void setMargin(Margin insets) {
        this.getAbstractPeer().setMargin(insets);
    }

    public void setMnemonic(int mnemonic) {
        this.getAbstractPeer().setMnemonic(mnemonic);
    }

    public void setMsg(Msg msg) {
        this.msg = msg;
        this.update();
    }

    public void setMsg(Msg msg, int options) {
        this.msg = msg;
        this.setOptions(options);
        if (this.getName() == null && msg != null) {
            this.setName(msg.getCode());
        }
    }

    public void setOptions(int options) {
        this.resetOptions(this.options | ~options);
        this.options = options;
        this.update();
    }

    public void setPressedIcon(Msg msg) {
        this.getAbstractPeer().setPressedIcon(Image.create(msg));
    }

    public void setPressedIcon(Image icon) {
        this.getAbstractPeer().setPressedIcon(icon);
    }

    public void setRolloverEnabled(boolean b) {
        this.getAbstractPeer().setRolloverEnabled(b);
    }

    public void setRolloverIcon(Image icon) {
        this.getAbstractPeer().setRolloverIcon(icon);
    }

    public void setRolloverSelectedIcon(Image icon) {
        this.getAbstractPeer().setRolloverSelectedIcon(icon);
    }

    public void setSelected(boolean selected) {
        this.getAbstractPeer().setSelected(selected);
    }

    public void setSelectedIcon(Image icon) {
        this.getAbstractPeer().setSelectedIcon(icon);
    }

    public void setSelectedIcon(Msg msg) {
        this.getAbstractPeer().setSelectedIcon(msg != null ? Image.create(msg) : null);
    }

    public void setText(String text) {
        this.getAbstractPeer().setText(text);
    }

    public void setVerticalTextPosition(int bottom) {
        this.getAbstractPeer().setVerticalTextPosition(bottom);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " [" + this.hashCode() + "] " + this.getName() != null ? "\n\tname: \"" + this.getName() + "\"" : ("" + this.getText() != null ? "\n\ttext: \"" + this.getText() + "\"" : "");
    }

    @Override
    public final void translate() {
        Utilities.translateChildComponentTree(this);
        this.update();
    }

    protected abstract AbstractButtonPeer getAbstractPeer();

    protected abstract void update();

    protected void resetOptions(int options) {
        if ((options & 1) != 0) {
            this.setText("");
        }
        if ((options & 4) != 0) {
            this.setMnemonic(0);
        }
        if ((options & 8) != 0) {
            super.setToolTipText((Msg)null);
        }
        if ((options & 2) != 0) {
            this.setIcon((Image)null);
        }
    }
}

