/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.swing.properties;

import oracle.bpm.swing.properties.InvalidPropertyValueException;
import oracle.bpm.swing.properties.MissingMandatoryValueException;
import oracle.bpm.swing.properties.PropertyFieldInterface;
import oracle.bpm.swing.properties.PropertyListener;
import oracle.bpm.swing.properties.SingleProperty;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.text.NumericField;

public class NumericPropertyField
extends NumericField<Integer>
implements PropertyFieldInterface,
PropertyListener {
    volatile boolean doUpdate = true;
    SingleProperty property;

    NumericPropertyField(UiContainer parent, SingleProperty property) {
        super(parent, Integer.class, false);
        this.setColumns(10);
        if (property.getValue() != null) {
            this.setValue((Integer)property.getValue());
        }
        this.property = property;
        this.property.addPropertyListener(this);
        this.setEditable(property.isEditable());
    }

    public SingleProperty getProperty() {
        return this.property;
    }

    public String getPropertyText() {
        return this.property.getValue().toString();
    }

    @Override
    public void dataChanged(SingleProperty root) {
        UiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NumericPropertyField.this.doUpdate = false;
                int loc = NumericPropertyField.this.getCaretPosition();
                NumericPropertyField.this.setValue(Integer.valueOf(NumericPropertyField.this.getPropertyText()));
                if (NumericPropertyField.this.getPropertyText().length() >= loc) {
                    NumericPropertyField.this.setCaretPosition(loc);
                } else {
                    NumericPropertyField.this.setCaretPosition(NumericPropertyField.this.getPropertyText().length());
                }
                NumericPropertyField.this.doUpdate = true;
            }
        });
    }

    @Override
    public void updatePredefinedValues() {
    }

    @Override
    public void updateProperty() {
        if (!this.doUpdate) {
            return;
        }
        try {
            this.property.setValue(this.getValue());
        }
        catch (NumberFormatException e) {
            this.property.setValue(0);
        }
    }

    @Override
    public void validateProperties() throws InvalidPropertyValueException, MissingMandatoryValueException {
        if (this.getProperty().isEditable() && this.getProperty().isRequired() && "".equals(this.toString())) {
            throw new MissingMandatoryValueException(this.getProperty());
        }
        try {
            this.getProperty().validate(this.getValue());
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyValueException((Object)this.toString(), this.getProperty().getKey());
        }
    }
}

