/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Ellipse;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Polygon;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractGraphics
implements Graphics {
    @Override
    public void setClip(Rectangle rec) {
        this.setClip(rec.getX(), rec.getY(), rec.getWidth(), rec.getHeight());
    }

    @Override
    public void fill(Polygon pol) {
        this.fill(pol.getBoundingBox());
    }

    @Override
    public void draw(Polygon p) {
        this.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    @Override
    public boolean drawImage(Image img, Point location, UiComponent observer) {
        return this.drawImage(img, location.getX(), location.getY(), observer);
    }

    @Override
    public boolean drawImage(Image img, Rectangle bounds) {
        return this.drawImage(img, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), null);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height) {
        return this.drawImage(img, x, y, width, height, null);
    }

    @Override
    public void fill(Rectangle r) {
        this.fillRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public void draw(Rectangle r) {
        this.drawRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public void draw(Ellipse e) {
        this.drawOval(e.getX(), e.getY(), e.getWidth(), e.getHeight());
    }

    @Override
    public void drawString(String textToDraw, @NotNull Rectangle bounds, @NotNull Color background) {
        Color original = this.getForeground();
        this.setForeground(background);
        this.fill(bounds);
        this.setForeground(original);
        this.drawString(textToDraw, bounds.getX(), bounds.getY() + bounds.getHeight());
    }

    @Override
    public void drawString(String textToDraw, int x, int y, Color background) {
        FontMetrics fontMetrics = this.getFontMetrics();
        Rectangle box = Rectangle.valueOf(x, y - fontMetrics.getAscent(), fontMetrics.stringWidth(textToDraw), fontMetrics.getHeight());
        Color c = this.getForeground();
        this.setForeground(background);
        this.fill(box);
        this.setForeground(c);
        this.drawString(textToDraw, x, y);
    }

    @Override
    public final void drawArrow(double x0, double y0, double x1, double y1, int arrowWidth) {
        double slope = Point.angle(x0, y0, x1, y1);
        double dx = (double)arrowWidth * Math.sin(slope);
        double dy = (double)arrowWidth * Math.cos(slope);
        int[] xs = new int[]{(int)(x0 - dx), (int)x1, (int)(x0 + dx)};
        int[] ys = new int[]{(int)(y0 + dy), (int)y1, (int)(y0 - dy)};
        this.drawPolygon(xs, ys, 3);
        this.fillPolygon(xs, ys, 3);
    }

    @Override
    public final void drawRhomb(double x0, double y0, double x1, double y1, int width, @NotNull Color fill) {
        double mx = (x0 + x1) / 2.0;
        double my = (y0 + y1) / 2.0;
        double slope = Point.angle(x0, y0, x1, y1);
        double dx = (double)width * Math.sin(slope);
        double dy = (double)width * Math.cos(slope);
        int[] xs = new int[]{(int)x0, (int)(mx - dx), (int)x1, (int)(mx + dx)};
        int[] ys = new int[]{(int)y0, (int)(my + dy), (int)y1, (int)(my - dy)};
        Color foreground = this.getForeground();
        this.setForeground(fill);
        this.fillPolygon(xs, ys, 4);
        this.setForeground(foreground);
        this.drawPolygon(xs, ys, 4);
    }
}

