/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import java.io.Serializable;
import oracle.bpm.xobject.UtilitiesLib;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class XFormRow
extends XFormPresentationXMLObject
implements Serializable {
    public XFormCell[] cell;
    static final long serialVersionUID = 4803389710226770275L;
    static final long serialCheck = -7344079201076887242L;

    public XFormRow() {
        this.setCssClass("fo_cell");
    }

    public XFormRow(int rowParameter) {
        this.expand(rowParameter);
    }

    @Override
    public int getComponentID() {
        return 10;
    }

    public int getIndexReferenceTo(String dataId) {
        if (this.cell != null) {
            for (int i = 0; i < this.cell.length; ++i) {
                if (!this.cell[i].hasReferenceTo(dataId)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public String getName() {
        return "row";
    }

    @Override
    public boolean contains(XFormXMLObject object) {
        for (int i = 0; i < this.cell.length; ++i) {
            XFormCell xFormCell = this.cell[i];
            if (xFormCell != object) continue;
            return true;
        }
        return false;
    }

    public void expand(int cols) {
        this.cell = new XFormCell[cols];
        for (int i = 0; i < this.cell.length; ++i) {
            this.cell[i] = new XFormCell();
            this.cell[i].setParent(this);
        }
    }

    @Override
    public boolean hasReferenceTo(String dataId) {
        if (this.cell != null) {
            for (int i = 0; i < this.cell.length; ++i) {
                if (!this.cell[i].hasReferenceTo(dataId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean invokes(String signature) {
        if (this.cell != null) {
            for (int i = 0; i < this.cell.length; ++i) {
                if (!this.cell[i].invokes(signature)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeInvocationTo(String signature) {
        if (this.cell != null) {
            for (int i = 0; i < this.cell.length; ++i) {
                this.cell[i].removeInvocationTo(signature);
            }
        }
    }

    @Override
    public void removeReferenceTo(String dataId) {
        if (this.cell != null) {
            for (int i = 0; i < this.cell.length; ++i) {
                this.cell[i].removeReferenceTo(dataId);
            }
        }
    }

    @Override
    public void renameReferenceTo(String oldReference, String newReference) {
        if (this.cell != null) {
            for (int i = 0; i < this.cell.length; ++i) {
                this.cell[i].renameReferenceTo(oldReference, newReference);
            }
        }
    }

    public int indexOf(XFormCell theCell) {
        int result = -1;
        if (theCell != null && this.cell != null) {
            for (int i = 0; i < this.cell.length; ++i) {
                if (!theCell.equals(this.cell[i])) continue;
                result = i;
            }
        }
        return result;
    }

    @Override
    public int getIndex(XFormXMLObject nodeToClear) {
        return nodeToClear instanceof XFormCell ? this.indexOf((XFormCell)nodeToClear) : super.getIndex(nodeToClear);
    }

    @Override
    public XFormXMLObject getChildAt(int index) {
        return index < this.cell.length && index >= 0 ? this.cell[index] : super.getChildAt(index);
    }

    @Override
    public int getChildCount() {
        return this.cell == null ? 0 : this.cell.length;
    }

    @Override
    public boolean move(XFormXMLObject child, boolean up) {
        boolean result;
        int actualIndex = this.getIndex(child);
        if (actualIndex >= 0) {
            int newIndex;
            int n = newIndex = up ? actualIndex - 1 : actualIndex + 1;
            if (newIndex < 0 || newIndex >= this.getChildCount()) {
                result = false;
            } else {
                XFormCell object = this.cell[newIndex];
                this.cell[newIndex] = (XFormCell)child;
                this.cell[actualIndex] = object;
                result = true;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public String getId() {
        return UtilitiesLib.buildRowId((XFormPresentationXMLObject)this.getParent(), this);
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public XFormPresentationXMLObject findComponent(String dataId) {
        XFormPresentationXMLObject result = null;
        if (dataId.equals(this.getId())) {
            result = this;
        } else if (this.cell != null) {
            for (int i = 0; result == null && i < this.cell.length; ++i) {
                result = this.cell[i].findComponent(dataId);
            }
        }
        return result;
    }

    public int calculateColumns() {
        int length = 0;
        if (this.cell != null) {
            for (XFormCell eachCell : this.cell) {
                length += eachCell.getHexpand();
            }
        }
        return length;
    }
}

