/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.util.Identifier;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormBackground;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormCheck;
import oracle.bpm.xobject.presentationmodel.XFormCombo;
import oracle.bpm.xobject.presentationmodel.XFormDatetimepiker;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormInterval;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormMultilinetext;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRepeatablesection;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class XFormPresentationModelHelper {
    private static int checkCount = 0;
    private static int timePicker = 0;
    private static int intervalCount = 0;
    private static int imageCount = 0;
    private static int textCount = 0;
    private static int multilinetextCount = 0;
    private static int comboCount = 0;
    private static int labelCount = 0;
    private static int arrayCount = 0;
    private static int tableCount = 0;
    public static final String TABLE_WIDTH_FULL = "100%";

    public static MethodTypeDescription getMethod(ObjectTypeDescription model, String referencedMethod) {
        String name;
        MethodTypeDescription method;
        String methodSignature = referencedMethod;
        int separatorPos = referencedMethod.indexOf("[].:");
        if (separatorPos >= 0) {
            String innerName;
            TypeRef innerObject;
            methodSignature = referencedMethod.substring(separatorPos + "[].:".length());
            if (model.isBpmObject() && !model.isInnerType() && (innerObject = model.findInnerType(Identifier.classname(innerName = referencedMethod.substring(0, separatorPos)))) != null) {
                model = innerObject.get().asObject();
            }
        }
        return (method = model.findMethod(name = JavaClass.getMethodNameFromSignature(methodSignature))) != null && methodSignature.equals(method.getSignature()) ? method : null;
    }

    public static XFormUserInputPresentationXMLObject createGroupInputForAttribute(AttributeTypeDescription attribute, String groupName) {
        return XFormPresentationModelHelper.createInputForAttribute(attribute, groupName, groupName + "[]." + attribute.getName(), PresentationGenerationOptions.load());
    }

    public static XFormUserInputPresentationXMLObject createInputForAttribute(AttributeTypeDescription attribute, String arrayName, String referenceId, PresentationGenerationOptions options) {
        boolean isEditable = attribute.hasSetter();
        TypeDescription resultType = attribute.getResultType();
        if (arrayName == null) {
            arrayName = "";
        }
        if (!arrayName.trim().equals("")) {
            arrayName = arrayName + "_";
        }
        boolean inArray = !arrayName.equals("");
        int kind = resultType.getKind();
        XFormUserInputPresentationXMLObject inputObject = null;
        if (kind != 12 && attribute.hasValidValues()) {
            XFormCombo combo = new XFormCombo();
            combo.reference = referenceId;
            combo.id = arrayName + "combo" + comboCount++;
            options.apply(combo);
            combo.editable = isEditable;
            inputObject = combo;
        } else {
            switch (kind) {
                case 1: {
                    XFormCheck check = new XFormCheck();
                    check.reference = referenceId;
                    check.id = arrayName + "check" + checkCount++;
                    check.editable = isEditable;
                    inputObject = check;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    XFormText number = new XFormText();
                    options.apply(number);
                    number.setColqty(resultType.getLength() > 0 ? Math.min(resultType.getLength(), options.getTextDefaultColQty()) : options.getTextDefaultColQty());
                    String numberCellDefaultAlignment = options.getNumberDefaultAlignment();
                    if (numberCellDefaultAlignment != null) {
                        number.alignment = numberCellDefaultAlignment;
                    }
                    number.reference = referenceId;
                    number.id = arrayName + "text" + textCount++;
                    number.editable = isEditable;
                    inputObject = number;
                    break;
                }
                case 5: {
                    XFormText xFormText;
                    XFormUserInputPresentationXMLObject text;
                    XFormMultilinetext xFormMultilinetext;
                    if (!inArray && resultType.getLength() > options.getTextDefaultColQty()) {
                        xFormMultilinetext = new XFormMultilinetext();
                        xFormMultilinetext.id = arrayName + "multilinetext" + multilinetextCount++;
                        text = xFormMultilinetext;
                    } else {
                        xFormText = new XFormText();
                        xFormText.id = arrayName + "text" + textCount++;
                        text = xFormText;
                    }
                    options.apply(text);
                    if (text instanceof XFormMultilinetext) {
                        xFormMultilinetext = (XFormMultilinetext)text;
                        xFormMultilinetext.setColqty(options.getTextDefaultColQty());
                        xFormMultilinetext.setLineqty(10);
                        xFormMultilinetext.editable = isEditable;
                    } else {
                        xFormText = text;
                        xFormText.setColqty(resultType.getLength() > 0 ? Math.min(resultType.getLength(), options.getTextDefaultColQty()) : options.getTextDefaultColQty());
                        xFormText.alignment = options.getTextDefaultAlignment();
                        xFormText.editable = isEditable;
                    }
                    text.setReference(referenceId);
                    inputObject = text;
                    break;
                }
                case 7: {
                    XFormInterval intfld = new XFormInterval();
                    intfld.reference = referenceId;
                    intfld.id = arrayName + "interval" + intervalCount++;
                    intfld.editable = isEditable;
                    inputObject = intfld;
                    break;
                }
                case 6: {
                    XFormDatetimepiker picker = new XFormDatetimepiker();
                    picker.reference = referenceId;
                    picker.id = arrayName + "datepicker" + timePicker++;
                    picker.editable = isEditable;
                    inputObject = picker;
                    break;
                }
                case 8: {
                    if (inArray) break;
                    XFormImage image = new XFormImage();
                    image.reference = referenceId;
                    image.id = arrayName + "image" + imageCount++;
                    image.editable = isEditable;
                    inputObject = image;
                    break;
                }
                case 17: {
                    XFormCombo combo = new XFormCombo();
                    combo.id = arrayName + "combo" + comboCount++;
                    options.apply(combo);
                    combo.setReference(referenceId);
                    inputObject = combo;
                }
            }
        }
        if (attribute.isPrimaryKey() && inputObject != null) {
            inputObject.setPresentationRequired(true);
        }
        return inputObject;
    }

    public static XFormRepeatablesection createTopLevelArray(String groupName, String[] groupAttrs, ObjectTypeDescription groupType) {
        return XFormPresentationModelHelper.createArray(groupAttrs, "", groupName, groupType, PresentationGenerationOptions.load());
    }

    public static XFormUserInputPresentationXMLObject createTopLevelInputForAttribute(AttributeTypeDescription attribute) {
        return XFormPresentationModelHelper.createInputForAttribute(attribute, null, attribute.getName(), PresentationGenerationOptions.load());
    }

    public static XFormTable createTopLevelTableForAttribute(AttributeTypeDescription attribute, String[] includedUngroupedAttributes) {
        return XFormPresentationModelHelper.generateDefaultTable(attribute.getName() + ".", (XObjectTypeDescription)attribute.getType(), PresentationGenerationOptions.load(), includedUngroupedAttributes, null, null, null, false, TABLE_WIDTH_FULL);
    }

    public static XFormPresentationModel generateDefaultPresentation(XObjectTypeDescription datamodel, String name) {
        return XFormPresentationModelHelper.generateDefaultPresentation(datamodel, name, PresentationGenerationOptions.load());
    }

    public static XFormPresentationModel generateDefaultPresentation(XObjectTypeDescription datamodel, String name, PresentationGenerationOptions options) {
        return XFormPresentationModelHelper.generateDefaultPresentation(datamodel, name, options, null, null, null, null);
    }

    public static XFormPresentationModel generateDefaultPresentation(XObjectTypeDescription datamodel, String name, PresentationGenerationOptions options, Map attributesmap) {
        XFormPresentationModelHelper.initComponentCounts();
        XFormTable table = XFormPresentationModelHelper.generateDefaultTable("", datamodel, options, attributesmap, options.useDefaultLayout(), TABLE_WIDTH_FULL);
        return XFormPresentationModelHelper.generatePresentation(name, options, datamodel, table);
    }

    public static XFormPresentationModel generateDefaultPresentation(XObjectTypeDescription datamodel, String name, PresentationGenerationOptions options, String[] includedUngroupedAttributes, String[] includedGroups, Hashtable includedGroupedAttributes, Hashtable includedInnerXOSAttributes) {
        XFormPresentationModelHelper.initComponentCounts();
        XFormTable table = XFormPresentationModelHelper.generateDefaultTable("", datamodel, options, includedUngroupedAttributes, includedGroups, includedGroupedAttributes, includedInnerXOSAttributes, options.useDefaultLayout(), TABLE_WIDTH_FULL);
        return XFormPresentationModelHelper.generatePresentation(name, options, datamodel, table);
    }

    public static XFormTable generateDefaultTable(String preString, XObjectTypeDescription datamodel, PresentationGenerationOptions options, String[] includedUngroupedAttributes, String[] includedGroups, Hashtable includedGroupedAttributes, Hashtable includedInnerXOSAttributes, boolean withButtons, String width) {
        int i;
        String[] groupNames;
        String[] names = includedUngroupedAttributes == null ? datamodel.getAllAttributesName(false) : includedUngroupedAttributes;
        String[] stringArray = groupNames = includedGroups == null ? datamodel.getAllGroupNames() : includedGroups;
        if (groupNames == null) {
            groupNames = new String[]{};
        }
        if (names == null) {
            names = new String[]{};
        }
        int compCount = names.length + groupNames.length;
        int buttonRows = 1;
        if (!withButtons || options.getButtonPanelLayout() == null || options.getButtonPanelLayout().length == 0) {
            buttonRows = 0;
        }
        if (withButtons && options.getButtonPanelLayout().length > 2) {
            ++buttonRows;
        }
        XFormTable table = new XFormTable(compCount + buttonRows, 2);
        table.id = "table" + tableCount++;
        table.width = width;
        options.apply(table);
        int row = compCount;
        int column = 0;
        if (withButtons) {
            for (i = 0; i < options.getButtonPanelLayout().length; ++i) {
                XFormButton currentButton;
                if (column >= table.row[row].cell.length) {
                    ++row;
                    column = 0;
                }
                options.apply(table.row[row].cell[column]);
                table.row[row].cell[column].button = currentButton = new XFormButton();
                currentButton.id = currentButton.action = XFormButton.possibleAction_d[options.getButtonPanelLayout()[i]];
                options.apply(currentButton);
                ++column;
            }
        }
        for (i = 0; i < names.length; ++i) {
            String name = names[i];
            XFormLabel label = new XFormLabel(XFormPresentationModelHelper.process(name, options));
            label.id = "label" + labelCount++;
            options.apply(label);
            table.row[i].cell[0].label = label;
            options.apply(table.row[i].cell[0]);
            table.row[i].cell[0].label.setFontsize(10);
            table.row[i].cell[0].label.setFontStyle(FontStyle.BOLD);
            AttributeTypeDescription desc = datamodel.findAttribute(name);
            if (includedInnerXOSAttributes != null && includedInnerXOSAttributes.get(names[i]) != null) {
                List list = (List)includedInnerXOSAttributes.get(names[i]);
                String[] ungrouped = (String[])list.get(0);
                String[] groups = (String[])list.get(1);
                Hashtable grouped = (Hashtable)list.get(2);
                Hashtable innerXos = (Hashtable)list.get(3);
                table.row[i].cell[1].table = XFormPresentationModelHelper.generateDefaultTable(preString + names[i] + ".", (XObjectTypeDescription)desc.getResultType(), options, ungrouped, groups, grouped, innerXos, false, TABLE_WIDTH_FULL);
                continue;
            }
            XFormPresentationModelHelper.initCell(table.row[i].cell[1], desc, preString + names[i], options);
        }
        for (i = 0; i < groupNames.length; ++i) {
            String[] attName;
            XFormLabel label = new XFormLabel(XFormPresentationModelHelper.process(groupNames[i], options));
            label.id = "label" + labelCount++;
            options.apply(label);
            table.row[i + names.length].cell[0].label = label;
            options.apply(table.row[i + names.length].cell[0]);
            String[] stringArray2 = attName = includedGroupedAttributes == null ? datamodel.getAllGroupedAttributeNames(groupNames[i]) : (String[])includedGroupedAttributes.get(groupNames[i]);
            if (attName == null) continue;
            XFormPresentationModelHelper.generateDefaultArray(table.row[i + names.length].cell[1], preString, groupNames[i], attName, (ObjectTypeDescription)datamodel, options);
        }
        return table;
    }

    public static void fixIds(XFormPresentationModel model) {
        if (model.getPresentation() == null || model.getPresentation().table == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<XFormPresentationXMLObject> componentList = new ArrayList<XFormPresentationXMLObject>();
        XFormTable topTable = model.getPresentation().table;
        XFormPresentationModelHelper.fixIds(topTable, idList, componentList);
        for (XFormPresentationXMLObject xFormPresentationXMLObject : componentList) {
            String id;
            String idPart = xFormPresentationXMLObject.getName();
            int idNumber = 0;
            do {
                id = idPart + idNumber;
                ++idNumber;
            } while (idList.contains(id));
            xFormPresentationXMLObject.setId(id);
            idList.add(id);
        }
    }

    public static boolean isTopLevelLayout(XFormPresentationXMLObject layout) {
        return layout != null && layout.getParent() != null && layout.getParent() instanceof XFormPresentation;
    }

    private static XFormRepeatablesection createArray(String[] groupAttrs, String preString, String groupName, ObjectTypeDescription innerGroup, PresentationGenerationOptions options) {
        XFormRepeatablesection array = new XFormRepeatablesection();
        array.expand(groupAttrs.length);
        array.id = "array" + arrayCount++;
        array.reference = preString + groupName;
        options.apply(array);
        for (int g = 0; g < groupAttrs.length; ++g) {
            String columnHeader;
            MethodTypeDescription desc;
            String gAtt = groupAttrs[g];
            int pointPos = gAtt.indexOf(".");
            if (pointPos > 0) {
                String inner = gAtt.substring(0, pointPos);
                MethodTypeDescription innerAttr = innerGroup.findMember(inner);
                if (innerAttr == null || innerAttr.getResultType() == null || !innerAttr.getResultType().isBpmObject()) continue;
                String innerAttName = gAtt.substring(pointPos + 1);
                ObjectTypeDescription innerObject = (ObjectTypeDescription)innerAttr.getResultType();
                desc = innerObject.findMember(innerAttName);
                columnHeader = XFormPresentationModelHelper.process(innerAttName, options);
            } else {
                desc = innerGroup.findMember(gAtt);
                columnHeader = XFormPresentationModelHelper.process(gAtt, options);
            }
            array.headers[g] = columnHeader;
            array.headerswidth[g] = -1;
            XFormPresentationModelHelper.initCell(array.row.cell[g], desc, preString + groupName + "[]." + gAtt, groupName, options);
        }
        return array;
    }

    private static XFormRepeatable createArray(LinkedHashMap attributesmap, String preString, String groupName, ObjectTypeDescription innerGroup, PresentationGenerationOptions options) {
        if (attributesmap == null) {
            attributesmap = new LinkedHashMap();
        }
        boolean useSection = false;
        Object[] keys = attributesmap.keySet().toArray();
        for (int g = 0; g < keys.length; ++g) {
            String referencedKey = (String)keys[g];
            if (referencedKey.indexOf("[") <= 0) continue;
            useSection = true;
            break;
        }
        attributesmap = XFormPresentationModelHelper.expandCompositeTypes(attributesmap);
        int attributeCount = attributesmap.size();
        XFormRepeatable repeatable = useSection ? new XFormRepeatablesection() : new XFormArray();
        repeatable.expand(attributeCount);
        repeatable.id = "array" + arrayCount++;
        repeatable.reference = preString + groupName;
        options.apply(repeatable);
        Object[] keys2 = attributesmap.keySet().toArray();
        for (int g = 0; g < keys2.length; ++g) {
            String columnHeader;
            int pointPos;
            String gAtt = (String)keys2[g];
            LinkedHashMap content = (LinkedHashMap)attributesmap.get(gAtt);
            int groupIndex = gAtt.indexOf("[");
            boolean isGroup = groupIndex > 0;
            ObjectTypeDescription objectOwningTheAttribute = innerGroup;
            String attributeName = gAtt;
            while ((pointPos = attributeName.indexOf(".")) > 0) {
                String inner = attributeName.substring(0, pointPos);
                assert (objectOwningTheAttribute != null) : "objectOwningTheAttribute cannot be null";
                MethodTypeDescription innerAttr = objectOwningTheAttribute.findMember(inner);
                if (innerAttr != null && innerAttr.getResultType() != null && innerAttr.getResultType().isObject()) {
                    attributeName = attributeName.substring(pointPos + 1);
                    objectOwningTheAttribute = (ObjectTypeDescription)innerAttr.getResultType();
                    continue;
                }
                Log.logWarning(new Exception("could not find path " + gAtt));
                break;
            }
            if (objectOwningTheAttribute == null) continue;
            MethodTypeDescription desc = isGroup ? objectOwningTheAttribute.findMember(attributeName.substring(0, attributeName.indexOf("["))) : objectOwningTheAttribute.findMember(attributeName);
            repeatable.headers[g] = columnHeader = XFormPresentationModelHelper.process(gAtt, options);
            repeatable.headerswidth[g] = -1;
            if (!isGroup) {
                if (content != null) {
                    repeatable.row.cell[g].table = XFormPresentationModelHelper.generateDefaultTable(preString + preString + groupName + "[]." + gAtt + ".", (ObjectTypeDescription)desc.getResultType(), options, content, false, TABLE_WIDTH_FULL);
                    continue;
                }
                XFormPresentationModelHelper.initCell(repeatable.row.cell[g], desc, preString + groupName + "[]." + gAtt, groupName, options);
                continue;
            }
            String attributePart = gAtt.substring(0, gAtt.indexOf(attributeName));
            XFormPresentationModelHelper.generateDefaultArray(repeatable.row.cell[g], preString + groupName + "[]." + attributePart, attributeName.substring(0, attributeName.indexOf("[")), content, objectOwningTheAttribute, options);
        }
        return repeatable;
    }

    private static LinkedHashMap expandCompositeTypes(Map attributesmap) {
        Iterator it = attributesmap.entrySet().iterator();
        LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>();
        while (it.hasNext()) {
            Map.Entry att = it.next();
            String key = (String)att.getKey();
            Map value = (Map)att.getValue();
            if (value != null) {
                if (key.endsWith("[]")) {
                    result.put(key, value);
                    continue;
                }
                value = XFormPresentationModelHelper.expandCompositeTypes(value);
                for (Map.Entry innerEntry : value.entrySet()) {
                    String innatt = (String)innerEntry.getKey();
                    result.put(key + "." + innatt, (Map)innerEntry.getValue());
                }
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private static void generateDefaultArray(XFormCell cell, String preString, String groupName, LinkedHashMap innerattrs, ObjectTypeDescription model, PresentationGenerationOptions options) {
        AttributeTypeDescription group = model.findAttribute(groupName);
        ObjectTypeDescription innerGroup = (ObjectTypeDescription)group.getResultType().getElementType();
        XFormRepeatable repeatable = XFormPresentationModelHelper.createArray(innerattrs, preString, groupName, innerGroup, options);
        if (repeatable instanceof XFormRepeatablesection) {
            cell.repeatablesection = (XFormRepeatablesection)repeatable;
        } else {
            cell.array = (XFormArray)repeatable;
        }
    }

    private static void generateDefaultArray(XFormCell cell, String preString, String groupName, String[] groupAttrs, ObjectTypeDescription model, PresentationGenerationOptions options) {
        AttributeTypeDescription group = model.findAttribute(groupName);
        ObjectTypeDescription innerGroup = (ObjectTypeDescription)group.getResultType().getElementType();
        cell.repeatablesection = XFormPresentationModelHelper.createArray(groupAttrs, preString, groupName, innerGroup, options);
    }

    private static XFormTable generateDefaultTable(String preString, ObjectTypeDescription datamodel, PresentationGenerationOptions options, Map attributesmap, boolean withButtons, String width) {
        int compCount = attributesmap.size();
        int buttonRows = 1;
        if (!withButtons || options.getButtonPanelLayout() == null || options.getButtonPanelLayout().length == 0) {
            buttonRows = 0;
        }
        if (withButtons && options.getButtonPanelLayout().length > 2) {
            ++buttonRows;
        }
        XFormTable table = new XFormTable(Math.max(compCount + buttonRows, 1), 2);
        table.id = "table" + tableCount++;
        table.width = width;
        options.apply(table);
        int row = compCount;
        int column = 0;
        if (withButtons) {
            for (int i = 0; i < options.getButtonPanelLayout().length; ++i) {
                XFormButton currentButton;
                if (column >= table.row[row].cell.length) {
                    ++row;
                    column = 0;
                }
                options.apply(table.row[row].cell[column]);
                table.row[row].cell[column].button = currentButton = new XFormButton();
                currentButton.id = currentButton.action = XFormButton.possibleAction_d[options.getButtonPanelLayout()[i]];
                options.apply(currentButton);
                ++column;
            }
        }
        Iterator atts = attributesmap.entrySet().iterator();
        int i = 0;
        while (atts.hasNext()) {
            Map.Entry att = atts.next();
            String name = (String)att.getKey();
            int groupPos = name.indexOf("[]");
            if (groupPos != -1) {
                name = name.substring(0, groupPos);
            }
            XFormLabel label = new XFormLabel(XFormPresentationModelHelper.process(name, options));
            label.id = "label" + labelCount++;
            options.apply(label);
            table.row[i].cell[0].label = label;
            table.row[i].cell[0].label.setFontsize(10);
            table.row[i].cell[0].label.setFontStyle(FontStyle.BOLD);
            options.apply(table.row[i].cell[0]);
            AttributeTypeDescription desc = datamodel.findAttribute(name);
            if (desc == null) {
                System.out.println("Invalid attribut name = " + name);
                continue;
            }
            if (att.getValue() != null) {
                LinkedHashMap innerattrs = (LinkedHashMap)att.getValue();
                if (groupPos != -1) {
                    XFormPresentationModelHelper.generateDefaultArray(table.row[i].cell[1], preString, name, innerattrs, datamodel, options);
                } else {
                    table.row[i].cell[1].table = XFormPresentationModelHelper.generateDefaultTable(preString + name + ".", (ObjectTypeDescription)desc.getResultType(), options, innerattrs, false, TABLE_WIDTH_FULL);
                }
            } else {
                XFormPresentationModelHelper.initCell(table.row[i].cell[1], desc, preString + name, options);
            }
            ++i;
        }
        return table;
    }

    private static XFormPresentationModel generatePresentation(String name, PresentationGenerationOptions options, XObjectTypeDescription datamodel, XFormTable table) {
        XFormPresentationModel model = new XFormPresentationModel(datamodel, name);
        if (options.getPresentationBackGround() != null) {
            model.presentation_d.bgcolor = options.getPresentationBackGround();
            model.presentation_d.background = new XFormBackground();
        }
        if (options.useDefaultLayout()) {
            model.getPresentation().table = table;
        } else {
            XFormTable t = new XFormTable();
            t.id = "table" + tableCount++;
            options.apply(t);
            model.getPresentation().table = t;
            t.expand(3, 1);
            options.apply(t.row[0].cell[0]);
            t.row[0].cell[0].setCssClass("fo_title_cell");
            t.row[0].cell[0].setAlignment("left");
            XFormLabel title = new XFormLabel(XFormPresentationModelHelper.process(name, options));
            title.id = "label" + labelCount++;
            options.apply(title);
            title.setFontsize(26);
            title.setFontStyle(FontStyle.BOLD);
            title.setFgcolor("#000000");
            title.setCssClass("fo_title_label");
            t.row[0].cell[0].label = title;
            options.apply(t.row[1].cell[0]);
            t.row[1].cell[0].table = table;
            t.row[1].cell[0].setBgcolor("#FFFFFF");
            t.row[1].cell[0].setCssClass("fo_main_cell");
            t.row[1].cell[0].setTopborderstyle(BorderStyle.SOLID);
            t.row[1].cell[0].setTopColor("#D0D2D4");
            t.row[1].cell[0].setTopWidth(2);
            t.row[1].cell[0].setBottomborderstyle(BorderStyle.SOLID);
            t.row[1].cell[0].setBottomColor("#D0D2D4");
            t.row[1].cell[0].setBottomWidth(2);
            XFormTable buttonTable = new XFormTable();
            buttonTable.id = "table" + tableCount++;
            buttonTable.width = TABLE_WIDTH_FULL;
            options.apply(buttonTable);
            options.apply(t.row[2].cell[0]);
            t.row[2].cell[0].table = buttonTable;
            t.row[2].cell[0].alignment = "center";
            t.row[2].cell[0].setBgcolor("#FFFFFF");
            t.row[2].cell[0].setCssClass("fo_footer_cell");
            buttonTable.expand(1, options.getButtonPanelLayout().length);
            for (int i = 0; i < options.getButtonPanelLayout().length; ++i) {
                XFormButton currentButton;
                options.apply(buttonTable.row[0].cell[i]);
                buttonTable.row[0].cell[i].alignment = "center";
                buttonTable.row[0].cell[i].button = currentButton = new XFormButton();
                currentButton.id = currentButton.action = XFormButton.possibleAction_d[options.getButtonPanelLayout()[i]];
                currentButton.setFontStyle(FontStyle.BOLD);
                currentButton.setFontsize(10);
                options.apply(currentButton);
            }
        }
        return model;
    }

    private static void initCell(XFormCell cell, MethodTypeDescription desc, String name, PresentationGenerationOptions options) {
        XFormPresentationModelHelper.initCell(cell, desc, name, null, options);
    }

    private static void initCell(XFormCell cell, MethodTypeDescription desc, String name, String arrayName, PresentationGenerationOptions options) {
        options.apply(cell);
        XFormUserInputPresentationXMLObject result = XFormPresentationModelHelper.createInputForAttribute(desc.asAttribute(), arrayName, name, options);
        if (result != null) {
            switch (result.getComponentID()) {
                case 5: {
                    cell.image = (XFormImage)result;
                    break;
                }
                case 0: {
                    cell.combo = (XFormCombo)result;
                    break;
                }
                case 1: {
                    cell.check = (XFormCheck)result;
                    break;
                }
                case 4: {
                    cell.datetimepiker = (XFormDatetimepiker)result;
                    break;
                }
                case 6: {
                    cell.interval = (XFormInterval)result;
                    break;
                }
                case 8: {
                    if (options.getTextCellDefaultAlignment() != null) {
                        cell.alignment = options.getTextCellDefaultAlignment();
                    }
                    cell.multilinetext = (XFormMultilinetext)result;
                    break;
                }
                case 12: {
                    if (options.getTextCellDefaultAlignment() != null) {
                        cell.alignment = options.getTextCellDefaultAlignment();
                    }
                    cell.text = (XFormText)result;
                }
            }
        }
    }

    private static void initComponentCounts() {
        checkCount = 0;
        timePicker = 0;
        intervalCount = 0;
        imageCount = 0;
        textCount = 0;
        multilinetextCount = 0;
        comboCount = 0;
        labelCount = 0;
        arrayCount = 0;
        tableCount = 0;
    }

    private static String process(String n, PresentationGenerationOptions options) {
        String result = null;
        if (options.doLabelShiftFirstLetter()) {
            n = XFormPresentationModelHelper.shiftFirst(n);
        }
        if (options.doLabelSeparateUnderscoresAndCaps()) {
            StringTokenizer st = new StringTokenizer(n);
            while (st.hasMoreTokens()) {
                st.nextToken();
                StringTokenizer st2 = new StringTokenizer(n, "_");
                while (st2.hasMoreTokens()) {
                    String eachWord = st2.nextToken();
                    if (options.doLabelShiftSeparatedWords()) {
                        eachWord = XFormPresentationModelHelper.shiftFirst(eachWord);
                    }
                    if (result == null) {
                        result = eachWord;
                        continue;
                    }
                    result = result + " " + eachWord;
                }
            }
        }
        return result;
    }

    private static String shiftFirst(String n) {
        if (n.length() < 2) {
            return n.toUpperCase();
        }
        return ("" + n.charAt(0)).toUpperCase() + (n.length() > 1 ? n.substring(1) : "");
    }

    private static void fixIds(XFormXMLObject object, List<String> ids, List<XFormPresentationXMLObject> componentsWithoutIds) {
        if (object instanceof XFormPresentationXMLObject) {
            XFormPresentationXMLObject pObject = (XFormPresentationXMLObject)object;
            String id = pObject.getId();
            if (id == null) {
                componentsWithoutIds.add(pObject);
            } else {
                ids.add(id);
            }
        }
        for (int i = 0; i < object.getChildCount(); ++i) {
            XFormPresentationModelHelper.fixIds(object.getChildAt(i), ids, componentsWithoutIds);
        }
    }
}

