/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.presentationmodel.XFormCheck;
import oracle.bpm.xobject.presentationmodel.XFormCombo;
import oracle.bpm.xobject.presentationmodel.XFormDatetimepiker;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.presentationmodel.XFormIframe;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormInterval;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormMultilinetext;
import oracle.bpm.xobject.presentationmodel.XFormPie;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRadio;
import oracle.bpm.xobject.presentationmodel.XFormRepeatablesection;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormText;

public enum XFormComponentType {
    TEXT(12){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormText();
        }
    }
    ,
    MULTILINE(8){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormMultilinetext();
        }
    }
    ,
    PASSWORD(12){

        @Override
        public XFormPresentationXMLObject createInstance() {
            XFormText result = new XFormText();
            result.setPasswordField(true);
            return result;
        }
    }
    ,
    DATETIMEPIKER(4){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormDatetimepiker();
        }
    }
    ,
    INTERVAL(6){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormInterval();
        }
    }
    ,
    LINK(22){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormLink();
        }
    }
    ,
    LABEL(7){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormLabel();
        }
    }
    ,
    IMAGE(5){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormImage();
        }
    }
    ,
    IFRAME(23){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormIframe();
        }
    }
    ,
    ARRAY(15, false){

        @Override
        public XFormPresentationXMLObject createInstance() {
            XFormArray result = new XFormArray();
            result.expand(2);
            return result;
        }
    }
    ,
    PRESENTATION(17, false),
    REPEATABLESECTION(18, false){

        @Override
        public XFormPresentationXMLObject createInstance() {
            XFormRepeatablesection result = new XFormRepeatablesection();
            result.expand(2);
            return result;
        }
    }
    ,
    TABLE(11){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormTable();
        }
    }
    ,
    CELL(3){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormCell();
        }
    }
    ,
    ROW(10){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormRow();
        }
    }
    ,
    ACTION_BUTTON(2){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return XFormComponentType.createButton(4);
        }
    }
    ,
    SUBMIT_BUTTON(2){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return XFormComponentType.createButton(0);
        }
    }
    ,
    REFRESH_BUTTON(2){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return XFormComponentType.createButton(3);
        }
    }
    ,
    RESET_BUTTON(2){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return XFormComponentType.createButton(2);
        }
    }
    ,
    CANCEL_BUTTON(2){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return XFormComponentType.createButton(1);
        }
    }
    ,
    SAVE_BUTTON(2){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return XFormComponentType.createButton(5);
        }
    }
    ,
    PRINT_BUTTON(2){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return XFormComponentType.createButton(6);
        }
    }
    ,
    COMBO(0){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormCombo();
        }
    }
    ,
    CHECK(1){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormCheck();
        }
    }
    ,
    RADIO(9){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormRadio();
        }
    }
    ,
    PIE(20, false){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormPie();
        }
    }
    ,
    CHART(21, false){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormChart();
        }
    }
    ,
    GAUGE(19, false){

        @Override
        public XFormPresentationXMLObject createInstance() {
            return new XFormGauge();
        }
    };

    private int theType;
    private boolean canBeAddedToGroup;

    private static XFormPresentationXMLObject createButton(int action) {
        XFormButton result = new XFormButton(action);
        result.display = result.getAction();
        return result;
    }

    public XFormPresentationXMLObject createInstance() {
        throw new UnsupportedOperationException("can not create an instance of " + (Object)((Object)this));
    }

    private XFormComponentType(int theType) {
        this(theType, true);
    }

    private XFormComponentType(int theType, boolean canBeAddedToGroup) {
        this.theType = theType;
        this.canBeAddedToGroup = canBeAddedToGroup;
    }

    public int getType() {
        return this.theType;
    }

    public static XFormComponentType getValueOf(String st) {
        if (st != null) {
            st = st.toUpperCase();
        }
        XFormComponentType result = "TEXT_FIELD".equals(st) ? TEXT : ("TEXT_AREA".equals(st) ? MULTILINE : ("MULTILINETEXT".equals(st) ? MULTILINE : ("INNER_FRAME".equals(st) ? IFRAME : ("BUTTON".equals(st) ? ACTION_BUTTON : XFormComponentType.valueOf(st)))));
        return result;
    }

    public boolean canBeAddedToGroup() {
        return this.canBeAddedToGroup;
    }
}

