/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import java.util.StringTokenizer;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;

public class EasyFullBorderPropertiesSetter {
    private static final String DEFAULT = "DEFAULT";

    public static void setBorderColor(FullBorderProperties component, String color) {
        component.setBottomColor(color);
        component.setLeftColor(color);
        component.setRightColor(color);
        component.setTopColor(color);
    }

    public static void setBorderWidth(FullBorderProperties component, int width) {
        component.setBottomWidth(width);
        component.setLeftWidth(width);
        component.setRightWidth(width);
        component.setTopWidth(width);
    }

    public static void setBottomborderstyle(FullBorderProperties component, BorderStyle style) {
        component.setBottomborderstyle(style);
        component.setLeftborderstyle(style);
        component.setRightborderstyle(style);
        component.setTopborderstyle(style);
    }

    public static void setDefaultBorder(FullBorderProperties component) {
        EasyFullBorderPropertiesSetter.setBottomborderstyle(component, BorderStyle.SOLID);
        EasyFullBorderPropertiesSetter.setBorderWidth(component, 1);
        EasyFullBorderPropertiesSetter.setBorderColor(component, "#D0D2D4");
    }

    public static void setMigratedDefaultBorder(FullBorderProperties component) {
        EasyFullBorderPropertiesSetter.setBottomborderstyle(component, BorderStyle.GROOVE);
        EasyFullBorderPropertiesSetter.setBorderWidth(component, 3);
        EasyFullBorderPropertiesSetter.setBorderColor(component, "#FFFFFF");
    }

    public static SimpleBorderProperties getTopBorderAsSimple(final FullBorderProperties properties) {
        return new SimpleBorderProperties(){

            @Override
            public void setBordercolor(String borderColor) {
                properties.setTopColor(borderColor);
            }

            @Override
            public String getBordercolor() {
                return properties.getTopColor();
            }

            @Override
            public void setBorderstyle(BorderStyle borderStyle) {
                properties.setTopborderstyle(borderStyle);
            }

            @Override
            public BorderStyle getBorderstyle() {
                return properties.getTopStyle();
            }

            @Override
            public void setBorderwidth(int borderWidth) {
                properties.setTopWidth(borderWidth);
            }

            @Override
            public int getBorderwidth() {
                return properties.getTopWidth();
            }

            @Override
            public boolean isBorderActive() {
                return properties.isBorderActive();
            }
        };
    }

    public static SimpleBorderProperties getBottomBorderAsSimple(final FullBorderProperties properties) {
        return new SimpleBorderProperties(){

            @Override
            public void setBordercolor(String borderColor) {
                properties.setBottomColor(borderColor);
            }

            @Override
            public String getBordercolor() {
                return properties.getBottomColor();
            }

            @Override
            public void setBorderstyle(BorderStyle borderStyle) {
                properties.setBottomborderstyle(borderStyle);
            }

            @Override
            public BorderStyle getBorderstyle() {
                return properties.getBottomStyle();
            }

            @Override
            public void setBorderwidth(int borderWidth) {
                properties.setBottomWidth(borderWidth);
            }

            @Override
            public int getBorderwidth() {
                return properties.getBottomWidth();
            }

            @Override
            public boolean isBorderActive() {
                return properties.isBorderActive();
            }
        };
    }

    public static SimpleBorderProperties getLeftBorderAsSimple(final FullBorderProperties properties) {
        return new SimpleBorderProperties(){

            @Override
            public void setBordercolor(String borderColor) {
                properties.setLeftColor(borderColor);
            }

            @Override
            public String getBordercolor() {
                return properties.getLeftColor();
            }

            @Override
            public void setBorderstyle(BorderStyle borderStyle) {
                properties.setLeftborderstyle(borderStyle);
            }

            @Override
            public BorderStyle getBorderstyle() {
                return properties.getLeftStyle();
            }

            @Override
            public void setBorderwidth(int borderWidth) {
                properties.setLeftWidth(borderWidth);
            }

            @Override
            public int getBorderwidth() {
                return properties.getLeftWidth();
            }

            @Override
            public boolean isBorderActive() {
                return properties.isBorderActive();
            }
        };
    }

    public static SimpleBorderProperties getRightBorderAsSimple(final FullBorderProperties properties) {
        return new SimpleBorderProperties(){

            @Override
            public void setBordercolor(String borderColor) {
                properties.setRightColor(borderColor);
            }

            @Override
            public String getBordercolor() {
                return properties.getRightColor();
            }

            @Override
            public void setBorderstyle(BorderStyle borderStyle) {
                properties.setRightborderstyle(borderStyle);
            }

            @Override
            public BorderStyle getBorderstyle() {
                return properties.getRightStyle();
            }

            @Override
            public void setBorderwidth(int borderWidth) {
                properties.setRightWidth(borderWidth);
            }

            @Override
            public int getBorderwidth() {
                return properties.getRightWidth();
            }

            @Override
            public boolean isBorderActive() {
                return properties.isBorderActive();
            }
        };
    }

    public static void setPropertiesFromCSV(SimpleBorderProperties simpleBorderProperties, String value) {
        StringTokenizer t = new StringTokenizer(value, ",");
        String style = t.nextToken();
        String width = t.nextToken();
        String color = t.nextToken();
        simpleBorderProperties.setBorderstyle(DEFAULT.equals(style) ? null : BorderStyle.valueOf(style));
        simpleBorderProperties.setBorderwidth(Integer.valueOf(width));
        simpleBorderProperties.setBordercolor(color);
    }

    public static String getPropertiesAsCSV(SimpleBorderProperties simpleBorderProperties) {
        BorderStyle style = simpleBorderProperties.getBorderstyle();
        String result = (style == null ? DEFAULT : style.toString()) + ",";
        result = result + simpleBorderProperties.getBorderwidth() + ",";
        result = result + simpleBorderProperties.getBordercolor();
        return result;
    }
}

