/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bpmobject.BpmObjectFactory;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import oracle.bpm.xobject.FuegoObjectConstants;

public class XObjectFactory {
    public static void setXOPresentable(XObjectTypeDescription xo, boolean p) {
        xo.setPresentable(p);
        if (xo.isPresentable()) {
            XObjectFactory.setPresentableDelegate(xo);
        } else {
            XObjectFactory.setFODelegate(xo);
        }
    }

    public static ObjectTypeDescription addGroupElement(ObjectTypeDescription otd, String name) {
        ComponentCatalog catalog = otd.getCatalog();
        assert (catalog != null);
        ObjectTypeDescription result = XObjectFactory.createGroupElement(name, catalog);
        otd.addInnerType(result);
        return result;
    }

    public static ObjectTypeDescription createGroupElement(String name, ComponentCatalog catalog) {
        XObjectTypeDescription result = new XObjectTypeDescription(Identifier.classname(name));
        result.setModifiers(0L);
        XObjectTypeDescription.addConstructors(result);
        result.setCatalog(catalog);
        XObjectFactory.setGroupDelegate(result);
        result.setModifiers(result.getModifiers() | 0x1000L);
        BpmObjectFactory.setProperties(result);
        return result;
    }

    public static AttributeTypeDescription addCurrentRowAttribute(ObjectTypeDescription object, String parentFOName) {
        AttributeTypeDescription currentRow = XObjectFactory.createCurrentRow(object, parentFOName);
        object.addMember(currentRow);
        return currentRow;
    }

    public static AttributeTypeDescription createCurrentRow(ObjectTypeDescription object, String parentFOName) {
        AttributeTypeDescription currentRow = new AttributeTypeDescription("currentRow", TypeFactory.getPrimitiveInt(32));
        currentRow.setReadSignature(JavaClass.createGetAttrSignature("currentRow", TypeFactory.getPrimitiveInt(32).getJavaSignature()));
        currentRow.setWriteSignature(JavaClass.createSetAttrSignature("currentRow", TypeFactory.getPrimitiveInt(32).getJavaSignature()));
        String code = "// this code was autogenerated to provide compatibility with Fuego 4\nreturn " + parentFOName + '.' + Identifier.attribute(object.getName()) + ".indexOf(this)\n";
        SourceCode readAccess = SourceCode.create(code, "Fuego");
        currentRow.setCode(readAccess);
        return currentRow;
    }

    public static TransformTypeDescription createToString(ObjectTypeDescription objectType) {
        String transformName = "string";
        TypeDescription targetType = TypeFactory.getString();
        TransformTypeDescription transformType = new TransformTypeDescription(targetType);
        transformType.setName("string");
        String targetName = "result";
        transformType.setTargetName("result");
        String sourceName = Identifier.argument(objectType.getName());
        transformType.addSource(sourceName, objectType);
        TransformTypeDescription.FieldMapping mapping = new TransformTypeDescription.FieldMapping();
        mapping.setTargetField(transformType.getTargetName());
        mapping.setExpression(false);
        StringBuilder buffer = new StringBuilder();
        buffer.append("text as String\ntext = \"");
        buffer.append(objectType.getName());
        buffer.append("(\"\n\n// fields\n");
        boolean hasPrev = false;
        boolean hasPrimaryKey = objectType.hasPrimaryKey();
        int count = objectType.getMemberCount();
        for (int i = 0; i < count; ++i) {
            boolean mustInclude;
            MethodTypeDescription member = objectType.getMember(i);
            TypeDescription type = member.getResultType();
            if (!member.isAttribute()) continue;
            AttributeTypeDescription attribute = member.asAttribute();
            boolean bl = mustInclude = hasPrimaryKey && attribute.isPrimaryKey() || !hasPrimaryKey && type.isAtomic();
            if (!mustInclude) continue;
            buffer.append("text = text + \"");
            if (hasPrev) {
                buffer.append(", ");
            }
            buffer.append(member.getName());
            buffer.append(": \" + ");
            buffer.append("arg.").append(sourceName).append('.').append(member.getName());
            buffer.append('\n');
            hasPrev = true;
        }
        buffer.append("\ntext = text + \")\"\n");
        buffer.append("arg.result = text\n");
        mapping.setCode(SourceCode.create(buffer.toString(), "Fuego"));
        transformType.addFieldMapping(mapping);
        return transformType;
    }

    public static void setFODelegate(ObjectTypeDescription object) {
        XObjectFactory.setXODelegate(object, false);
    }

    public static void setGroupDelegate(ObjectTypeDescription object) {
        XObjectFactory.setXODelegate(object, true);
    }

    public static void setXODelegate(ObjectTypeDescription object, boolean isGroup) {
        TypeRef type;
        ComponentCatalog catalog = object.getCatalog();
        assert (catalog != null) : "Null catalog for " + object;
        TypeRef nonPresentableType = null;
        try {
            type = catalog.find(isGroup ? "Fuego.Internal.InnerFODelegate" : "Fuego.Internal.XODelegate");
            nonPresentableType = catalog.find("Fuego.Internal.FuegoObject");
        }
        catch (AmbiguousTypeNameException e) {
            type = e.getMalformedType();
        }
        assert (type != null) : "Could not load delegate";
        SuperType foDelegate = new SuperType(type, 0x2808000L);
        SuperType nonPresentable = new SuperType(nonPresentableType, 0x2008000L);
        List<SuperType> superTypes = XObjectFactory.getUserSuperTypes(object);
        object.removeAllSuperTypes();
        object.addSuperType(SuperType.getAny());
        object.addSuperType(nonPresentable);
        object.addSuperType(foDelegate);
        for (SuperType superType : superTypes) {
            object.addSuperType(superType);
        }
    }

    public static List<SuperType> getUserSuperTypes(ObjectTypeDescription objectType) {
        ArrayList<SuperType> superTypes = new ArrayList<SuperType>();
        for (SuperType superType : objectType.getSuperTypes()) {
            String qname = superType.getText();
            if (FuegoObjectConstants.isFuegoSuperType(qname)) continue;
            superTypes.add(superType);
        }
        return superTypes;
    }

    public static void setPresentableDelegate(ObjectTypeDescription object) {
        TypeRef type;
        assert (object.isBpmObject());
        ComponentCatalog catalog = object.getCatalog();
        assert (catalog != null) : "Null catalog for " + object;
        TypeRef presentableDelegateType = null;
        TypeRef presentableType = null;
        try {
            type = catalog.find("Fuego.Internal.XODelegate");
            presentableDelegateType = catalog.find("Fuego.Internal.PresentableDelegate");
            presentableType = catalog.find("Fuego.Lang.Presentable");
        }
        catch (AmbiguousTypeNameException e) {
            type = e.getMalformedType();
        }
        assert (type != null) : "Could not load : Fuego.Internal.XODelegate from " + catalog;
        SuperType XO_DELEGATE = new SuperType(type, 0x2808000L);
        SuperType presentableDelegate = new SuperType(presentableDelegateType, 0x2808000L);
        SuperType presentable = new SuperType(presentableType, 32768L);
        List<SuperType> superTypes = XObjectFactory.getUserSuperTypes(object);
        object.removeAllSuperTypes();
        object.addSuperType(SuperType.getAny());
        object.addSuperType(presentable);
        object.addSuperType(presentableDelegate);
        object.addSuperType(XO_DELEGATE);
        for (SuperType superType : superTypes) {
            object.addSuperType(superType);
        }
    }

    @Deprecated
    public static XObjectTypeDescription createXObjectTypeDescription(String name, boolean presentable, ComponentCatalog catalog) {
        XObjectTypeDescription result = new XObjectTypeDescription(Identifier.classname(name));
        BpmObjectFactory.setProperties(result);
        result.setCatalog(catalog);
        XObjectFactory.setXOPresentable(result, presentable);
        result.setModifiers(0L);
        return result;
    }
}

