/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.component.Replaceable;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Invocator;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.xobject.GroupArrayChangeListener;
import oracle.bpm.xobject.GroupElement;

public class GroupArray
extends ArrayList
implements Replaceable,
DynamicObject.Dynamizable,
ArrayUtils.Extendable {
    protected Invocator groupInvocator;
    private long __replacementId;
    private Object[] args;
    private transient GroupArrayChangeListener changeListener = null;
    private String constructorSignature;
    private List<Event> eventStack;
    private BitSet modified = new BitSet();
    private boolean saveEvents = false;
    private static final String SET_CURRENT_ELEMENT = "MsetCurrentRow(I)V";
    public static final long serialVersionUID = -2566310167139539478L;
    static final long serialCheck = 6053968004447147853L;

    public GroupArray(Invocator groupInvocator, String constructorSignature, Object[] args) {
        this();
        this.groupInvocator = groupInvocator;
        this.constructorSignature = constructorSignature;
        this.args = args;
    }

    private GroupArray() {
    }

    public void setGroupArrayChangeListener(GroupArrayChangeListener changeListener) {
        this.saveEvents = true;
        this.changeListener = changeListener;
        this.syncEvents();
    }

    public Object getParent() {
        return null;
    }

    public boolean isRowModified(int index) {
        return this.modified.get(index);
    }

    @Override
    public boolean add(Object o) {
        int index = this.size();
        this.setCurrentRow(index, o);
        boolean b = super.add(o);
        if (b) {
            this.fireAddEvent(index);
        }
        return b;
    }

    @Override
    public void add(int index, Object element) {
        super.add(index, element);
        this.setCurrentRowFrom(index);
        this.fireAddEvent(index);
    }

    @Override
    public boolean addAll(Collection c) {
        int sizeBeforeAdd = this.size();
        boolean add = super.addAll(c);
        this.setCurrentRowFrom(sizeBeforeAdd);
        if (add) {
            this.fireAddEvent(sizeBeforeAdd, c.size() - 1);
        }
        return add;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        boolean add = super.addAll(index, c);
        this.setCurrentRowFrom(index);
        if (add) {
            this.fireAddEvent(index, c.size() - 1);
        }
        return add;
    }

    @Override
    public void clear() {
        int endIndex = this.size();
        this.clearCurrentRow(0, endIndex);
        super.clear();
        this.fireRemoveEvent(0, endIndex - 1);
    }

    public Object createNewElement() throws Exception {
        if (this.groupInvocator == null) {
            throw new UnsupportedOperationException("Can not add a new element to this array");
        }
        return this.groupInvocator.newInstance(this.constructorSignature, this.args);
    }

    @Override
    public boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index != -1) {
            this.remove(index);
        }
        return index != -1;
    }

    @Override
    public Object remove(int index) {
        Object old = super.remove(index);
        this.setCurrentRow(-1, old);
        this.setCurrentRowFrom(index);
        this.fireRemoveEvent(index);
        this.modified.set(index, true);
        return old;
    }

    @Override
    public boolean removeAll(Collection c) {
        int oldIndex = 0;
        int currentIndex = 0;
        boolean modified = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            Object current = e.next();
            if (c.contains(current)) {
                this.setCurrentRow(-1, current);
                e.remove();
                modified = true;
                this.fireRemoveEvent(currentIndex);
            } else {
                this.setCurrentRow(currentIndex, current);
                ++currentIndex;
            }
            this.modified.set(oldIndex++, true);
        }
        return modified;
    }

    public void removeGroupArrayChangeListener() {
        this.changeListener = null;
    }

    public void resetModifiedRows() {
        this.modified.clear();
    }

    @Override
    public boolean retainAll(Collection c) {
        int oldIndex = 0;
        int currentIndex = 0;
        boolean modified = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            Object current = e.next();
            if (!c.contains(current)) {
                this.setCurrentRow(-1, current);
                e.remove();
                modified = true;
                this.fireRemoveEvent(currentIndex);
            } else {
                this.setCurrentRow(currentIndex, current);
                ++currentIndex;
            }
            this.modified.set(oldIndex++, true);
        }
        return modified;
    }

    @Override
    public Object set(int index, Object element) {
        this.setCurrentRow(index, element);
        Object o = super.set(index, element);
        this.modified.set(index, true);
        this.fireChangeEvent(index);
        this.setCurrentRow(-1, o);
        return o;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "@@" + super.toString();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.clearCurrentRow(fromIndex, toIndex);
        this.fireRemoveEvent(fromIndex, toIndex - 1);
    }

    protected DynamicObject writeDynamicObject(Map references) {
        DynamicObject dobj = (DynamicObject)references.get(this);
        if (dobj != null) {
            return dobj;
        }
        dobj = DynamicObject.create();
        DynamicObject list = DynamicObject.defaultValueOf(this, false, references);
        dobj.setJavaClassName(this.getClass().getName());
        dobj.setField("elements", list);
        dobj.setField("groupInvocator", DynamicObject.valueOf(this.groupInvocator, false, references));
        dobj.setField("modified", DynamicObject.valueOf(this.modified, false, references));
        dobj.setField("constructorSignature", this.constructorSignature);
        dobj.setField("args", DynamicObject.valueOf(this.args, false, references));
        dobj.setField("__replacementId", this.__replacementId);
        return dobj;
    }

    private static Object readDynamicObject(DynamicObject dobj, Class elemnentType, Map references) {
        Object result = references.get(dobj);
        if (result != null) {
            return result;
        }
        GroupArray array = null;
        DynamicObject groupInvocator = dobj.getField("groupInvocator");
        if (dobj.getPrevious() != null) {
            array = (GroupArray)dobj.getPrevious();
            references.put(dobj, array);
            List elements = dobj.getField("elements").convertTo(List.class, elemnentType, references);
            array.addAll((Collection)elements);
            DynamicObject replacementId = dobj.getField("__replacementId");
            if (replacementId != DynamicObject.NULL) {
                array.__replacementId = replacementId.longValue();
            }
        } else if (groupInvocator != DynamicObject.NULL) {
            array = new GroupArray();
            references.put(dobj, array);
            array.groupInvocator = groupInvocator.convertTo(Invocator.class, null, references);
            array.modified = dobj.getField("modified").convertTo(BitSet.class, null, references);
            array.constructorSignature = dobj.getField("constructorSignature").toString();
            array.args = dobj.getField("args").convertTo(Object[].class, null, references);
            array.__replacementId = dobj.getField("__replacementId").longValue();
            List elements = dobj.getField("elements").convertTo(List.class, elemnentType, references);
            array.addAll((Collection)elements);
        } else {
            throw new IllegalStateException("Could not deserialize group array from " + dobj);
        }
        return array;
    }

    private void setCurrentRow(int index, Object element) {
        Invokeable invokeable;
        if (element instanceof GroupElement) {
            GroupElement ge = (GroupElement)element;
            try {
                ge.setCurrentRow(index);
            }
            catch (Throwable e) {}
        } else if (element instanceof Invokeable && (invokeable = (Invokeable)element).isInstanceOf("java", "oracle.bpm.xobject.GroupElement")) {
            Integer indexValue = index;
            try {
                invokeable.invoke(SET_CURRENT_ELEMENT, indexValue);
            }
            catch (Exception e) {
                throw new RuntimeExceptionShell(e);
            }
        }
    }

    private void setCurrentRowFrom(int fromIndex) {
        for (int i = fromIndex; i < this.size(); ++i) {
            this.setCurrentRow(i, this.get(i));
        }
    }

    private void clearCurrentRow(int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            this.setCurrentRow(-1, this.get(i));
            this.modified.set(i, true);
        }
    }

    private void fireAddEvent(int index) {
        this.fireAddEvent(index, index);
    }

    private void fireAddEvent(int startIndex, int endIndex) {
        if (this.changeListener != null) {
            this.changeListener.intervalAdded(startIndex, endIndex);
        } else if (this.saveEvents) {
            this.saveEvent(1, startIndex, endIndex);
        }
    }

    private void fireChangeEvent(int index) {
        if (this.changeListener != null) {
            this.changeListener.contentsChanged(index);
        } else if (this.saveEvents) {
            this.saveEvent(0, index, index);
        }
    }

    private void fireRemoveEvent(int index) {
        this.fireRemoveEvent(index, index);
    }

    private void fireRemoveEvent(int startIndex, int endIndex) {
        if (this.changeListener != null) {
            this.changeListener.intervalRemoved(this, startIndex, endIndex);
        } else if (this.saveEvents) {
            this.saveEvent(2, startIndex, endIndex);
        }
    }

    private void saveEvent(int eventType, int startIndex, int endIndex) {
        if (this.eventStack == null) {
            this.eventStack = new LinkedList<Event>();
        }
        this.eventStack.add(new Event(eventType, startIndex, endIndex));
    }

    private boolean hasSaveEvents() {
        return this.eventStack != null && !this.eventStack.isEmpty();
    }

    private void syncEvents() {
        if (this.changeListener != null && this.hasSaveEvents()) {
            while (this.eventStack != null && !this.eventStack.isEmpty()) {
                Event event = this.eventStack.remove(0);
                switch (event.getType()) {
                    case 0: {
                        this.changeListener.contentsChanged(event.getStartIndex());
                        break;
                    }
                    case 1: {
                        this.changeListener.intervalAdded(event.getStartIndex(), event.getEndIndex());
                        break;
                    }
                    case 2: {
                        this.changeListener.intervalRemoved(this, event.getStartIndex(), event.getEndIndex());
                    }
                }
            }
            this.eventStack = null;
        }
    }

    private static final class Event
    implements Serializable {
        private final int endIndex;
        private final int startIndex;
        private final int type;
        static final long serialVersionUID = 1972099837591061991L;
        static final long serialCheck = 856157829551001062L;

        private Event(int type, int startIndex, int endIndex) {
            this.type = type;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public int getType() {
            return this.type;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

