/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

import java.util.Iterator;
import java.util.List;
import oracle.bpm.lang.Str;

@Deprecated
public class XMLOutput {
    private StringBuffer buffer_d;
    private boolean ignoreEmpty_d = true;
    private String pending_d = null;
    private String tabs_d = "";

    @Deprecated
    public XMLOutput() {
        this("");
    }

    public XMLOutput(String text) {
        this.buffer_d = new StringBuffer(text);
    }

    public void setIgnoreEmpty(boolean ignore) {
        this.ignoreEmpty_d = ignore;
    }

    public void close(String text) {
        if (this.pending_d != null && this.pending_d.endsWith("\n")) {
            this.pending_d = this.pending_d.substring(0, this.pending_d.length() - 1);
        }
        this.printPending();
        this.buffer_d.append(text + "\n");
    }

    public void closeTag(String text) {
        this.unindent();
        this.println("</" + text + ">");
    }

    public String escaped(String text) {
        return Str.toXMLString(text);
    }

    public void indent() {
        this.tabs_d = this.tabs_d + "\t";
    }

    public void openTag(String text) {
        this.println("<" + text + ">");
        this.indent();
    }

    public void print(String text) {
        this.printPending();
        this.pending_d = this.tabs_d + text;
    }

    public void printAttribute(String name, int value) {
        if (this.ignoreEmpty_d && value == -1) {
            return;
        }
        this.printAttribute(name, String.valueOf(value));
    }

    public void printAttribute(String name, Enum value) {
        if (!this.ignoreEmpty_d || value != null) {
            this.printAttribute(name, value == null ? "" : value.toString());
        }
    }

    public void printAttribute(String name, long value) {
        if (this.ignoreEmpty_d && value == -1L) {
            return;
        }
        this.printAttribute(name, String.valueOf(value));
    }

    public void printAttribute(String name, float value) {
        if (this.ignoreEmpty_d && value == -1.0f) {
            return;
        }
        this.printAttribute(name, String.valueOf(value));
    }

    public void printAttribute(String name, double value) {
        if (this.ignoreEmpty_d && value == -1.0) {
            return;
        }
        this.printAttribute(name, String.valueOf(value));
    }

    public void printAttribute(String name, boolean value) {
        if (this.ignoreEmpty_d && !value) {
            return;
        }
        this.printAttribute(name, String.valueOf(value));
    }

    public void printAttribute(String name, String value) {
        if (value == null) {
            value = "";
        }
        if (this.ignoreEmpty_d && value.equals("")) {
            return;
        }
        this.println(name + "=" + this.quoted(this.escaped(value)));
    }

    public void printAttributeNoBreak(String name, int value) {
        if (this.ignoreEmpty_d && value == -1) {
            return;
        }
        this.printAttributeNoBreak(name, String.valueOf(value));
    }

    public void printAttributeNoBreak(String name, boolean value) {
        if (this.ignoreEmpty_d && !value) {
            return;
        }
        this.printAttributeNoBreak(name, String.valueOf(value));
    }

    public void printAttributeNoBreak(String name, String value) {
        if (this.ignoreEmpty_d && (value == null || value.equals(""))) {
            return;
        }
        this.printPlain(" " + name + "=" + this.quoted(this.escaped(value)));
    }

    public void printDelimited(String tag, List elements, String delimiter) {
        if (this.ignoreEmpty_d && (elements == null || elements.isEmpty())) {
            return;
        }
        StringBuffer text = new StringBuffer("");
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            text.append(String.valueOf(it.next()));
            if (!it.hasNext()) continue;
            text.append(delimiter);
        }
        this.printAttribute(tag, text.toString());
    }

    public void printPlain(String text) {
        this.printPending();
        this.buffer_d.append(text);
    }

    public void println(String text) {
        this.print(text + "\n");
    }

    public String quoted(String text) {
        return "\"" + text + "\"";
    }

    public String toString() {
        this.printPending();
        return this.buffer_d.toString();
    }

    public void unindent() {
        this.tabs_d = this.tabs_d.substring(1);
    }

    private void printPending() {
        if (this.pending_d != null) {
            this.buffer_d.append(this.pending_d);
            this.pending_d = null;
        }
    }
}

