/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.Locale;
import oracle.bpm.util.Base64;
import oracle.bpm.util.SimpleCrypt;

public class Utility {
    public static String getKey() {
        StringBuffer key = new StringBuffer();
        key.append('F');
        key.append('u');
        key.append('e');
        key.append('g');
        key.append('o');
        return key.toString();
    }

    public static String getLocalizedSize(Locale locale, long size) {
        StringBuffer stringBuffer = new StringBuffer();
        double iBytesPerKb = 1024.0;
        double iBytesPerMb = 1048576.0;
        double iSize = (double)size / 1048576.0;
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(2);
        if (iSize < 1.0) {
            iSize = (double)size / 1024.0;
            stringBuffer.append(numberFormat.format(iSize) + " Kb");
        } else {
            stringBuffer.append(numberFormat.format(iSize) + " Mb");
        }
        return stringBuffer.toString();
    }

    public static byte[] base64Decode(String input) {
        return Base64.decode(input);
    }

    public static String base64Encode(byte[] data) {
        return Base64.encode(data);
    }

    public static String[] copyStringArray(String[] array) {
        String[] stringArray = new String[array.length];
        System.arraycopy(array, 0, stringArray, 0, array.length);
        return stringArray;
    }

    public static String scramblePassword(String password) {
        return Utility.scrambleTextUTF8(password, Utility.getKey());
    }

    public static String scrambleTextUTF8(String text, String key) {
        if (text == null) {
            return null;
        }
        try {
            SimpleCrypt guardian = new SimpleCrypt(key, true);
            byte[] crypted = guardian.crypt(text.getBytes("UTF8"));
            return Utility.base64Encode(crypted);
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeException("UsupportedEncodingException: " + exc.getMessage());
        }
    }

    public static String unscramblePassword(String password) {
        return Utility.unscrambleTextUTF8(password, Utility.getKey());
    }

    public static String unscrambleTextUTF8(String text, String key) {
        if (text == null) {
            return null;
        }
        try {
            byte[] decoded = Utility.base64Decode(text);
            SimpleCrypt guardian = new SimpleCrypt(key, true);
            byte[] crypted = guardian.crypt(decoded);
            return new String(crypted, "UTF8");
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeException("UsupportedEncodingException: " + exc.getMessage());
        }
    }
}

