/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.LinkedList;

public class Sequencer {
    private volatile boolean dismissed = false;
    private LinkedList<Job> jobs = new LinkedList();
    private volatile Runner sequencer = new Runner();

    public Sequencer() {
        this.sequencer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismiss() {
        this.dismissed = true;
        LinkedList<Job> linkedList = this.jobs;
        synchronized (linkedList) {
            this.jobs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job execute(Runnable r) {
        if (this.dismissed) {
            throw new IllegalStateException("This sequencer has been dismissed and cannot execute more jobs");
        }
        Job job = new Job(r);
        LinkedList<Job> linkedList = this.jobs;
        synchronized (linkedList) {
            this.jobs.add(job);
            this.jobs.notify();
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processNext(long timeout) {
        Job job;
        LinkedList<Job> linkedList = this.jobs;
        synchronized (linkedList) {
            if (this.jobs.isEmpty() && !this.dismissed) {
                try {
                    this.jobs.wait(timeout);
                }
                catch (InterruptedException e) {
                    this.dismissed = true;
                }
            }
            if (this.dismissed) {
                return true;
            }
            job = this.jobs.removeFirst();
        }
        if (job == null) {
            return false;
        }
        try {
            job.target().run();
        }
        catch (Throwable t) {
            job.setThrowable(t);
        }
        finally {
            job.finished();
        }
        return job.mustStop();
    }

    private class Runner
    extends Thread {
        public Runner() {
            super("Job Sequencer Thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!Sequencer.this.dismissed && !Sequencer.this.processNext(0L)) {
            }
        }
    }

    public class Job {
        private volatile boolean finished = false;
        private boolean mustStop = false;
        private Runnable runnable;
        private Throwable t;

        private Job(Runnable r) {
            this.runnable = r;
        }

        public synchronized Throwable getThrowable() {
            if (!this.finished) {
                throw new IllegalStateException("Job has not finished its execution");
            }
            return this.t;
        }

        public void waitFor() throws InterruptedException {
            this.waitFor(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitFor(long timeout) throws InterruptedException {
            boolean waitCompletion;
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout must not be negative");
            }
            Thread current = Thread.currentThread();
            if (current == Sequencer.this.sequencer) {
                if (timeout == 0L) {
                    waitCompletion = false;
                    while (!this.finished) {
                        Sequencer.this.processNext(0L);
                    }
                } else {
                    this.mustStop = true;
                    current.setName(current.getName() + " [dismissed]");
                    Sequencer.this.sequencer = new Runner();
                    Sequencer.this.sequencer.start();
                    waitCompletion = true;
                }
            } else {
                waitCompletion = true;
            }
            if (waitCompletion) {
                Job job = this;
                synchronized (job) {
                    if (!this.finished) {
                        this.wait(timeout);
                    }
                }
            }
            return this.finished;
        }

        private void setThrowable(Throwable t) {
            this.t = t;
        }

        private synchronized void finished() {
            this.finished = true;
            this.notify();
        }

        private boolean mustStop() {
            return this.mustStop;
        }

        private Runnable target() {
            return this.runnable;
        }
    }
}

