/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

public class Rendezvous {
    private int howMany;

    public Rendezvous(int howMany) {
        this.howMany = howMany;
    }

    public void meet() throws InterruptedException {
        this.meet(0L);
    }

    public synchronized boolean meet(long timeout) throws InterruptedException {
        if (this.howMany <= 0) {
            throw new IllegalMonitorStateException("Everyone has met");
        }
        if (--this.howMany == 0) {
            this.notifyAll();
        } else {
            this.wait(timeout);
        }
        return this.howMany == 0;
    }

    public synchronized void reset(int howMany) {
        if (this.howMany != 0) {
            throw new IllegalMonitorStateException("All threads haven't met yet");
        }
        this.howMany = howMany;
    }
}

