/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.msg.CoreMsg;

public class JavaCompiler {
    private List<File> classpath = new ArrayList<File>();
    private boolean debug;
    private boolean nowarns;
    private File sourcePath;
    private List<File> sources = new ArrayList<File>();
    private File targetDir;
    private boolean verbose;

    public static JavaCompiler create() {
        return new JavaCompiler();
    }

    public static JavaCompiler createCompiler() {
        JavaCompiler result = new JavaCompiler();
        String javaClassPath = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(javaClassPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            File file = new File(st.nextToken());
            result.addFileToClassPath(file);
        }
        return result;
    }

    public void setGenerateDebugInfo(boolean debug) {
        this.debug = debug;
    }

    public void setNoWarnings(boolean nowarns) {
        this.nowarns = nowarns;
    }

    public void setSourcePath(File path) {
        this.sourcePath = path;
    }

    public void setTargetDir(File dir) {
        this.targetDir = dir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void addFileToClassPath(File path) {
        if (!this.classpath.contains(path)) {
            this.classpath.add(path);
        }
    }

    public void addFilesToClassPath(File[] files) {
        if (files != null) {
            this.classpath.addAll(Arrays.asList(files));
        }
    }

    public void addJarsToClassPath(File lib) {
        if (!lib.isDirectory()) {
            throw new IllegalArgumentException("File '" + lib + "' is not a directory");
        }
        File[] files = lib.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                this.addFileToClassPath(file);
            }
        }
    }

    public void addSourceFile(File source) {
        this.sources.add(source);
    }

    public void addSourceFiles(File[] sources) {
        if (sources != null) {
            this.sources.addAll(Arrays.asList(sources));
        }
    }

    public void addSourceFiles(List<File> sources) {
        if (sources != null) {
            this.sources.addAll(sources);
        }
    }

    public void compile() throws JavaCompilationException {
        if (!this.sources.isEmpty()) {
            this.compile(this.sources);
            this.sources.clear();
        }
    }

    private static String externalize(File file) {
        try {
            return file.getAbsoluteFile().getCanonicalPath();
        }
        catch (IOException ex) {
            return file.getAbsolutePath();
        }
    }

    private void compile(List<File> sources) throws JavaCompilationException {
        List<String> command = this.createCommandLine();
        for (File file : sources) {
            command.add(JavaCompiler.externalize(file));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (!this.doCompile(command, out)) {
            try {
                System.out.println("------------ JavaCompiler.compile command ------------");
                System.out.println(command.toString());
                System.out.println("------------------------------------------------------");
                throw new JavaCompilationException(new String(out.toByteArray(), "ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                throw new JavaCompilationException(e.getMessage());
            }
        }
    }

    private List<String> createCommandLine() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("-classpath");
        command.add(this.createClassPath());
        if (this.targetDir != null) {
            command.add("-d");
            command.add(JavaCompiler.externalize(this.targetDir));
        }
        if (this.sourcePath != null) {
            command.add("-sourcepath");
            command.add(JavaCompiler.externalize(this.sourcePath));
        }
        if (this.nowarns) {
            command.add("-nowarn");
        }
        if (this.debug) {
            command.add("-g");
        }
        if (this.verbose) {
            command.add("-verbose");
        }
        command.add("-encoding");
        command.add("UTF-8");
        return command;
    }

    private String createClassPath() {
        Iterator<File> it = this.classpath.iterator();
        String cp = "";
        while (it.hasNext()) {
            File path = it.next();
            cp = cp + JavaCompiler.externalize(path);
            if (!it.hasNext()) continue;
            cp = cp + File.pathSeparator;
        }
        return cp;
    }

    private boolean doCompile(List<String> command, OutputStream errors) throws JavaCompilationException {
        String[] args = command.toArray(new String[command.size()]);
        try {
            Class<?> jc = Class.forName("com.sun.tools.javac.Main", true, this.getClass().getClassLoader());
            Method method = jc.getMethod("compile", String[].class, PrintWriter.class);
            PrintWriter printWriter = new PrintWriter(errors);
            Object retVal = method.invoke(null, args, printWriter);
            printWriter.flush();
            if (retVal == null || !(retVal instanceof Integer)) {
                throw new JavaCompilationException("Error compiling, unexpected return value from javac: " + retVal);
            }
            return (Integer)retVal == 0;
        }
        catch (ClassNotFoundException e) {
            throw new JavaCompilationException("Cannot find JAVAC compiler, check that 'tools.jar' is in the classpath");
        }
        catch (NoSuchMethodException e) {
            throw new JavaCompilationException("Javac compiler interface changed. Different JDK?");
        }
        catch (Exception e) {
            throw new JavaCompilationException("Failure compiling, reason: " + e.getMessage());
        }
    }

    public static class JavaCompilationException
    extends DefaultException {
        private String errors;
        static final long serialVersionUID = 5894128999899114642L;
        static final long serialCheck = 6257719391308615227L;

        public JavaCompilationException(String errors) {
            this.setKey(CoreMsg.CHECK_LOG);
            this.errors = errors;
        }

        public String getErrors() {
            return this.errors;
        }

        @Override
        public String getMessage() {
            return this.errors;
        }
    }
}

