/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import oracle.bpm.log.Log;

public abstract class JarResources {
    private boolean allowFileType = true;
    private boolean debugOn = false;
    private Hashtable<String, byte[]> htJarContents = new Hashtable();
    private Hashtable<String, Integer> htSizes = new Hashtable();
    private String jarFileName;

    public JarResources(String jarFileName) {
        this(jarFileName, false);
    }

    public JarResources(String jarFileName, boolean isDebug) {
        this.jarFileName = jarFileName;
        this.setDebug(isDebug);
        this.init();
    }

    public JarResources(String jarFileName, boolean isDebug, boolean allowFileType) {
        this.jarFileName = jarFileName;
        this.setDebug(isDebug);
        this.allowFileType = allowFileType;
        this.init();
    }

    public abstract String[] getFileTypes();

    public byte[] getResource(String name) {
        return this.htJarContents.get(name);
    }

    public Map<String, byte[]> getResources() {
        return this.htJarContents;
    }

    private void setDebug(boolean bool) {
        this.debugOn = bool;
    }

    private boolean isFileTypeValid(String file) {
        String[] valid;
        for (String aValid : valid = this.getFileTypes()) {
            if (!file.endsWith(aValid)) continue;
            return this.allowFileType;
        }
        return !this.allowFileType;
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ZipFile zf = null;
        FileInputStream fis = null;
        try {
            ZipEntry ze;
            zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze2 = e.nextElement();
                if (this.debugOn && Log.isDebugging()) {
                    Log.logDebug(this.dumpZipEntry(ze2));
                }
                if (ze2 == null || !this.isFileTypeValid(ze2.getName())) continue;
                this.htSizes.put(ze2.getName(), (int)ze2.getSize());
            }
            zf.close();
            fis = new FileInputStream(this.jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            while ((ze = zis.getNextEntry()) != null) {
                int chunk;
                int size;
                if (ze.isDirectory() || ze == null || !this.isFileTypeValid(ze.getName())) continue;
                if (this.debugOn && Log.isDebugging()) {
                    Log.logDebug("ze.getName()=" + ze.getName() + "," + "getSize()=" + ze.getSize());
                }
                if ((size = (int)ze.getSize()) == -1) {
                    size = this.htSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                this.htJarContents.put(ze.getName(), b);
                if (!this.debugOn || !Log.isDebugging()) continue;
                Log.logDebug(ze.getName() + "  rb=" + rb + ",size=" + size + ",csize=" + ze.getCompressedSize());
            }
        }
        catch (NullPointerException e) {
            Log.logSevere(e);
        }
        catch (IOException e) {
            Log.logSevere(e);
        }
        finally {
            try {
                if (zf != null) {
                    zf.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ignore) {}
        }
    }
}

