/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectoryPassport;
import fuego.directory.DirectorySession;
import fuego.prefs.engine.EnginePreferences;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.standalone.StandaloneEnginePreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.CommandExecutor;
import oracle.bpm.util.FileUtils;
import oracle.bpm.util.FuegoDirectories;

public class FuegoEngine
extends CommandExecutor {
    private String directoryId;
    private String engine;
    private static final String CONSOLE_MODE = "-Dfuego.boot.console=true";
    private static final HashMap<String, FuegoEngine> instanceMap = new HashMap();

    public FuegoEngine(String engine, String directoryId) {
        this.engine = engine;
        this.directoryId = directoryId;
        this.setMessagesPrefix(" ");
    }

    public static synchronized FuegoEngine create(String engineId, String directoryId) {
        FuegoEngine executor = FuegoEngine.get(engineId, directoryId);
        assert (executor == null) : "Executor for engine: " + engineId + " in directory: " + directoryId + "is trying to be created twice. Should have been removed!";
        executor = new FuegoEngine(engineId, directoryId);
        instanceMap.put(directoryId + "/" + engineId, executor);
        return executor;
    }

    public static synchronized FuegoEngine get(String engineId, String directoryId) {
        return instanceMap.get(directoryId + "/" + engineId);
    }

    public static synchronized FuegoEngine remove(String engineId, String directoryId) {
        return instanceMap.remove(directoryId + "/" + engineId);
    }

    @Override
    protected String[] getCommand(String[] args, String[] vmargs) throws Exception {
        this.printStdOutput(CoreMsg.LOADING_ENGINE_PROPERTIES.getString());
        DirectoryPassport passport = DirectoryPassport.createWithIDAndPreset(this.directoryId, "engine");
        passport.fillPassport();
        DirectorySession dirSession = Directory.startSession(passport);
        StandaloneEnginePreferences properties = EnginePreferences.loadStandalonePreferences(this.engine, dirSession, EngineType.ENTERPRISE);
        if (properties == null) {
            throw new Exception(CoreMsg.ENGINE_PROPERTIES_NOT_FOUND.getString());
        }
        int jvmHeapMax = properties.getMemory().getMaxJvmHeapSize().getValue();
        try {
            dirSession.disconnect();
        }
        catch (DirectoryException e) {
            // empty catch block
        }
        String fileSeparator = System.getProperties().getProperty("file.separator");
        String os = System.getProperty("os.name");
        String java = System.getProperties().getProperty("java.home") + fileSeparator + "bin" + fileSeparator;
        java = os.toUpperCase().startsWith("WINDOW") ? java + "javaw" : java + "java";
        String ftboot = this.getBaseDir() + fileSeparator + "lib" + fileSeparator + "fuego.boot.jar";
        ArrayList<String> command = new ArrayList<String>();
        command.add(java);
        command.add("-jar");
        if (os.toUpperCase().startsWith("WINDOW")) {
            command.add("-Xrs");
        }
        try {
            String options = System.getProperty("JAVA_OPTIONS");
            if (options != null && options.length() > 2) {
                String[] opts;
                for (String s : opts = Str.split(options.trim(), ' ', true)) {
                    command.add(s);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (jvmHeapMax > 0) {
            command.add("-Xmx" + jvmHeapMax + "M");
        }
        command.add("-Djava.awt.headless=true");
        command.add("-Dfile.encoding=UTF-8");
        if (vmargs != null) {
            for (String vmarg : vmargs) {
                if (vmarg == null || vmarg.trim().length() <= 0) continue;
                command.add(vmarg);
            }
        }
        String xbootClassPath = "-Xbootclasspath:" + new File(FuegoDirectories.libDir(), "oracle.bpm.lib.net.jar").getCanonicalPath() + File.pathSeparator + FileUtils.getBootClassPath();
        String emmaDirProperty = System.getProperty("emma.coverage.out.file");
        String emaLibJar = System.getProperty("emma.lib.jar");
        if (emmaDirProperty != null && emaLibJar != null) {
            command.add("-Demma.coverage.out.file=" + emmaDirProperty + ".engine");
            command.add("-Demma.coverage.out.merge=true");
            xbootClassPath = xbootClassPath + File.pathSeparator + new File(emaLibJar);
        }
        command.add(xbootClassPath);
        command.add(xbootClassPath);
        command.add(CONSOLE_MODE);
        command.add(ftboot);
        command.add("-no-cache");
        String mainClass = "fuego.fengine.jar:fuego.fengine.ServerAdmin";
        command.add("fuego.fengine.jar:fuego.fengine.ServerAdmin");
        if (args != null) {
            for (String arg : args) {
                if (arg == null || arg.trim().length() <= 0) continue;
                command.add(arg);
            }
        }
        return command.toArray(new String[command.size()]);
    }

    @Override
    protected String getFailureString() {
        return "FAILED";
    }

    @Override
    protected String getSuccessString() {
        return "SERVER STARTED";
    }

    private String getBaseDir() {
        int index;
        String baseDir = FuegoDirectories.installation();
        if (baseDir.endsWith("WEB-INF") && (index = baseDir.indexOf("webapps")) > 0) {
            baseDir = baseDir.substring(0, index);
        }
        return baseDir;
    }
}

