/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.util.FixOption;

public interface Fixable {
    public FixOption[] getFixOptions();

    public boolean isFixable();

    public static class Registry {
        private static int index = 0;
        private static Map<String, Map<String, Fixable>> fixableExceptions = Collections.synchronizedMap(new HashMap());

        public static String setFixable(String project, Fixable fixable) {
            String key = String.valueOf(index++);
            Map<String, Fixable> map = fixableExceptions.get(project);
            if (map == null) {
                map = Collections.synchronizedMap(new HashMap());
                fixableExceptions.put(project, map);
            }
            map.put(key, fixable);
            return key;
        }

        public static Fixable getFixable(String project, String key) {
            Map<String, Fixable> map = fixableExceptions.get(project);
            return map != null ? map.get(key) : null;
        }

        public static void clearAll(String project) {
            fixableExceptions.remove(project);
        }
    }
}

