/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateFilter
implements Serializable {
    private Date absoluteDate_d;
    private boolean isRelative_d;
    private int relativeType_d = -1;
    private int relativeValue_d = -1;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int MONTH = 3;
    public static final int YEAR = 4;
    public static final int WEEK = 5;
    static final long serialVersionUID = 1000002010410062001L;
    static final long serialCheck = -3820570451170992443L;

    public DateFilter() {
        this(new Date());
    }

    public DateFilter(Date date) {
        this.isRelative_d = false;
        this.absoluteDate_d = date;
    }

    public DateFilter(int value, int type) {
        this.isRelative_d = true;
        this.relativeValue_d = value;
        this.relativeType_d = type;
    }

    public Date getDate() {
        return this.isRelative() ? this.getRelativeDate() : this.absoluteDate_d;
    }

    public boolean isRelative() {
        return this.isRelative_d;
    }

    public int getRelativeType() {
        return this.relativeType_d;
    }

    public int getRelativeValue() {
        return this.relativeValue_d;
    }

    public Date getUntilDate() {
        if (!this.isRelative()) {
            return this.getDate();
        }
        Calendar until = Calendar.getInstance(TimeZone.getDefault());
        until.setTime(new Date());
        until.setLenient(true);
        until.setTime(this.getRelativeDate());
        switch (this.relativeType_d) {
            case 0: {
                until.set(13, 59);
                break;
            }
            case 1: {
                until.set(12, 59);
                until.set(13, 59);
                break;
            }
            case 2: {
                until.set(9, 1);
                until.set(10, until.getActualMaximum(10));
                until.set(12, 59);
                until.set(13, 59);
                break;
            }
            case 3: {
                until.set(5, until.getActualMaximum(5));
                until.set(9, 1);
                until.set(10, until.getActualMaximum(10));
                until.set(12, 59);
                until.set(13, 59);
                break;
            }
            case 4: {
                until.set(2, 11);
                until.set(5, 31);
                until.set(9, 1);
                until.set(10, until.getActualMaximum(10));
                until.set(12, 59);
                until.set(13, 59);
                break;
            }
            case 5: {
                int dayOfWeek = until.get(7);
                until.add(5, dayOfWeek + (7 - dayOfWeek));
                until.set(9, 1);
                until.set(10, until.getActualMaximum(10));
                until.set(12, 59);
                until.set(13, 59);
            }
        }
        return until.getTime();
    }

    private static int getCalendarVar(int type) {
        int calendarVar = 0;
        switch (type) {
            case 0: {
                calendarVar = 12;
                break;
            }
            case 1: {
                calendarVar = 10;
                break;
            }
            case 2: {
                calendarVar = 5;
                break;
            }
            case 3: {
                calendarVar = 2;
                break;
            }
            case 4: {
                calendarVar = 1;
                break;
            }
            case 5: {
                calendarVar = 4;
            }
        }
        return calendarVar;
    }

    private Date getRelativeDate() {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.setLenient(true);
        switch (this.relativeType_d) {
            case 0: {
                now.add(12, this.relativeValue_d);
                now.set(13, 0);
                break;
            }
            case 1: {
                now.add(10, this.relativeValue_d);
                now.set(12, 0);
                now.set(13, 0);
                break;
            }
            case 2: {
                now.add(5, this.relativeValue_d);
                now.set(9, 0);
                now.set(10, now.getActualMinimum(10));
                now.set(12, 0);
                now.set(13, 0);
                break;
            }
            case 3: {
                now.add(2, this.relativeValue_d);
                now.set(5, now.getActualMinimum(5));
                now.set(10, now.getActualMinimum(10));
                now.set(12, 0);
                now.set(13, 0);
                break;
            }
            case 4: {
                now.add(1, this.relativeValue_d);
                now.set(2, 0);
                now.set(5, now.getActualMinimum(5));
                now.set(10, now.getActualMinimum(10));
                now.set(12, 0);
                now.set(13, 0);
                break;
            }
            case 5: {
                now.add(4, this.relativeValue_d);
                int dayOfWeek = now.get(7);
                now.add(5, -dayOfWeek);
                now.set(9, 0);
                now.set(10, now.getActualMinimum(10));
                now.set(12, 0);
                now.set(13, 0);
            }
        }
        return now.getTime();
    }
}

