/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.IOException;
import java.io.InputStream;

public class ContentType {
    public static final String IMAGE_GIF = ContentType.combine("image", "gif");
    public static final String IMAGE_X_PIXMAP = ContentType.combine("image", "x-pixmap");
    public static final String IMAGE_X_BITMAP = ContentType.combine("image", "x-bitmap");
    public static final String IMAGE_X_PORTABLE_PIXMAP = ContentType.combine("image", "x-portable-pixmap");
    public static final String TEXT_HTML = ContentType.combine("text", "html");

    public static String get(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IOException("mark not supported");
        }
        int CHUNK = 6;
        in.mark(6);
        int[] beginning = new int[6];
        for (int i = 0; i < 6; ++i) {
            beginning[i] = in.read();
        }
        in.reset();
        return ContentType.get(beginning);
    }

    private static String combine(String type, String subType) {
        return type + '/' + subType;
    }

    private static String get(int[] beg) {
        if (beg[0] == 71 && beg[1] == 73 && beg[2] == 70 && beg[3] == 56) {
            return IMAGE_GIF;
        }
        if (beg[0] == 35 && beg[1] == 100 && beg[2] == 101 && beg[3] == 102) {
            return IMAGE_X_BITMAP;
        }
        if (beg[0] == 33 && beg[1] == 32 && beg[2] == 88 && beg[3] == 80 && beg[4] == 77 && beg[5] == 50) {
            return IMAGE_X_PIXMAP;
        }
        if (beg[0] == 60 && (beg[1] == 33 || beg[5] == 62 && (beg[1] == 104 && (beg[2] == 116 && beg[3] == 109 && beg[4] == 108 || beg[2] == 101 && beg[3] == 97 && beg[4] == 100) || beg[1] == 98 && beg[2] == 111 && beg[3] == 100 && beg[4] == 121))) {
            return TEXT_HTML;
        }
        if (beg[0] == 80 && beg[1] == 54) {
            return IMAGE_X_PORTABLE_PIXMAP;
        }
        return null;
    }
}

