/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.CommandExecutionListener;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.StdStreamConsumer;
import oracle.bpm.util.StringTokenizer;

public abstract class CommandExecutor {
    protected ByteArrayOutputStream errOutput;
    protected boolean isAlive = false;
    protected ByteArrayOutputStream out;
    protected Process process;
    private boolean aborted = false;
    private ByteArrayOutputStream fullThreadDump;
    private HashSet<CommandExecutionListener> listeners;
    private StringBuffer messages;
    private int mode = 1;
    private String msgPrefix;
    private PrintStream stdError;
    private PrintStream stdOutput = System.out;
    private int waitMilliseconds = 10000;
    public static final int REGULAR = 0;
    public static final int DAEMON = 1;

    protected CommandExecutor() {
        this.stdError = System.err;
        this.messages = new StringBuffer();
        this.fullThreadDump = new ByteArrayOutputStream();
    }

    public void abort() {
        this.aborted = true;
        if (this.process != null) {
            this.process.destroy();
        }
        this.processExit();
    }

    public void addListener(CommandExecutionListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullThreadDump() {
        if (this.process == null) {
            return null;
        }
        OutputStream os = this.process.getOutputStream();
        try {
            os.write("DUMP\n".getBytes());
            os.flush();
            ByteArrayOutputStream byteArrayOutputStream = this.fullThreadDump;
            synchronized (byteArrayOutputStream) {
                try {
                    if (!"".equals(this.fullThreadDump.toString())) {
                        return this.fullThreadDump.toString();
                    }
                    this.fullThreadDump.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                String dump = this.fullThreadDump.toString();
                this.fullThreadDump = new ByteArrayOutputStream();
                return dump;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getMessages() {
        return this.messages.toString();
    }

    public int getRestartExitValue() {
        return 33;
    }

    public void removeListener(CommandExecutionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void run(String[] args, String[] vmargs) {
        switch (this.mode) {
            case 0: {
                this.execute(args, vmargs);
                return;
            }
            case 1: {
                this.executeDaemon(args, vmargs);
            }
        }
    }

    public void setErrOutput(PrintStream err) {
        this.stdError = err;
    }

    public void setExecutionMode(int mode) {
        this.mode = mode;
    }

    public void setMessagesPrefix(String prefix) {
        this.msgPrefix = prefix;
    }

    public void setStdOutput(PrintStream out) {
        this.stdOutput = out;
    }

    protected abstract String[] getCommand(String[] var1, String[] var2) throws Exception;

    protected abstract String getFailureString();

    protected abstract String getSuccessString();

    protected synchronized void printStdError(String msg) {
        if (this.stdError == null) {
            Log.logInfo(CoreMsg.PRINTING_ERROR(this.msgPrefix, msg));
        } else {
            this.stdError.println(this.msgPrefix + ": " + msg);
        }
    }

    protected synchronized void printStdOutput(String msg) {
        if (this.stdOutput == null) {
            Log.logInfo(CoreMsg.PRINTING_OUTPUT(this.msgPrefix, msg));
        } else {
            this.stdOutput.println(this.msgPrefix + ": " + msg);
        }
    }

    protected synchronized void printThreadDump(String msg) {
        if (this.stdOutput == null) {
            Log.logSevere(CoreMsg.PRINTING_OUTPUT(this.msgPrefix, msg));
        } else {
            this.stdOutput.println(this.msgPrefix + msg);
        }
    }

    synchronized void appendMessage(String message) {
        this.messages.append(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeStreamsAndCheckStart() {
        if (this.process != null) {
            InputStream in = this.process.getInputStream();
            InputStream err = this.process.getErrorStream();
            StartCheckerStreamConsumer stdout = new StartCheckerStreamConsumer(this, this.out, in, this.getSuccessString(), this.getFailureString(), this.getFullThreadDumpString() + "|" + "DUMP CANNOT BE PERFORMED YET", false);
            StartCheckerStreamConsumer stderr = new StartCheckerStreamConsumer(this, this.errOutput, err, this.getSuccessString(), this.getFailureString(), this.getFullThreadDumpString() + "|" + "DUMP CANNOT BE PERFORMED YET", true);
            StartChecker initChecker = new StartChecker(this, this.process);
            stdout.start();
            stderr.start();
            initChecker.start();
            CommandExecutor commandExecutor = this;
            synchronized (commandExecutor) {
                try {
                    this.wait();
                    if (stdout != null) {
                        stdout.setAsStarted();
                    }
                    stderr.setAsStarted();
                    initChecker.setStop(true);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            try {
                this.process.exitValue();
                this.messages.append(this.errOutput.toString());
                this.notifyListener(false);
                this.processExit();
                this.errOutput.reset();
                return;
            }
            catch (IllegalThreadStateException e) {
                this.messages.append(this.errOutput.toString());
                String errOut = this.errOutput.toString();
                if (errOut.indexOf(this.getSuccessString()) != -1) {
                    this.notifyListener(true);
                } else if (errOut.indexOf(this.getFailureString()) != -1) {
                    this.notifyListener(false);
                    this.processExit();
                } else {
                    System.out.println("[CommandExecutor] Received output is neither '" + this.getFailureString() + "' nor '" + this.getSuccessString() + "'! Failure status is assumed. OUTPUT = '" + errOut + "'");
                    this.notifyListener(false);
                }
                this.errOutput.reset();
            }
        }
    }

    private void execute(String[] args, String[] vmargs) {
        try {
            this.out = new ByteArrayOutputStream();
            this.errOutput = new ByteArrayOutputStream();
            this.process = Runtime.getRuntime().exec(this.getCommand(args, vmargs));
            if (this.process == null) {
                this.notifyListener(false);
                this.processExit();
                return;
            }
            InputStream in = this.process.getInputStream();
            InputStream err = this.process.getErrorStream();
            StartCheckerStreamConsumer stdout = new StartCheckerStreamConsumer(this, this.out, in, this.getSuccessString(), this.getFailureString(), this.getFullThreadDumpString() + "|" + "DUMP CANNOT BE PERFORMED YET", false);
            StartCheckerStreamConsumer stderr = new StartCheckerStreamConsumer(this, this.errOutput, err, this.getSuccessString(), this.getFailureString(), this.getFullThreadDumpString() + "|" + "DUMP CANNOT BE PERFORMED YET", true);
            stdout.start();
            stderr.start();
            this.process.waitFor();
            int exitValue = this.process.exitValue();
            this.messages.append(this.errOutput.toString());
            String errOut = this.errOutput.toString();
            stdout.setStop(true);
            stderr.setStop(true);
            if (exitValue == 0 || errOut.indexOf(this.getSuccessString()) != -1) {
                this.notifyListener(true);
                this.errOutput.reset();
            } else {
                this.notifyListener(false);
                this.processExit();
                this.errOutput.reset();
            }
        }
        catch (Exception e) {
            this.printStdOutput(e.getMessage());
            this.printStdError(ExceptionFormatter.fullTechLevel(e));
            this.messages.append(e.getMessage());
            this.notifyListener(false);
            this.processExit();
        }
    }

    private void executeCommand(String[] args, String[] vmargs) {
        try {
            this.process = Runtime.getRuntime().exec(this.getCommand(args, vmargs));
            if (this.aborted) {
                this.abort();
            } else {
                this.consumeStreamsAndCheckStart();
                this.isAlive = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printStdOutput(e.getMessage());
            this.printStdError(ExceptionFormatter.fullTechLevel(e));
            this.messages.append(e.getMessage());
            this.notifyListener(false);
            this.processExit();
        }
    }

    private void executeDaemon(String[] args, String[] vmargs) {
        this.out = new ByteArrayOutputStream();
        this.errOutput = new ByteArrayOutputStream();
        this.executeCommand(args, vmargs);
        while (this.isAlive) {
            try {
                int exitValue = this.process.exitValue();
                if (exitValue == this.getRestartExitValue()) {
                    this.executeCommand(args, vmargs);
                } else {
                    this.processExit();
                }
            }
            catch (IllegalThreadStateException itse) {
                // empty catch block
            }
            try {
                Thread.sleep(this.waitMilliseconds);
            }
            catch (Exception ignore) {}
        }
        try {
            this.out.close();
            this.errOutput.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    private String getFullThreadDumpString() {
        String vendor = System.getProperty("java.vm.vendor", "");
        if (vendor.startsWith("IBM")) {
            return "Written Java core to | Java core file written to ";
        }
        return "Full thread dump";
    }

    private synchronized void notifyListener(boolean started) {
        if (this.listeners != null) {
            for (CommandExecutionListener listener : this.listeners) {
                if (started) {
                    listener.commandStarted();
                    continue;
                }
                listener.commandStartFailed();
            }
        }
    }

    private void processExit() {
        this.isAlive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readFullThreadDump(String s, InputStream is) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = this.fullThreadDump;
        synchronized (byteArrayOutputStream) {
            if (s.indexOf("DUMP CANNOT BE PERFORMED YET") >= 0) {
                this.fullThreadDump.write("DUMP CANNOT BE PERFORMED YET".getBytes());
                this.fullThreadDump.close();
                this.fullThreadDump.notifyAll();
                return;
            }
            String vendor = System.getProperty("java.vm.vendor", "");
            BufferedReader reader = null;
            boolean close = false;
            if (vendor.startsWith("IBM")) {
                String fileMessage = this.getFullThreadDumpString();
                StringTokenizer messages = new StringTokenizer(fileMessage, "|");
                boolean done = false;
                while (messages.hasMoreTokens() && !done) {
                    String fileMsg = messages.nextToken();
                    int startOfDumpString = s.indexOf(fileMsg);
                    int indexOfFileName = startOfDumpString + fileMsg.length();
                    if (startOfDumpString <= 0) continue;
                    String fileName = s.substring(indexOfFileName).trim();
                    while (reader == null) {
                        try {
                            reader = new BufferedReader(new FileReader(fileName));
                            done = true;
                        }
                        catch (FileNotFoundException e) {}
                    }
                }
                close = true;
            } else {
                this.fullThreadDump.write(s.getBytes());
                this.printThreadDump(s);
                reader = new BufferedReader(new InputStreamReader(is));
            }
            assert (reader != null) : "reader cannot be null";
            String line = reader.readLine();
            while (line != null && line.indexOf("DUMP DONE") < 0 && line.indexOf("DUMP CANNOT BE PERFORMED YET") < 0) {
                this.fullThreadDump.write(line.getBytes());
                this.fullThreadDump.write("\n".getBytes());
                this.printThreadDump(line);
                line = reader.readLine();
            }
            if (close) {
                reader.close();
            }
            this.fullThreadDump.close();
            this.fullThreadDump.notifyAll();
        }
    }

    private static class StartCheckerStreamConsumer
    extends StdStreamConsumer {
        private String dumpString_d;
        private boolean error_d;
        private CommandExecutor executor_d;
        private String failureEndString_d;
        private boolean isStarting;
        private String successEndString_d;

        StartCheckerStreamConsumer(CommandExecutor executor, ByteArrayOutputStream out, InputStream in, String successEndString, String failureEndString, String threadDumpString, boolean error) {
            super(out, in);
            this.executor_d = executor;
            this.successEndString_d = successEndString;
            this.failureEndString_d = failureEndString;
            this.dumpString_d = threadDumpString;
            this.error_d = error;
            this.isStarting = true;
        }

        @Override
        protected void notifyFailure(IOException e) {
            if (this.isStarting) {
                this.executor_d.appendMessage(e.getMessage());
                this.executor_d.printStdError(ExceptionFormatter.fullTechLevel(e));
                this.executor_d.notifyListener(false);
                this.executor_d.processExit();
            } else {
                this.executor_d.printStdError(ExceptionFormatter.fullTechLevel(e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processInput(byte[] buf, int count) throws IOException {
            this.out_d.write(buf, 0, count);
            String out = this.out_d.toString();
            if (this.isStarting) {
                this.executor_d.printStdError(out);
                if (out.indexOf(this.successEndString_d) != -1 || out.indexOf(this.failureEndString_d) != -1) {
                    CommandExecutor commandExecutor = this.executor_d;
                    synchronized (commandExecutor) {
                        this.executor_d.notify();
                    }
                }
            } else if (this.error_d) {
                this.executor_d.printStdError(out);
            } else {
                this.executor_d.printStdOutput(out);
            }
            StringTokenizer st = new StringTokenizer(this.dumpString_d, "|");
            boolean done = false;
            while (st.hasMoreTokens() && !done) {
                String dumpStr = st.nextToken();
                if (out.indexOf(dumpStr) == -1) continue;
                this.executor_d.readFullThreadDump(out, this.in_d);
                done = true;
            }
            if (!this.isStarting) {
                ((ByteArrayOutputStream)this.out_d).reset();
            }
        }

        void setAsStarted() {
            this.isStarting = false;
        }
    }

    private static class StartChecker
    extends Thread {
        private CommandExecutor executor;
        private Process process;
        private boolean stop = false;

        StartChecker(CommandExecutor executor, Process process) {
            this.executor = executor;
            this.process = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                try {
                    this.process.exitValue();
                    CommandExecutor commandExecutor = this.executor;
                    synchronized (commandExecutor) {
                        this.executor.notify();
                    }
                    this.stop = true;
                }
                catch (IllegalThreadStateException e) {
                    try {
                        StartChecker.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }
    }
}

