/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import oracle.bpm.util.CommandExecutionListener;
import oracle.bpm.util.CommandExecutor;

public class CommandExecutionThread
extends Thread
implements CommandExecutionListener {
    private String[] arguments;
    private CommandExecutor executor;
    private boolean finished;
    private boolean hasFailed;
    private boolean isAborted;
    private boolean isAlive;
    private String[] vmArguments;
    private Object waiter;

    public CommandExecutionThread(String name, CommandExecutor executor, Object waiter, String[] arguments, String[] vmArguments) {
        this.waiter = waiter;
        this.executor = executor;
        this.arguments = arguments;
        this.vmArguments = vmArguments;
        this.isAlive = false;
        this.isAborted = false;
        this.finished = false;
        this.setName(name);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String execute(String name, CommandExecutor executor, String[] arguments, String[] vmArguments) throws Exception {
        Object waiter = new Object();
        CommandExecutionThread thread = new CommandExecutionThread(name, executor, waiter, arguments, vmArguments);
        executor.setExecutionMode(0);
        thread.start();
        try {
            Object object = waiter;
            synchronized (object) {
                waiter.wait();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (thread.hasFailed()) {
            throw new Exception(executor.getMessages());
        }
        return executor.getMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String executeDaemon(String name, CommandExecutor executor, String[] arguments, String[] vmArguments) throws Exception {
        Object waiter = new Object();
        CommandExecutionThread thread = new CommandExecutionThread(name, executor, waiter, arguments, vmArguments);
        executor.setExecutionMode(1);
        thread.start();
        boolean interrupted = false;
        while (!(thread.isStarted() || thread.hasFailed() || thread.isAborted() || interrupted)) {
            try {
                Object object = waiter;
                synchronized (object) {
                    waiter.wait();
                }
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (thread.isStarted() && (interrupted || Thread.currentThread().isInterrupted())) {
            thread.abort();
            throw new Exception(executor.getMessages());
        }
        if (thread.hasFailed()) {
            throw new Exception(executor.getMessages());
        }
        return executor.getMessages();
    }

    public synchronized boolean isAborted() {
        return this.isAborted;
    }

    public String getFullThreadDump() {
        if (this.executor == null) {
            return "";
        }
        return this.executor.getFullThreadDump();
    }

    public synchronized String getMessages() {
        return this.executor.getMessages();
    }

    public synchronized boolean isStarted() {
        return this.isAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abort() {
        this.isAborted = true;
        this.executor.abort();
        this.notifyAll();
        Object object = this.waiter;
        synchronized (object) {
            this.waiter.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commandStartFailed() {
        this.hasFailed = true;
        this.finished = true;
        Object object = this.waiter;
        synchronized (object) {
            this.waiter.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commandStarted() {
        this.hasFailed = false;
        this.finished = true;
        this.isAlive = true;
        Object object = this.waiter;
        synchronized (object) {
            this.waiter.notifyAll();
        }
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized boolean hasFailed() {
        return this.hasFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.executor.setErrOutput(null);
        this.executor.setStdOutput(null);
        this.executor.addListener(this);
        this.executor.run(this.arguments, this.vmArguments);
        this.isAlive = false;
        Object object = this.waiter;
        synchronized (object) {
            this.waiter.notifyAll();
        }
    }
}

