/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.bpm.lang.Str;
import oracle.bpm.util.Identifier;

public class XmlUtils {
    private static char SEPARATOR = (char)46;
    private static final Set<String> javaWords = new HashSet<String>(Arrays.asList("assert", "abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "threadsafe", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));
    private static final int START = 0;
    private static final int PUNCT = 1;
    private static final int DIGIT = 2;
    private static final int MARK = 3;
    private static final int UPPER = 4;
    private static final int LOWER = 5;
    private static final int NOCASE = 6;
    private static final char HYPHEN = '-';
    private static final char PERIOD = '.';
    private static final char COLON = ':';
    private static final char USCORE = '_';
    private static final char DOT = '\u00b7';
    private static final char TELEIA = '\u0387';
    private static final char AYAH = '\u06dd';
    private static final char ELHIZB = '\u06de';

    public static String getPackageFromNamespace(String uri, boolean useJaxRpcRules) {
        List<Object> result;
        if (uri == null || uri.length() == 0) {
            return "noNamespace";
        }
        int len = uri.length();
        int i = XmlUtils.findSchemeColon(uri);
        if (i == len - 1) {
            result = new ArrayList<String>();
            result.add(uri.substring(0, i));
        } else if (i >= 0 && uri.substring(0, i).equals("java")) {
            result = Arrays.asList(uri.substring(i + 1).split("\\."));
        } else {
            result = new ArrayList();
            ++i;
            block0: while (i < len) {
                while (uri.charAt(i) == '/') {
                    if (++i < len) continue;
                    break block0;
                }
                int start = i;
                while (uri.charAt(i) != '/' && ++i < len) {
                }
                int end = i;
                result.add(uri.substring(start, end));
            }
            if (result.size() > 1) {
                result.set(result.size() - 1, XmlUtils.processFilename((String)result.get(result.size() - 1)));
            }
            if (!result.isEmpty()) {
                List<String> splitdns = XmlUtils.splitDNS((String)result.get(0));
                result.remove(0);
                result.addAll(0, splitdns);
            }
        }
        StringBuilder buf = new StringBuilder();
        for (String string : result) {
            String part = XmlUtils.nonJavaKeyword(XmlUtils.lowerCamelCase(string, useJaxRpcRules, true));
            if (part.length() <= 0) continue;
            buf.append(part);
            buf.append(SEPARATOR);
        }
        if (buf.length() == 0) {
            return "noNamespace";
        }
        if (useJaxRpcRules) {
            return buf.substring(0, buf.length() - 1).toLowerCase();
        }
        return buf.substring(0, buf.length() - 1);
    }

    public static String getExtModuleFromNamespace(String namespace) {
        return "Ext." + XmlUtils.getModuleFromNamespace(namespace);
    }

    public static String buildValidQualifiedModuleName(String text) {
        String[] strings;
        String result = null;
        for (String moduleName : strings = Str.split(text, '.', false)) {
            result = Str.isEmpty(result) ? Identifier.classname(moduleName) : result + "." + Identifier.classname(moduleName);
        }
        return result;
    }

    public static String localname(String qname) {
        if (qname != null) {
            qname = qname.substring(qname.lastIndexOf(58) + 1);
        }
        return qname;
    }

    public static String prefix(String qname) {
        int index;
        String result = "";
        if (qname != null && (index = qname.lastIndexOf(58)) != -1) {
            result = qname.substring(0, index);
        }
        return result;
    }

    public static boolean isSFS(String uri) {
        return uri != null && uri.startsWith("http://www.w3.org/") && uri.endsWith("/XMLSchema");
    }

    private static boolean isJavaReservedWord(String word) {
        return XmlUtils.isJavaReservedWord(word, true);
    }

    private static boolean isJavaReservedWord(String word, boolean ignore_case) {
        if (ignore_case) {
            word = word.toLowerCase();
        }
        return javaWords.contains(word);
    }

    private static int findSchemeColon(String uri) {
        int i;
        int len = uri.length();
        if (len == 0) {
            return -1;
        }
        if (!XmlUtils.isUriAlphaChar(uri.charAt(0))) {
            return -1;
        }
        for (i = 1; i < len && XmlUtils.isUriSchemeChar(uri.charAt(i)); ++i) {
        }
        if (i == len) {
            return -1;
        }
        if (uri.charAt(i) != ':') {
            return -1;
        }
        while (i < len && uri.charAt(i) == ':') {
            ++i;
        }
        return i - 1;
    }

    private static String processFilename(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && (i + 1 + 2 == filename.length() || i + 1 + 3 == filename.length() || filename.substring(i + 1).toLowerCase().equals("html"))) {
            return filename.substring(0, i);
        }
        return filename;
    }

    private static List<String> splitDNS(String dns) {
        ArrayList<String> result = new ArrayList<String>();
        int end = dns.length();
        for (int begin = dns.lastIndexOf(46); begin != -1; --begin) {
            if (dns.charAt(begin) != '.') continue;
            result.add(XmlUtils.jlsString(dns.substring(begin + 1, end)));
            end = begin;
        }
        result.add(XmlUtils.jlsString(dns.substring(0, end)));
        if (result.size() >= 3 && ((String)result.get(result.size() - 1)).toLowerCase().equals("www")) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    private static String jlsString(String name) {
        StringBuilder buf = new StringBuilder(name);
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(buf.charAt(i)) && '$' != buf.charAt(i)) continue;
            buf.setCharAt(i, '_');
        }
        if (buf.length() == 0 || !Character.isJavaIdentifierStart(buf.charAt(0))) {
            buf.insert(0, '_');
        }
        if (XmlUtils.isJavaReservedWord(name)) {
            buf.append('_');
        }
        return buf.toString();
    }

    private static String nonJavaKeyword(String word) {
        if (XmlUtils.isJavaReservedWord(word)) {
            return 'x' + word;
        }
        return word;
    }

    private static String lowerCamelCase(String xml_name, boolean useJaxRpcRules, boolean fixGeneratedName) {
        StringBuilder buf = new StringBuilder();
        List<String> words = XmlUtils.splitWords(xml_name, useJaxRpcRules);
        if (!words.isEmpty()) {
            String first = words.get(0).toLowerCase();
            char f = first.charAt(0);
            if (!Character.isJavaIdentifierStart(f) && fixGeneratedName) {
                buf.append("x");
            }
            buf.append(first);
            Iterator<String> itr = words.iterator();
            itr.next();
            while (itr.hasNext()) {
                buf.append(itr.next());
            }
        }
        return buf.toString();
    }

    private static List<String> splitWords(String name, boolean useJaxRpcRules) {
        ArrayList<String> list = new ArrayList<String>();
        int len = name.length();
        int start = 0;
        int prefix = 0;
        for (int i = 0; i < len; ++i) {
            int current = XmlUtils.getCharClass(name.charAt(i), useJaxRpcRules);
            if (prefix != 1 && current == 1) {
                XmlUtils.addCapped(list, name.substring(start, i));
                while ((current = XmlUtils.getCharClass(name.charAt(i), useJaxRpcRules)) == 1) {
                    if (++i < len) continue;
                    return list;
                }
                start = i;
            } else if (prefix == 2 != (current == 2) || prefix == 5 && current != 5 || XmlUtils.isLetter(prefix) != XmlUtils.isLetter(current)) {
                XmlUtils.addCapped(list, name.substring(start, i));
                start = i;
            } else if (prefix == 4 && current == 5 && i > start + 1) {
                XmlUtils.addCapped(list, name.substring(start, i - 1));
                start = i - 1;
            }
            prefix = current;
        }
        XmlUtils.addCapped(list, name.substring(start));
        return list;
    }

    private static void addCapped(List<String> list, String str) {
        if (str.length() > 0) {
            list.add(Identifier.capitalize(str));
        }
    }

    private static boolean isUriAlphaChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isLetter(int state) {
        return state == 4 || state == 5 || state == 6;
    }

    private static boolean isUriSchemeChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '.' || ch == '+';
    }

    private static int getCharClass(char c, boolean useJaxRpcRules) {
        if (XmlUtils.isPunctuation(c, useJaxRpcRules)) {
            return 1;
        }
        if (Character.isDigit(c)) {
            return 2;
        }
        if (Character.isUpperCase(c)) {
            return 4;
        }
        if (Character.isLowerCase(c)) {
            return 5;
        }
        if (Character.isLetter(c)) {
            return 6;
        }
        if (Character.isJavaIdentifierPart(c)) {
            return 3;
        }
        return 1;
    }

    private static boolean isPunctuation(char c, boolean useJaxRpcRules) {
        return c == '-' || c == '.' || c == ':' || c == '\u00b7' || c == '_' && !useJaxRpcRules || c == '\u0387' || c == '\u06dd' || c == '\u06de';
    }

    private static String getModuleFromNamespace(String namespace) {
        String module = null;
        if (namespace != null) {
            String text = XmlUtils.getPackageFromNamespace(namespace, true);
            module = XmlUtils.buildValidQualifiedModuleName(text);
        }
        return module;
    }
}

