/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.filter;

import java.io.Serializable;

public class Operation
implements Serializable {
    private Operation[] operands;
    private int operator;
    private String opText;
    private String value;
    public static final int PARAMETER = 0;
    public static final int ATTRIBUTE = 1;
    public static final int EQUAL = 2;
    public static final int NOT_EQUAL = 3;
    public static final int GT = 4;
    public static final int LT = 5;
    public static final int GE = 6;
    public static final int LE = 7;
    public static final int LIKE = 70;
    public static final int IN = 71;
    public static final int AND = 8;
    public static final int OR = 9;
    public static final int XOR = 10;
    public static final int IMPLIES = 11;
    public static final int NOT = 12;
    public static final int REM = 120;
    public static final int ADD = 13;
    public static final int SUB = 14;
    public static final int MUL = 15;
    public static final int DIV = 16;
    public static final int NEGATE = 17;
    public static final int CONCAT = 18;
    public static final int FUNCTION = 19;
    public static final int INT = 20;
    public static final int DECIMAL = 21;
    public static final int REAL = 22;
    public static final int INTERVAL = 23;
    public static final int TIME = 24;
    public static final int BOOL = 25;
    public static final int BINARY = 26;
    public static final int STRING = 27;
    public static final int NULL = 28;
    static final long serialCheck = 4262399576659804105L;
    static final long serialVersionUID = -4214768945556546822L;

    public Operation(int op, String opText, Operation[] operands) {
        this(op, opText, operands, null);
    }

    public Operation(int op, String opText, Operation[] operands, String value) {
        this.operator = op;
        this.operands = operands;
        this.opText = opText;
        this.value = value;
        if (this.operands == null) {
            this.operands = new Operation[0];
        }
    }

    public Operation[] getOperands() {
        return this.operands;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getOperatorText() {
        return this.opText;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.dump("");
    }

    private String dump(String indent) {
        String description = this.getOperatorText();
        if (description == null) {
            description = this.getValue();
        }
        String text = indent + description + "\n";
        if (this.operands != null) {
            for (int i = 0; i < this.operands.length; ++i) {
                text = text + this.operands[i].dump(indent + "    ");
            }
        }
        return text;
    }
}

