/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.filter;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.filter.FilterNotSupportedException;
import oracle.bpm.type.filter.IteratorFilterProvider;
import oracle.bpm.type.filter.Operation;

public class IterablesByFilterRegistry {
    private static final Map<String, IteratorFilterProvider> iterators = new HashMap<String, IteratorFilterProvider>();

    public static void add(String type, IteratorFilterProvider provider) {
        iterators.put(type, provider);
    }

    public static String get(TypeDescription typeDescription, Operation operation) throws FilterNotSupportedException {
        assert (IterablesByFilterRegistry.contains(typeDescription));
        String componentType = typeDescription.asObject().getComponentType();
        return iterators.get(componentType).getIteratorFilter(typeDescription, operation);
    }

    public static boolean contains(TypeDescription typeDescription) {
        return iterators.keySet().contains(typeDescription.asObject().getComponentType());
    }
}

