/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.DocumentationBundleMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.type.catalog.DocumentationBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocumentationProvider {
    private final Object bundleLock = new Object();
    private List<DocumentationBundle> bundles;
    private static final DocumentationProvider ourInstance = new DocumentationProvider();

    private DocumentationProvider() {
    }

    public static DocumentationProvider getInstance() {
        return ourInstance;
    }

    @Nullable
    public String getDocumentation(@NotNull TypeDescription type, @NotNull Locale locale) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/catalog/DocumentationProvider.getDocumentation must not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/catalog/DocumentationProvider.getDocumentation must not be null");
        }
        this.loadDocumentation();
        for (DocumentationBundle bundle : this.bundles) {
            String doc = bundle.getDocumentation(type, locale);
            if (doc == null) continue;
            return doc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDocumentation() {
        Object object = this.bundleLock;
        synchronized (object) {
            if (this.bundles == null) {
                this.bundles = new ArrayList<DocumentationBundle>();
                ExtensionService service = Platform.getExtensionService();
                List<Extension<DocumentationBundleMetadata>> extensions = service.getExtensionsByPoint(DocumentationBundleMetadata.class);
                for (Extension<DocumentationBundleMetadata> extension : extensions) {
                    try {
                        DocumentationBundle bundle = extension.instantiateAs(DocumentationBundle.class);
                        this.bundles.add(bundle);
                    }
                    catch (InstantiationException e) {
                        Log.logSevere(e);
                    }
                }
            }
        }
    }
}

