/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.util.List;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.type.catalog.ComponentBundleListener;

public class CompositeComponentBundleListener
implements ComponentBundleListener {
    private List<ComponentBundleListener> listeners = CollectionFactory.createList();
    private static final ComponentBundleListener[] EMPTY_ARRAY = new ComponentBundleListener[0];

    @Override
    public void typeAdded(String typeName, ComponentBundle bundle) {
        ComponentBundleListener[] safeCopy;
        for (ComponentBundleListener listener : safeCopy = this.listeners.toArray(EMPTY_ARRAY)) {
            listener.typeAdded(typeName, bundle);
        }
    }

    @Override
    public void typeRemoved(String typeName, ComponentBundle bundle) {
        ComponentBundleListener[] safeCopy;
        for (ComponentBundleListener listener : safeCopy = this.listeners.toArray(EMPTY_ARRAY)) {
            listener.typeRemoved(typeName, bundle);
        }
    }

    public void addBundleListener(ComponentBundleListener listener) {
        this.listeners.add(listener);
    }

    public void removeBundleListener(ComponentBundleListener listener) {
        this.listeners.remove(listener);
    }
}

