/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.io.File;
import java.util.Arrays;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.type.catalog.ComponentBundleListener;
import oracle.bpm.type.catalog.CompositeComponentBundleListener;
import oracle.bpm.type.catalog.MutableComponentBundle;

public abstract class AbstractComponentBundle
implements ComponentBundle {
    private String displayName;
    private long lastModified = -1L;
    private CompositeComponentBundleListener listener = new CompositeComponentBundleListener();
    private Exception stackTrace = new Exception();
    private String uniqueId;

    @Override
    public void addBundleListener(ComponentBundleListener listener) {
        this.listener.addBundleListener(listener);
    }

    @Override
    public void removeBundleListener(ComponentBundleListener listener) {
        this.listener.removeBundleListener(listener);
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public long getLastModifiedTime(String typeName) {
        return this.lastModified();
    }

    @Override
    public long lastModified() {
        return this.lastModified != -1L ? System.currentTimeMillis() : this.lastModified;
    }

    public void setModified() {
        this.lastModified = System.currentTimeMillis();
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public boolean hasChangedFrom(long date) {
        return this.lastModified() > date;
    }

    @Override
    public boolean isMutable() {
        return this instanceof MutableComponentBundle;
    }

    @Override
    public MutableComponentBundle asMutable() throws UnsupportedOperationException {
        if (this.isMutable()) {
            return (MutableComponentBundle)((Object)this);
        }
        throw new UnsupportedOperationException("Not a mutable component source: " + this);
    }

    public boolean equals(Object obj) {
        assert (this.getUniqueId() != null) : this.getClass() + " does not have id " + Arrays.asList(this.stackTrace.getStackTrace());
        if (obj instanceof ComponentBundle) {
            ComponentBundle other = (ComponentBundle)obj;
            return this.getUniqueId().equals(other.getUniqueId());
        }
        return false;
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    @Override
    public TypeInfo loadHeader(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        return new TypeInfo(this.loadType(typeName, parentName, catalog).asObject());
    }

    @Override
    public File getBasePath() {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void reloadType(TypeRef type) throws TypeCatalogException {
    }

    protected ComponentBundleListener getListener() {
        return this.listener;
    }

    protected void setUniqueId(String uniqueId) {
        assert (uniqueId != null) : "Null unique id";
        this.uniqueId = uniqueId;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

