/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.DescriptionEnabled;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.observers.ObservableObject;
import oracle.bpm.type.IdentifiableType;
import oracle.bpm.type.TypeHolder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;

public class Variable
implements TypeHolder,
Comparable<Variable>,
Cloneable,
ObservableObject,
DescriptionEnabled {
    protected String description;
    protected String name;
    protected MethodTypeDescription parent;
    protected TypeRef type;
    private Map<String, List<ObjectPropertyListener>> propertiesObservers = CollectionFactory.createMap();
    private Map<String, List<ObjectRelationListener>> relationObservers = CollectionFactory.createMap();

    public Variable(String name, TypeRef type) {
        this.setType(type);
        this.setName(name);
        this.description = "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        if (this.type instanceof IdentifiableType && other.type instanceof IdentifiableType) {
            return this.type.equals(other.type);
        }
        return (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.type == other.type || this.type != null && other.type != null && this.type.getText().equals(other.type.getText()));
    }

    public int hashCode() {
        int hash = this.name == null ? 0 : 31 * this.name.hashCode();
        return hash + (this.type == null ? 0 : this.type.getText().hashCode());
    }

    @Override
    public void addPropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getSpecificPropertyObservers(propertyName).add(observer);
    }

    @Override
    public void removePropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getSpecificPropertyObservers(propertyName).remove(observer);
    }

    @Override
    public void addRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).add(observer);
    }

    @Override
    public void removeRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).remove(observer);
    }

    @Override
    public void setName(String name) {
        if (!Any.equals(name, this.name)) {
            this.name = name;
            this.firePropertyChanged("name");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setParent(MethodTypeDescription parent) {
        this.parent = parent;
    }

    public MethodTypeDescription getParent() {
        return this.parent;
    }

    public void setProperties(Properties props) throws InvocationTargetException, IllegalAccessException {
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        Class<?> cl = this.getClass();
        while (it.hasNext()) {
            Map.Entry<Object, Object> key = it.next();
            String value = (String)key.getValue();
            try {
                Method m = cl.getMethod("set" + Identifier.capitalize((String)key.getKey()), String.class);
                m.invoke((Object)this, value);
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Override
    public void setType(TypeRef type) {
        this.type = type != null ? type.getRef() : null;
        this.firePropertyChanged("type");
    }

    @Override
    public TypeDescription getType() {
        return this.type != null ? this.type.get() : null;
    }

    public TypeRef getTypeRef() {
        return this.type;
    }

    public String getTypeText() {
        return this.getTypeRef().getText();
    }

    public Variable clone() {
        try {
            Variable variable = (Variable)super.clone();
            variable.parent = null;
            variable.propertiesObservers = CollectionFactory.createMap();
            variable.relationObservers = CollectionFactory.createMap();
            return variable;
        }
        catch (CloneNotSupportedException e) {
            assert (false) : "Cannot Clone Variable";
            return this;
        }
    }

    @Override
    public int compareTo(Variable o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.name + " : " + this.type;
    }

    @Override
    public void setDescription(String descr) {
        this.description = descr;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected List<ObjectPropertyListener> getSpecificPropertyObservers(String propertyName) {
        if (!this.propertiesObservers.containsKey(propertyName)) {
            this.propertiesObservers.put(propertyName, CollectionFactory.createList());
        }
        return this.propertiesObservers.get(propertyName);
    }

    protected void firePropertyChanged(String propertyName) {
        for (ObjectPropertyListener observer : this.getPropertyObservers(propertyName)) {
            try {
                if (observer == null) continue;
                observer.propertyChanged(this, propertyName);
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
        }
    }

    private List<ObjectRelationListener> getRelationsObservers(String relationName) {
        if (!this.relationObservers.containsKey(relationName)) {
            this.relationObservers.put(relationName, CollectionFactory.createList());
        }
        return this.relationObservers.get(relationName);
    }

    private List<ObjectPropertyListener> getPropertyObservers(String propertyName) {
        ArrayList<ObjectPropertyListener> list = new ArrayList<ObjectPropertyListener>();
        list.addAll(this.getSpecificPropertyObservers(propertyName));
        list.addAll(this.getSpecificPropertyObservers("__all__"));
        return list;
    }
}

