/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.type.Argument;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.Validation;
import oracle.bpm.type.Variable;
import oracle.bpm.util.documentation.DocumentationType;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.xml.XFormSerializer;

public class TypeWriter45 {
    private static final String SCALE = "scale";
    private static final String LENGTH = "length";
    private static final String ARRAY = "array";
    private static final String MAP = "map";
    private static final String ITERATOR = "iterator";
    private static final String OBJECT = "object";
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final String CLASS_NAME = "className";
    private static final String ENUMERATION = "enumeration";
    private static final String LABEL = "label";
    private static final String ITEM = "item";
    private static final String XOBJECT_BASE = "XObjectBase";
    private static final String REPLACEMENT = "replacement";
    private static final String METHOD = "method";
    private static final String VALUE = "value";
    private static final String TARGET_NAME = "targetName";
    private static final String TARGET_TYPE = "targetType";
    private static final String TRANSFORMATION = "transformation";
    private static final String TRANSFORMATION_SOURCE = "transformationSource";
    private static final String BEGIN_CODE = "beginCode";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ENSURE = "ensure";
    private static final String VARIABLES = "variables";
    private static final String VARIABLE = "variable";
    private static final String TEMPLATE = "template";
    private static final String REQUIRE = "require";
    private static final String OUTPUT_ARGUMENT = "outputArgument";
    private static final String MESSAGE = "message";
    private static final String CHECK = "check";
    private static final String EMTPY_STRING = "";
    private static final String EXCEPTION = "exception";
    private static final String LANGUAGE = "language";
    private static final String SOURCE_CODE = "sourceCode";
    private static final String DOCUMENTATION = "documentation";
    private static final String PROPERTY = "property";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String PRIMITIVE = "primitive";
    private static final String ARGUMENT = "arg";
    private static final String JAVA_TYPE = "javaType";
    private static final String TRANSFORMATIONS = "transformations";
    private static final String METHODS = "methods";
    private static final String ATTRIBUTES = "attributes";
    private static final String OBJECT_PROPERTY = "objectProperty";
    private static final String CLASS = "class";
    private static final String INHERIT = "inherit";
    private static final String ELEMENT_TYPE = "elementType";
    private static final String TYPE = "type";
    private static final String DYNAMIC = "dynamic";
    private static final String REMOTE = "remote";
    private static final String SIGNATURE = "signature";
    private static final String FLAGS = "flags";
    private static final String VERSIONID = "versionID";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String COMPONENT = "component";
    public static final String OTD_DEFAULT_TAG_NAME = "component";
    public static final String RESOURCES = "resources";
    public static final String RESOURCE = "resource";
    public static final String RESOURCE_DEFAULT = "default";
    public static final String RESOURCE_TYPE = "type";
    public static final String RESOURCE_LABEL = "label";
    public static final String LOCALEMAP_LANGUAGE = "language";

    public static void writeXML(ObjectTypeDescription otd, String name, Writer writer) {
        TypeWriter45.writeXML(otd, name, true, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(ObjectTypeDescription otd, String name, boolean printHeader, Writer writer) {
        XmlWriter xml = new XmlWriter(writer, "UTF-8");
        try {
            try {
                if (otd instanceof JavaEnumTypeDescription) {
                    TypeWriter45.writeEnumeration((JavaEnumTypeDescription)otd, xml);
                } else {
                    if (printHeader) {
                        xml.startDocument();
                    }
                    TypeWriter45.writeXml(xml, otd, name);
                }
            }
            finally {
                xml.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(ObjectTypeDescription otd, File targetFile) throws IOException {
        TypeWriter45.writeXML(otd, "component", new FileWriter(targetFile));
    }

    public static void writeAttribute(ObjectTypeDescription otd, XmlWriter xml, MethodTypeDescription member, boolean group) throws IOException {
        SourceCode writeCode;
        if (member.isSynthesized()) {
            return;
        }
        TypeDescription type = member.getResultType();
        if (group && type instanceof ArrayTypeDescription) {
            type = type.getElementType();
        }
        String modifiersText = Modifier.getText(member.getModifiers());
        AttributeTypeDescription attribute = member.asAttribute();
        if (type.getKind() == 12) {
            xml.startElement(ARRAY);
            xml.printAttribute("type", type.getElementType().getText());
        } else if (type.getKind() == 13) {
            xml.startElement(MAP);
            xml.printAttribute("type", type.getElementType().getText());
            xml.printAttribute("indexType", type.getIndexType().getText());
            xml.printAttribute("ordered", type.isOrdered());
        } else if (type.getKind() == 16) {
            xml.startElement(ITERATOR);
            xml.printAttribute("type", type.getElementType().getText());
        } else {
            if (type.isPredefined()) {
                xml.startElement(type.getName());
            } else {
                xml.startElement(OBJECT);
                xml.printAttribute("type", type.getText());
            }
            if (type.getLength() != -1) {
                xml.printAttribute(LENGTH, String.valueOf(type.getLength()));
            }
            if (type.getScale() != -1) {
                xml.printAttribute(SCALE, String.valueOf(type.getScale()));
            }
            xml.printAttribute(DEFAULT_VALUE, attribute.getDefaultValue());
            TypeWriter45.printDelimited(xml, "validValues", attribute.getValidValues(), "|");
            if (attribute.getPrecision() != -1) {
                xml.printAttribute("precision", String.valueOf(attribute.getPrecision()));
            }
        }
        xml.printAttribute(NAME, member.getName());
        xml.printAttribute(REPLACEMENT, member.getReplacement());
        xml.printAttribute(DESCRIPTION, member.getDescription());
        xml.printAttribute(TEMPLATE, member.getTemplate());
        xml.printAttribute(FLAGS, modifiersText);
        xml.printAttribute(PRIMITIVE, type.isPrimitive());
        int position = attribute.getPosition();
        if (position != -1) {
            xml.printAttributeForced("position", position);
        }
        Argument result = member.getResultArgument();
        TypeWriter45.printJavaType(result, xml);
        if (!otd.isBpmObject()) {
            xml.printAttribute("writeSignature", attribute.getWriteSignature());
            xml.printAttribute("readSignature", member.getSignature());
        }
        TypeWriter45.writeRequire(member, xml);
        TypeWriter45.writeEnsure(member, xml);
        TypeWriter45.writeIntegrityCheck(member, xml);
        SourceCode readCode = member.getCode();
        if (readCode != null) {
            String text = new String(readCode.getText());
            xml.startElement(READ);
            xml.printAttribute("language", readCode.getLanguage());
            for (Variable var : attribute.getVariables()) {
                TypeWriter45.writeVariable(var, xml);
            }
            xml.printChars(text.trim());
            xml.endElement();
        }
        if ((writeCode = member.asAttribute().getWriteCode()) != null) {
            String text = new String(writeCode.getText());
            xml.startElement(WRITE);
            xml.printAttribute("language", writeCode.getLanguage());
            for (Variable var : attribute.getWriteVariables()) {
                TypeWriter45.writeVariable(var, xml);
            }
            xml.printChars(text.trim());
            xml.endElement();
        }
        TypeWriter45.writeProperties(xml, PROPERTY, member.getProperties());
        TypeWriter45.writeDocumentation(member, xml);
        TypeWriter45.writeDisplayNames(member, xml);
        xml.endElement();
    }

    public static void writeEnumeration(JavaEnumTypeDescription enumType, XmlWriter xmlWriter) {
        try {
            int i;
            int length;
            xmlWriter.startDocument();
            xmlWriter.startElement(ENUMERATION);
            xmlWriter.setIgnoreEmpty(false);
            xmlWriter.printAttribute(NAME, enumType.getName());
            xmlWriter.printAttribute(CLASS_NAME, enumType.getOriginalClass());
            xmlWriter.printAttribute(VERSIONID, enumType.getVersionID());
            xmlWriter.printAttribute("type", enumType.getComponentType());
            if (enumType.isNativeEnum()) {
                xmlWriter.printAttribute("native", true);
            }
            xmlWriter.setIgnoreEmpty(true);
            xmlWriter.printAttribute(DESCRIPTION, enumType.getDescription());
            TypeWriter45.writeProperties(xmlWriter, OBJECT_PROPERTY, enumType.getProperties());
            String[] labels = enumType.getLabels();
            int[] values = enumType.getValues();
            int n = length = labels != null ? labels.length : 0;
            if (labels != null) {
                for (i = 0; i < length; ++i) {
                    xmlWriter.startElement(ITEM);
                    xmlWriter.printAttribute("label", labels[i]);
                    if (!enumType.isSequential()) {
                        xmlWriter.printAttribute(VALUE, String.valueOf(values[i]));
                    }
                    xmlWriter.endElement();
                }
            }
            if (enumType.isNativeEnum()) {
                for (i = length; i < enumType.getMemberCount(); ++i) {
                    TypeWriter45.writeMember(enumType, xmlWriter, enumType.getMember(i));
                }
            }
            TypeWriter45.writeDocumentation(enumType, xmlWriter);
            TypeWriter45.writeDisplayNames(enumType, xmlWriter);
            xmlWriter.endElement();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.logSevere(e);
        }
    }

    public static void writeMethod(ObjectTypeDescription otd, XmlWriter xml, MethodTypeDescription mtd) throws IOException {
        TypeDescription cl = mtd.getParent();
        if (cl != null && cl.getName().equals(XOBJECT_BASE)) {
            return;
        }
        while (mtd != null) {
            if (!mtd.isSynthesized()) {
                xml.startElement(METHOD);
                xml.printAttribute(NAME, mtd.getName());
                xml.printAttribute(REPLACEMENT, mtd.getReplacement());
                xml.printAttribute(DESCRIPTION, mtd.getDescription());
                xml.printAttribute(FLAGS, Modifier.getText(mtd.getModifiers()));
                if (!otd.isBpmObject()) {
                    xml.printAttribute(SIGNATURE, mtd.getSignature());
                }
                TypeWriter45.writeRequire(mtd, xml);
                TypeWriter45.writeEnsure(mtd, xml);
                TypeWriter45.writeTemplate(mtd, xml);
                TypeWriter45.writeArguments(mtd, xml);
                TypeWriter45.writeVariables(mtd, xml);
                TypeWriter45.writeOutputArgument(mtd, xml);
                TypeWriter45.writeExceptions(mtd, xml);
                TypeWriter45.writeCode(mtd, xml);
                TypeWriter45.writeProperties(xml, PROPERTY, mtd.getProperties());
                TypeWriter45.writeDocumentation(mtd, xml);
                TypeWriter45.writeDisplayNames(mtd, xml);
                xml.endElement();
            }
            mtd = mtd.getNextMethod();
        }
    }

    public static void writePresentations(ObjectTypeDescription otd, XmlWriter xml) throws IOException {
        XObjectTypeDescription xotd;
        Map<String, XFormPresentationModel> presentations;
        if (otd instanceof XObjectTypeDescription && (presentations = (xotd = (XObjectTypeDescription)otd).getPresentations()) != null) {
            Collection<XFormPresentationModel> models = presentations.values();
            for (XFormPresentationModel presentation : models) {
                XFormSerializer.serialize(xml, presentation.presentation_d);
            }
        }
    }

    public static void writeProperties(XmlWriter xml, String tagname, Map<String, String> properties) throws IOException {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            xml.startElement(tagname);
            xml.printAttribute(NAME, entry.getKey());
            xml.printAttribute(VALUE, entry.getValue());
            xml.endElement();
        }
    }

    public static void writeTransformation(XmlWriter xml, MethodTypeDescription m) throws IOException {
        SourceCode end;
        int j;
        TransformTypeDescription mtd = (TransformTypeDescription)m;
        xml.startElement(TRANSFORMATION);
        xml.printAttribute(NAME, mtd.getName());
        xml.printAttribute(TARGET_TYPE, mtd.getTarget().getText());
        xml.printAttribute(TARGET_NAME, mtd.getTargetName());
        if (mtd.getSourceCount() > 0) {
            for (j = 0; j < mtd.getSourceCount(); ++j) {
                TypeDescription sourceType = mtd.getSource(j);
                String sourceName = mtd.getSourceName(j);
                xml.startElement(TRANSFORMATION_SOURCE);
                xml.printAttribute(NAME, sourceName);
                xml.printAttribute("type", sourceType.getText());
                xml.endElement();
            }
        }
        for (j = 0; j < mtd.getFieldMappingCount(); ++j) {
            TransformTypeDescription.FieldMapping fieldMapping = mtd.getFieldMapping(j);
            SourceCode mappingCode = fieldMapping.getCode();
            xml.startElement("fieldMapping");
            xml.printAttribute("targetField", fieldMapping.getTargetField());
            xml.printAttribute("isExpression", fieldMapping.isExpression());
            xml.printAttribute("language", mappingCode.getLanguage());
            String code = String.valueOf(fieldMapping.getCodeText());
            if (code != null && !code.equals(EMTPY_STRING)) {
                xml.printChars(code.trim());
            }
            xml.endElement();
        }
        SourceCode begin = mtd.getBeginCode();
        if (begin != null && !begin.isEmpty()) {
            xml.startElement(BEGIN_CODE);
            xml.printAttribute("language", begin.getLanguage());
            xml.printChars(String.valueOf(begin.getText()));
            xml.endElement();
        }
        if ((end = mtd.getEndCode()) != null && !end.isEmpty()) {
            xml.startElement("endCode");
            xml.printAttribute("language", end.getLanguage());
            xml.printChars(String.valueOf(end.getText()));
            xml.endElement();
        }
        if (mtd.hasVariables()) {
            xml.startElement("localVars");
            for (Variable localVar : mtd.getVariables()) {
                xml.startElement("localVar");
                xml.printAttribute("varName", localVar.getName());
                xml.printAttribute("varType", localVar.getTypeRef().getText());
                xml.endElement();
            }
            xml.endElement();
        }
        xml.endElement();
    }

    public static void writeXml(XmlWriter xml, ObjectTypeDescription otd, String name) throws IOException {
        xml.startElement(name);
        xml.printAttribute(NAME, otd.getName());
        xml.printAttribute(DESCRIPTION, otd.getDescription());
        xml.printAttribute(VERSIONID, otd.getVersionID());
        xml.printAttribute(FLAGS, Modifier.getText(otd.getModifiers()));
        xml.setIgnoreEmpty(false);
        xml.setIgnoreEmpty(true);
        if (!otd.isBpmObject()) {
            xml.printAttribute(SIGNATURE, otd.getSignature());
        }
        xml.printAttribute(REMOTE, otd.isRemote());
        xml.printAttribute(DYNAMIC, Modifier.isInvokeable(otd.getModifiers()));
        xml.printAttribute("type", otd.getComponentType());
        TypeDescription elementType = otd.getElementType();
        if (elementType != null) {
            xml.printAttribute(ELEMENT_TYPE, elementType.getText());
        }
        for (SuperType superType : otd.getSuperTypes()) {
            TypeDescription type = superType.getType();
            if (type.isNone() && !(type instanceof DynamicRef)) continue;
            xml.startElement(INHERIT);
            xml.printAttribute(CLASS, type.getText());
            xml.printAttribute(FLAGS, Modifier.getText(superType.getModifiers()));
            xml.endElement();
        }
        TypeWriter45.writeProperties(xml, OBJECT_PROPERTY, otd.getProperties());
        xml.startElement(ATTRIBUTES);
        for (MethodTypeDescription member : otd.getAttributes()) {
            TypeWriter45.writeAttribute(otd, xml, member, false);
        }
        xml.endElement();
        xml.startElement(METHODS);
        int count = otd.getMemberCount();
        for (int i = 0; i < count; ++i) {
            if (!otd.getMemberType(i).isMethod()) continue;
            TypeWriter45.writeMethod(otd, xml, otd.getMember(i));
        }
        xml.endElement();
        MethodTypeDescription[] transformations = otd.getMembers(20);
        if (transformations.length > 0) {
            xml.startElement(TRANSFORMATIONS);
            for (MethodTypeDescription transformation : transformations) {
                TypeWriter45.writeTransformation(xml, transformation);
            }
            xml.endElement();
        }
        TypeWriter45.writeDocumentation(otd, xml);
        TypeWriter45.writeDisplayNames(otd, xml);
        TypeWriter45.writePresentations(otd, xml);
        TypeWriter45.writeResources(otd, xml);
        xml.endElement();
    }

    public static void writeResources(ObjectTypeDescription otd, XmlWriter xml) throws IOException {
        XObjectTypeDescription xotd;
        Map<String, XObjectTypeDescription.ResourceValue> resources;
        if (otd instanceof XObjectTypeDescription && (resources = (xotd = (XObjectTypeDescription)otd).getResources()) != null && !resources.isEmpty()) {
            xml.startElement(RESOURCES);
            Iterator<Map.Entry<String, XObjectTypeDescription.ResourceValue>> i$ = resources.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, XObjectTypeDescription.ResourceValue> o;
                Map.Entry<String, XObjectTypeDescription.ResourceValue> entry = o = i$.next();
                String keyText = entry.getKey();
                xml.startElement(RESOURCE);
                xml.printAttribute(RESOURCE_DEFAULT, keyText);
                XObjectTypeDescription.ResourceValue resourceValue = entry.getValue();
                xml.printAttribute("type", resourceValue.getType());
                LocaleStringMap value = resourceValue.getLocaleMap();
                xml.printLocalizedElements("label", value);
                xml.endElement();
            }
            xml.endElement();
        }
    }

    private static boolean isGroupArray(String standardType) {
        return standardType.equals("oracle.bpm.util.LegacyGroupArray") || standardType.equals("oracle.bpm.xobject.GroupArray");
    }

    private static void printDelimited(XmlWriter xml, String attName, List<String> elements, String delimiter) throws IOException {
        if (elements == null) {
            return;
        }
        StringBuilder text = new StringBuilder();
        Iterator<String> it = elements.iterator();
        while (it.hasNext()) {
            text.append(String.valueOf(it.next()));
            if (!it.hasNext()) continue;
            text.append(delimiter);
        }
        xml.printAttribute(attName, text.toString());
    }

    private static void printJavaType(Argument result, XmlWriter xml) throws IOException {
        String standardType = result.getType().getJavaType();
        String resultJavaType = result.getJavaType();
        if (resultJavaType != null && (standardType != null && TypeWriter45.isGroupArray(standardType) || result.isExternal())) {
            xml.printAttribute(JAVA_TYPE, resultJavaType);
        } else if (!Any.equals(standardType, resultJavaType) || resultJavaType != null && resultJavaType.indexOf(91) != -1 && !"byte[]".equals(resultJavaType)) {
            xml.printAttribute(JAVA_TYPE, resultJavaType);
        }
    }

    private static void writeArguments(MethodTypeDescription mtd, XmlWriter xml) throws IOException {
        if (mtd.getArgumentCount() > 0) {
            for (int j = 0; j < mtd.getArgumentCount(); ++j) {
                Argument arg = mtd.getArgument(j);
                TypeDescription argType = arg.getType();
                xml.startElement(ARGUMENT);
                xml.printAttribute(NAME, arg.getName());
                xml.printAttribute(DESCRIPTION, arg.getDescription());
                xml.printAttribute(FLAGS, Modifier.getText(arg.getModifiers()));
                xml.printAttribute(PRIMITIVE, argType.isPrimitive());
                xml.printAttribute("type", argType.getText());
                xml.printAttribute(DEFAULT_VALUE, arg.getDefaultValue());
                TypeWriter45.printJavaType(arg, xml);
                if (arg.hasProperties()) {
                    TypeWriter45.writeProperties(xml, PROPERTY, arg.getProperties());
                }
                xml.endElement();
            }
        }
    }

    private static void writeCode(MethodTypeDescription mtd, XmlWriter xml) throws IOException {
        SourceCode code = mtd.getCode();
        if (code != null) {
            String language = code.getLanguage();
            char[] codeText = code.getText();
            xml.startElement(SOURCE_CODE);
            xml.printAttribute("language", language);
            if (codeText != null && codeText.length > 0) {
                xml.printChars(new String(codeText), false, true, false);
            }
            xml.endElement();
        }
    }

    private static void writeDocumentation(TypeDescription td, XmlWriter xml) throws IOException {
        for (DocumentationType type : DocumentationType.values()) {
            LocaleStringMap languages = td.getDocumentation(type);
            for (Map.Entry entry : languages.entrySet()) {
                xml.startElement(DOCUMENTATION);
                xml.printAttribute("type", type.name());
                xml.printAttribute("language", ((Locale)entry.getKey()).toString());
                xml.printXMLCDATA((String)entry.getValue());
                xml.endElement();
            }
        }
    }

    private static void writeDisplayNames(TypeDescription td, XmlWriter xml) throws IOException {
        LocaleStringMap displayNames = td.getDisplayNames();
        for (Map.Entry<Locale, String> displayName : displayNames) {
            xml.startElement(DISPLAY_NAME);
            xml.printAttribute("language", displayName.getKey().toString());
            xml.printXMLCDATA(displayName.getValue());
            xml.endElement();
        }
    }

    private static void writeEnsure(MethodTypeDescription mtd, XmlWriter xml) throws IOException {
        Validation[] ensureCode = mtd.getEnsureCode();
        if (ensureCode != null) {
            for (Validation validation : ensureCode) {
                xml.startElement(ENSURE);
                xml.printAttribute("language", validation.getLanguage());
                xml.printAttribute(MESSAGE, validation.getMessage());
                xml.printChars(new String(validation.getText()));
                xml.endElement();
            }
        }
    }

    private static void writeExceptions(MethodTypeDescription mtd, XmlWriter xml) throws IOException {
        int length = mtd.getExceptionCount();
        for (int i = 0; i < length; ++i) {
            TypeDescription exception = mtd.getException(i);
            xml.startElement(EXCEPTION);
            xml.printAttribute("type", exception.getText());
            xml.endElement();
        }
    }

    private static void writeIntegrityCheck(MethodTypeDescription member, XmlWriter xml) throws IOException {
        Validation[] integrityCheckCode = member.getCheckCode();
        if (integrityCheckCode != null) {
            for (Validation sourceCode : integrityCheckCode) {
                String checkText = new String(sourceCode.getText());
                if (checkText.equals(EMTPY_STRING)) continue;
                xml.startElement(CHECK);
                xml.printAttribute("language", sourceCode.getLanguage());
                xml.printAttribute(MESSAGE, sourceCode.getMessage());
                xml.printChars(checkText);
                xml.endElement();
            }
        }
    }

    private static void writeMember(JavaEnumTypeDescription enumType, XmlWriter xml, MethodTypeDescription member) throws IOException {
        if (member.isAttribute()) {
            TypeWriter45.writeAttribute(enumType, xml, member, false);
        } else {
            TypeWriter45.writeMethod(enumType, xml, member);
        }
    }

    private static void writeOutputArgument(MethodTypeDescription mtd, XmlWriter xml) throws IOException {
        TypeDescription returnType = mtd.getResultType();
        if (returnType.getKind() != 0) {
            xml.startElement(OUTPUT_ARGUMENT);
            Argument resultArgument = mtd.getResultArgument();
            xml.printAttribute(NAME, resultArgument.getName());
            xml.printAttribute(DESCRIPTION, resultArgument.getDescription());
            xml.printAttribute(FLAGS, Modifier.getText(resultArgument.getModifiers()));
            xml.printAttribute(PRIMITIVE, returnType.isPrimitive());
            String type = returnType.getText();
            if (type == null) {
                Log.logWarning(LibMsg.TYPE_IS_NULL(returnType));
            }
            xml.printAttribute("type", type);
            TypeWriter45.printJavaType(resultArgument, xml);
            xml.endElement();
        }
    }

    private static void writeRequire(MethodTypeDescription mtd, XmlWriter xml) throws IOException {
        Validation[] requireCode = mtd.getRequireCode();
        if (requireCode != null) {
            for (Validation validation : requireCode) {
                String message = validation.getMessage();
                char[] text = validation.getText();
                if (text == null && message == null) continue;
                xml.startElement(REQUIRE);
                xml.printAttribute("language", validation.getLanguage());
                xml.printAttribute(MESSAGE, message);
                xml.printChars(text != null ? new String(text) : EMTPY_STRING);
                xml.endElement();
            }
        }
    }

    private static void writeTemplate(MethodTypeDescription mtd, XmlWriter xml) throws IOException {
        if (mtd.getTemplate() != null && !mtd.getTemplate().equals(EMTPY_STRING)) {
            xml.startElement(TEMPLATE);
            xml.printChars(mtd.getTemplate());
            xml.endElement();
        }
    }

    private static void writeVariable(Variable variable, XmlWriter xml) throws IOException {
        TypeRef argType = variable.getTypeRef();
        xml.startElement(VARIABLE);
        xml.printAttribute(NAME, variable.getName());
        xml.printAttribute("type", argType.getText());
        xml.endElement();
    }

    private static void writeVariables(MethodTypeDescription mtd, XmlWriter xml) throws IOException {
        if (mtd.hasVariables()) {
            xml.startElement(VARIABLES);
            for (Variable variable : mtd.getVariables()) {
                TypeWriter45.writeVariable(variable, xml);
            }
            xml.endElement();
        }
    }
}

